/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.collections.maps;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import oracle.bpm.collections.Tuple;
import org.jetbrains.annotations.NotNull;
import sun.misc.SharedSecrets;

public class EnumTupleMap<X extends Enum<X>, Y extends Enum<Y>, V>
implements Map<EnumTuple<X, Y>, V> {
    private transient Set<Map.Entry<EnumTuple<X, Y>, V>> entrySet;
    private transient Set<EnumTuple<X, Y>> keySet;
    private transient int size;
    private transient Collection<V> vals;
    private transient Object[][] values;
    private final Class<X> xClass;
    private X[] xUniverse;
    private final Class<Y> yClass;
    private Y[] yUniverse;
    private static final Object NULL = new Object();

    public EnumTupleMap(@NotNull Class<X> xClass, @NotNull Class<Y> yClass) {
        if (xClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/maps/EnumTupleMap.<init> must not be null");
        }
        if (yClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/collections/maps/EnumTupleMap.<init> must not be null");
        }
        this.entrySet = null;
        this.keySet = null;
        this.size = 0;
        this.vals = null;
        this.xClass = xClass;
        this.yClass = yClass;
        this.xUniverse = EnumTupleMap.getKeyUniverse(xClass);
        this.yUniverse = EnumTupleMap.getKeyUniverse(yClass);
        this.values = new Object[this.xUniverse.length][this.yUniverse.length];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.isValidKey(key) && this.valueFor(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        value = this.maskNull(value);
        Object[][] arr$ = this.values;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Object[] row;
            for (Object val : row = arr$[i$]) {
                if (!value.equals(val)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public V get(Object key) {
        return this.isValidKey(key) ? (V)this.unmaskNull(this.valueFor(key)) : null;
    }

    public V get(@NotNull X x, @NotNull Y y) {
        if (x == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/maps/EnumTupleMap.get must not be null");
        }
        if (y == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/collections/maps/EnumTupleMap.get must not be null");
        }
        return this.unmaskNull(this.values[((Enum)x).ordinal()][((Enum)y).ordinal()]);
    }

    @Override
    public V put(@NotNull EnumTuple<X, Y> key, V value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/maps/EnumTupleMap.put must not be null");
        }
        Object oldValue = this.values[key.x()][key.y()];
        this.values[key.x()][key.y()] = this.maskNull(value);
        if (oldValue == null) {
            ++this.size;
        }
        return this.unmaskNull(oldValue);
    }

    public V put(@NotNull X x, @NotNull Y y, V value) {
        if (x == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/maps/EnumTupleMap.put must not be null");
        }
        if (y == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/collections/maps/EnumTupleMap.put must not be null");
        }
        Object oldValue = this.values[((Enum)x).ordinal()][((Enum)y).ordinal()];
        this.values[((Enum)x).ordinal()][((Enum)y).ordinal()] = this.maskNull(value);
        if (oldValue == null) {
            ++this.size;
        }
        return this.unmaskNull(oldValue);
    }

    @Override
    public V remove(Object key) {
        if (!this.isValidKey(key)) {
            return null;
        }
        Object oldValue = this.valueFor(key);
        this.values[((EnumTuple)key).x()][((EnumTuple)key).y()] = null;
        if (oldValue != null) {
            --this.size;
        }
        return this.unmaskNull(oldValue);
    }

    @Override
    public void putAll(Map<? extends EnumTuple<X, Y>, ? extends V> m) {
        for (Map.Entry<EnumTuple<X, Y>, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        for (Object[] row : this.values) {
            Arrays.fill(row, null);
        }
        this.size = 0;
    }

    @Override
    public Set<EnumTuple<X, Y>> keySet() {
        Set<EnumTuple<X, Y>> ks = this.keySet;
        if (ks != null) {
            return ks;
        }
        this.keySet = new KeySet();
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<EnumTuple<X, Y>, V>> entrySet() {
        Set<Map.Entry<EnumTuple<X, Y>, V>> es = this.entrySet;
        if (es != null) {
            return es;
        }
        this.entrySet = new EntrySet();
        return this.entrySet;
    }

    @Override
    public Collection<V> values() {
        if (this.vals == null) {
            this.vals = new Values();
        }
        return this.vals;
    }

    private static <T extends Enum<T>> T[] getKeyUniverse(Class<T> keyType) {
        return SharedSecrets.getJavaLangAccess().getEnumConstantsShared(keyType);
    }

    private Object maskNull(Object value) {
        return value == null ? NULL : value;
    }

    private V unmaskNull(Object value) {
        return (V)(value == NULL ? null : value);
    }

    private boolean containsMapping(Object key, Object value) {
        return this.isValidKey(key) && this.maskNull(value).equals(this.valueFor(key));
    }

    private boolean isValidKey(Object key) {
        if (key == null) {
            return false;
        }
        if (key instanceof EnumTuple) {
            EnumTuple tuple = (EnumTuple)key;
            Class<?> firstClass = tuple.getFirst().getClass();
            Class<?> secondClass = tuple.getSecond().getClass();
            return this.xClass == firstClass || this.xClass.getSuperclass() == firstClass && this.yClass == secondClass || this.yClass.getSuperclass() == secondClass;
        }
        return false;
    }

    private boolean removeMapping(Object key, Object value) {
        if (!this.isValidKey(key)) {
            return false;
        }
        if (this.maskNull(value).equals(this.valueFor(key))) {
            this.values[((EnumTuple)key).x()][((EnumTuple)key).y()] = null;
            --this.size;
            return true;
        }
        return false;
    }

    private Object valueFor(Object key) {
        return this.values[((EnumTuple)key).x()][((EnumTuple)key).y()];
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return EnumTupleMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return EnumTupleMap.this.containsValue(o);
        }

        @Override
        public boolean remove(Object value) {
            value = EnumTupleMap.this.maskNull(value);
            for (int x = 0; x < EnumTupleMap.this.values.length; ++x) {
                for (int y = 0; y < EnumTupleMap.this.values[0].length; ++y) {
                    if (!value.equals(EnumTupleMap.this.values[x][y])) continue;
                    ((EnumTupleMap)EnumTupleMap.this).values[x][y] = null;
                    EnumTupleMap.this.size--;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void clear() {
            EnumTupleMap.this.clear();
        }
    }

    private class ValueIterator
    extends EnumTupleMapIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturnedIndex = this.index++;
            return EnumTupleMap.this.unmaskNull(this.getAtIndex(this.lastReturnedIndex));
        }
    }

    private class KeyTupleIterator
    extends EnumTupleMapIterator<EnumTuple<X, Y>> {
        private KeyTupleIterator() {
        }

        @Override
        public EnumTuple<X, Y> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturnedIndex = this.index++;
            return EnumTuple.create(EnumTupleMap.this.xUniverse[this.lastReturnedIndex / EnumTupleMap.this.yUniverse.length], EnumTupleMap.this.yUniverse[this.lastReturnedIndex % EnumTupleMap.this.yUniverse.length]);
        }
    }

    private class KeySet
    extends AbstractSet<EnumTuple<X, Y>> {
        private KeySet() {
        }

        @Override
        public Iterator<EnumTuple<X, Y>> iterator() {
            return new KeyTupleIterator();
        }

        @Override
        public int size() {
            return EnumTupleMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return EnumTupleMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            int oldSize = EnumTupleMap.this.size;
            EnumTupleMap.this.remove(o);
            return EnumTupleMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            EnumTupleMap.this.clear();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<EnumTuple<X, Y>, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<EnumTuple<X, Y>, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return EnumTupleMap.this.containsMapping(entry.getKey(), entry.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return EnumTupleMap.this.removeMapping(entry.getKey(), entry.getValue());
        }

        @Override
        public int size() {
            return EnumTupleMap.this.size;
        }

        @Override
        public void clear() {
            EnumTupleMap.this.clear();
        }
    }

    private class EntryIterator
    extends EnumTupleMapIterator<Map.Entry<EnumTuple<X, Y>, V>>
    implements Map.Entry<EnumTuple<X, Y>, V> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<EnumTuple<X, Y>, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturnedIndex = this.index++;
            return this;
        }

        @Override
        public EnumTuple<X, Y> getKey() {
            this.checkLastReturnedIndexForEntryUse();
            return EnumTuple.create(EnumTupleMap.this.xUniverse[this.lastReturnedIndex / EnumTupleMap.this.yUniverse.length], EnumTupleMap.this.yUniverse[this.lastReturnedIndex % EnumTupleMap.this.yUniverse.length]);
        }

        @Override
        public V getValue() {
            this.checkLastReturnedIndexForEntryUse();
            return EnumTupleMap.this.unmaskNull(this.getAtIndex(this.lastReturnedIndex));
        }

        @Override
        public V setValue(V value) {
            this.checkLastReturnedIndexForEntryUse();
            Object oldValue = EnumTupleMap.this.unmaskNull(this.getAtIndex(this.lastReturnedIndex));
            this.setAtIndex(this.lastReturnedIndex, EnumTupleMap.this.maskNull(value));
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (this.lastReturnedIndex < 0) {
                return o == this;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object ourValue = EnumTupleMap.this.unmaskNull(this.getAtIndex(this.lastReturnedIndex));
            Object hisValue = e.getValue();
            EnumTuple<Enum, Enum> ourKey = EnumTuple.create(EnumTupleMap.this.xUniverse[this.lastReturnedIndex / EnumTupleMap.this.yUniverse.length], EnumTupleMap.this.yUniverse[this.lastReturnedIndex % EnumTupleMap.this.yUniverse.length]);
            return e.getKey() == ourKey && (ourValue == hisValue || ourValue != null && ourValue.equals(hisValue));
        }

        private void checkLastReturnedIndexForEntryUse() {
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException("Entry was removed");
            }
        }
    }

    private abstract class EnumTupleMapIterator<T>
    implements Iterator<T> {
        int index = 0;
        int lastReturnedIndex = -1;

        private EnumTupleMapIterator() {
        }

        @Override
        public boolean hasNext() {
            while (this.index < EnumTupleMap.this.xUniverse.length * EnumTupleMap.this.yUniverse.length && this.getAtIndex(this.index) == null) {
                ++this.index;
            }
            return this.index != EnumTupleMap.this.xUniverse.length * EnumTupleMap.this.yUniverse.length;
        }

        @Override
        public void remove() {
            this.checkLastReturnedIndex();
            if (this.getAtIndex(this.lastReturnedIndex) != null) {
                this.setAtIndex(this.lastReturnedIndex, null);
                EnumTupleMap.this.size--;
            }
            this.lastReturnedIndex = -1;
        }

        protected Object getAtIndex(int idx) {
            return EnumTupleMap.this.values[idx / EnumTupleMap.this.yUniverse.length][idx % EnumTupleMap.this.yUniverse.length];
        }

        protected void setAtIndex(int index, Object value) {
            ((EnumTupleMap)EnumTupleMap.this).values[index / ((EnumTupleMap)EnumTupleMap.this).yUniverse.length][index % ((EnumTupleMap)EnumTupleMap.this).yUniverse.length] = value;
        }

        private void checkLastReturnedIndex() {
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException();
            }
        }
    }

    public static final class EnumTuple<X extends Enum<X>, Y extends Enum<Y>>
    extends Tuple<X, Y> {
        private static final long serialVersionUID = -5298794079142138287L;

        protected EnumTuple(@NotNull X x, @NotNull Y y) {
            if (x == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/maps/EnumTupleMap$EnumTuple.<init> must not be null");
            }
            if (y == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/collections/maps/EnumTupleMap$EnumTuple.<init> must not be null");
            }
            super(x, y);
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public static <T extends Enum<T>, U extends Enum<U>> EnumTuple<T, U> create(@NotNull T first, @NotNull U second) {
            if (first == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/maps/EnumTupleMap$EnumTuple.create must not be null");
            }
            if (second == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/collections/maps/EnumTupleMap$EnumTuple.create must not be null");
            }
            EnumTuple<T, U> enumTuple = new EnumTuple<T, U>(first, second);
            if (enumTuple == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/maps/EnumTupleMap$EnumTuple.create must not return null");
            }
            return enumTuple;
        }

        @Override
        public boolean equals(Object obj) {
            boolean result;
            boolean bl = result = this == obj;
            if (!result && obj != null && this.getClass() == obj.getClass()) {
                EnumTuple other = (EnumTuple)obj;
                result = other.x() == this.x() && other.y() == this.y();
            }
            return result;
        }

        protected int x() {
            return ((Enum)this.getFirst()).ordinal();
        }

        protected int y() {
            return ((Enum)this.getSecond()).ordinal();
        }
    }
}

