/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.collections.maps;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.bpm.collections.maps.BiMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBiMap<K, V>
extends AbstractMap<K, V>
implements BiMap<K, V> {
    @NotNull
    Map<K, V> map;
    @Nullable
    private Set<Map.Entry<K, V>> entrySet;
    @NotNull
    AbstractBiMap<V, K> inverseMap;

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        return this.inverse().containsKey(value);
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public void clear() {
        this.map.clear();
        this.inverseMap.map.clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Set<V> values() {
        Set set = this.inverse().keySet();
        if (set == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/maps/AbstractBiMap.values must not return null");
        }
        return set;
    }

    @Override
    @Nullable
    public V remove(@Nullable Object key) {
        V value = this.get(key);
        if (value != null || this.containsKey(key)) {
            this.inverseMap.map.remove(value);
        }
        return this.map.remove(key);
    }

    @Override
    @Nullable
    public V get(@Nullable Object key) {
        return this.map.get(key);
    }

    @Override
    @Nullable
    public V forcePut(@Nullable K key, @Nullable V value) {
        return this.put(key, value, true);
    }

    @Override
    @Nullable
    public V put(@Nullable K key, @Nullable V value) throws IllegalArgumentException {
        return this.put(key, value, false);
    }

    @Nullable
    private V put(@Nullable K key, @Nullable V value, boolean force) throws IllegalArgumentException {
        Object oldKey = this.inverse().get(value);
        boolean containsValue = oldKey != null || this.containsValue(value);
        boolean putInverse = true;
        boolean hasSameKey = false;
        if (containsValue) {
            if (oldKey == key) {
                hasSameKey = true;
                putInverse = false;
            } else if (oldKey != null && oldKey.equals(key)) {
                hasSameKey = true;
            } else if (force) {
                this.map.remove(oldKey);
            } else {
                throw new IllegalArgumentException("value is already bound to a different key");
            }
        }
        if (putInverse) {
            this.inverseMap.map.put(value, key);
        }
        boolean removeOldValue = !hasSameKey && this.map.containsKey(key);
        V oldValue = this.map.put(key, value);
        if (removeOldValue) {
            this.inverseMap.map.remove(oldValue);
        }
        return oldValue;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> result = this.entrySet;
        if (result == null) {
            this.entrySet = result = this.createEntrySet();
        }
        Set<Map.Entry<K, V>> set = result;
        if (set == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/maps/AbstractBiMap.entrySet must not return null");
        }
        return set;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public BiMap<V, K> inverse() {
        AbstractBiMap<V, K> abstractBiMap = this.inverseMap;
        if (abstractBiMap == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/maps/AbstractBiMap.inverse must not return null");
        }
        return abstractBiMap;
    }

    private Set<Map.Entry<K, V>> createEntrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                Object okey = entry.getKey();
                Object ovalue = entry.getValue();
                Object value = AbstractBiMap.this.get(okey);
                return value == null ? ovalue == null && AbstractBiMap.this.containsKey(okey) : value.equals(ovalue);
            }

            @Override
            public boolean remove(Object o) {
                if (!this.contains(o)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                AbstractBiMap.this.remove(entry.getKey());
                return true;
            }

            @Override
            public void clear() {
                AbstractBiMap.this.clear();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private final Iterator<Map.Entry<K, V>> it;
                    private Map.Entry<K, V> current;
                    {
                        this.it = AbstractBiMap.this.map.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        final Map.Entry entry = this.it.next();
                        this.current = entry;
                        return new Map.Entry<K, V>(){

                            @Override
                            public K getKey() {
                                return entry.getKey();
                            }

                            @Override
                            public V getValue() {
                                return entry.getValue();
                            }

                            @Override
                            public V setValue(V value) {
                                return AbstractBiMap.this.put(this.getKey(), value);
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                        AbstractBiMap.this.inverseMap.map.remove(this.current.getValue());
                    }
                };
            }

            @Override
            public boolean add(Map.Entry<K, V> e) {
                boolean result = !this.contains(e);
                AbstractBiMap.this.put(e.getKey(), e.getValue());
                return result;
            }

            @Override
            public int size() {
                return AbstractBiMap.this.size();
            }
        };
    }
}

