/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.collections.lists;

import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import oracle.bpm.lang.Cast;

public class WeakList<T>
extends AbstractSequentialList<T>
implements Cloneable {
    protected transient int modificationFlag = 0;
    private transient Entry<T> header = new Entry<Object>(null, null, null);
    private transient int size = 0;

    private WeakList() {
        this.header.previous = this.header;
        this.header.next = this.header.previous;
    }

    public static <T> WeakList<T> create() {
        return new WeakList<T>();
    }

    @Override
    public T getFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.header.next.get();
    }

    @Override
    public T getLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.header.previous.get();
    }

    @Override
    public boolean add(T o) {
        this.addBefore(o, this.header);
        return true;
    }

    @Override
    public void add(int index, T element) {
        this.addBefore(element, index == this.size ? this.header : this.entry(index));
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.addAll(this.size, c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        boolean result;
        boolean bl = result = !c.isEmpty();
        if (result) {
            ++this.modificationFlag;
            Entry<T> successor = index == this.size ? this.header : this.entry(index);
            Entry predecessor = successor.previous;
            for (T element : c) {
                predecessor.next = new Entry<T>(element, successor, predecessor);
                predecessor = predecessor.next;
                ++this.size;
            }
            successor.previous = predecessor;
        }
        return true;
    }

    @Override
    public void addFirst(T o) {
        this.addBefore(o, this.header.next);
    }

    @Override
    public void addLast(T o) {
        this.addBefore(o, this.header);
    }

    @Override
    public void clear() {
        ++this.modificationFlag;
        this.header.previous = this.header;
        this.header.next = this.header.previous;
        this.size = 0;
    }

    public WeakList<T> clone() {
        WeakList<T> result = WeakList.create();
        this.addAll((Collection<? extends T>)result);
        return result;
    }

    @Override
    public boolean contains(Object key) {
        return this.indexOf(key) != -1;
    }

    @Override
    public T get(int index) {
        return this.entry(index).get();
    }

    @Override
    public int indexOf(Object key) {
        int index = 0;
        Entry e = this.header.next;
        while (e != this.header) {
            Object element = e.get();
            if (element == key || element != null && element.equals(key)) {
                return index;
            }
            ++index;
            e = e.next;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object key) {
        int index = this.size - 1;
        Entry e = this.header.previous;
        while (e != this.header) {
            Object element = e.get();
            if (element == key || element != null && element.equals(key)) {
                return index;
            }
            --index;
            e = e.previous;
        }
        return -1;
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new MyIterator(index);
    }

    public void pack() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != null) continue;
            iterator.remove();
        }
    }

    @Override
    public boolean remove(Object key) {
        Entry e = this.header.next;
        while (e != this.header) {
            Object element = e.get();
            if (key == element || key != null && key.equals(element)) {
                this.remove(e);
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public T remove(int index) {
        Entry<T> e = this.entry(index);
        this.remove(e);
        return e.get();
    }

    @Override
    public T removeFirst() {
        Object first = this.header.next.get();
        this.remove(this.header.next);
        return first;
    }

    @Override
    public T removeLast() {
        Object last = this.header.previous.get();
        this.remove(this.header.previous);
        return last;
    }

    @Override
    public T set(int index, T element) {
        Entry<T> e = this.entry(index);
        T old = e.get();
        e.set(element);
        return old;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size];
        int i = 0;
        Entry e = this.header.next;
        while (e != this.header) {
            result[i++] = e.get();
            e = e.next;
        }
        return result;
    }

    @Override
    public <U> U[] toArray(U[] result) {
        if (result.length < this.size) {
            Class<?> componentType = result.getClass().getComponentType();
            result = (Object[])Cast.force(Array.newInstance(componentType, this.size));
        }
        int i = 0;
        U[] a = result;
        Entry e = this.header.next;
        while (e != this.header) {
            a[i++] = e.get();
            e = e.next;
        }
        if (result.length > this.size) {
            result[this.size] = null;
        }
        return result;
    }

    private Entry<T> addBefore(T o, Entry<T> e) {
        Entry<T> newEntry = new Entry<T>(o, e, e.previous);
        newEntry.previous.next = newEntry;
        newEntry.next.previous = newEntry;
        ++this.size;
        ++this.modificationFlag;
        return newEntry;
    }

    private Entry<T> entry(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        Entry<T> e = this.header;
        if (index < this.size / 2) {
            for (int i = 0; i <= index; ++i) {
                e = e.next;
            }
        } else {
            for (int i = this.size; i > index; --i) {
                e = e.previous;
            }
        }
        return e;
    }

    private void remove(Entry<T> e) {
        if (e == this.header) {
            throw new NoSuchElementException();
        }
        e.previous.next = e.next;
        e.next.previous = e.previous;
        --this.size;
        ++this.modificationFlag;
    }

    private class MyIterator
    implements ListIterator<T> {
        private int expectedModCount;
        private Entry<T> lastReturned;
        private Entry<T> next;
        private int nextIndex;

        MyIterator(int index) {
            this.expectedModCount = WeakList.this.modificationFlag;
            this.lastReturned = WeakList.this.header;
            if (index < 0 || index > WeakList.this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + WeakList.this.size);
            }
            if (index < WeakList.this.size / 2) {
                this.next = ((WeakList)WeakList.this).header.next;
                this.nextIndex = 0;
                while (this.nextIndex < index) {
                    this.next = this.next.next;
                    ++this.nextIndex;
                }
            } else {
                this.next = WeakList.this.header;
                this.nextIndex = WeakList.this.size;
                while (this.nextIndex > index) {
                    this.next = this.next.previous;
                    --this.nextIndex;
                }
            }
        }

        @Override
        public void add(T o) {
            this.checkForComodification();
            this.lastReturned = WeakList.this.header;
            WeakList.this.addBefore(o, this.next);
            ++this.nextIndex;
            ++this.expectedModCount;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex != WeakList.this.size;
        }

        @Override
        public boolean hasPrevious() {
            return this.nextIndex != 0;
        }

        @Override
        public T next() {
            this.checkForComodification();
            if (this.nextIndex == WeakList.this.size) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            this.next = this.next.next;
            ++this.nextIndex;
            return this.lastReturned.get();
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public T previous() {
            if (this.nextIndex == 0) {
                throw new NoSuchElementException();
            }
            this.next = this.next.previous;
            this.lastReturned = this.next;
            --this.nextIndex;
            this.checkForComodification();
            return this.lastReturned.get();
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            WeakList.this.remove(this.lastReturned);
            if (this.next == this.lastReturned) {
                this.next = this.lastReturned.next;
            } else {
                --this.nextIndex;
            }
            this.lastReturned = WeakList.this.header;
            ++this.expectedModCount;
        }

        @Override
        public void set(T o) {
            if (this.lastReturned == WeakList.this.header) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            this.lastReturned.set(o);
        }

        final void checkForComodification() {
            if (WeakList.this.modificationFlag != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private static class Entry<T> {
        Entry<T> next;
        Entry<T> previous;
        WeakReference<T> ref;

        Entry(T element, Entry<T> next, Entry<T> previous) {
            this.ref = new WeakReference<T>(element);
            this.next = next;
            this.previous = previous;
        }

        T get() {
            return this.ref.get();
        }

        void set(T element) {
            this.ref = new WeakReference<T>(element);
        }
    }
}

