/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.collections.lists;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import oracle.bpm.collections.lists.ComparableList;
import oracle.bpm.collections.lists.StringList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntList
extends ComparableList<Integer>
implements RandomAccess,
Serializable {
    private static final int DEFAULT_CAPACITY = 10;
    public static IntList EMPTY = new IntList(Collections.EMPTY_LIST);
    static final long serialCheck = 2138106921392093884L;
    static final long serialVersionUID = 5892493345869406942L;

    private IntList(List<Integer> delegated) {
        super(delegated);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static IntList create() {
        IntList intList = IntList.create(10);
        if (intList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/IntList.create must not return null");
        }
        return intList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static IntList create(int initialCapacity) {
        IntList intList = new IntList((List<Integer>)new ArrayList<Integer>(initialCapacity));
        if (intList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/IntList.create must not return null");
        }
        return intList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static IntList create(Integer ... values) {
        IntList result;
        if (values == null) {
            result = IntList.create();
        } else {
            result = IntList.create(values.length);
            result.addAll(values);
        }
        IntList intList = result;
        if (intList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/IntList.create must not return null");
        }
        return intList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static IntList create(int ... values) {
        IntList result;
        if (values == null) {
            result = IntList.create();
        } else {
            result = IntList.create(values.length);
            for (int value : values) {
                result.add(value);
            }
        }
        IntList intList = result;
        if (intList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/IntList.create must not return null");
        }
        return intList;
    }

    public static IntList createPrimitive() {
        return new IntList(new PrimitiveIntList(10));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static IntList createFromString(@Nullable String str) {
        IntList result;
        if (str == null || str.length() == 0) {
            result = IntList.create();
        } else {
            char firstChr = str.charAt(0);
            if (firstChr == '[' || firstChr == '(') {
                str = str.substring(1, str.length() - 1);
            }
            StringList strlist = StringList.createTokenizing(str, ",;:");
            result = IntList.create(strlist.size());
            for (String s : strlist) {
                result.add(Integer.parseInt(s.trim()));
            }
        }
        IntList intList = result;
        if (intList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/IntList.createFromString must not return null");
        }
        return intList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static IntList create(@Nullable Collection<Integer> values) {
        IntList result;
        if (values == null) {
            result = IntList.create();
        } else {
            result = IntList.create(values.size());
            result.addAll(values);
        }
        IntList intList = result;
        if (intList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/IntList.create must not return null");
        }
        return intList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static IntList singleton(@NotNull Integer element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/lists/IntList.singleton must not be null");
        }
        IntList intList = new IntList(Collections.singletonList(element));
        if (intList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/IntList.singleton must not return null");
        }
        return intList;
    }

    @Override
    public boolean add(int value) {
        return this.list instanceof PrimitiveIntList ? ((PrimitiveIntList)this.list).addInt(value) : this.list.add(value);
    }

    @Override
    public int set(int index, int element) {
        Integer integer;
        int result = this.list instanceof PrimitiveIntList ? ((PrimitiveIntList)this.list).setInt(index, element) : ((integer = this.list.set(index, element)) == null ? 0 : integer);
        return result;
    }

    public int getInt(int index) {
        Integer integer;
        int result = this.list instanceof PrimitiveIntList ? ((PrimitiveIntList)this.list).getInt(index) : ((integer = (Integer)this.list.get(index)) == null ? 0 : integer);
        return result;
    }

    public int removeInt(int index) {
        Integer integer;
        int result = this.list instanceof PrimitiveIntList ? ((PrimitiveIntList)this.list).removeInt(index) : ((integer = (Integer)this.list.remove(index)) == null ? 0 : integer);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Integer[] toArray() {
        Integer[] integerArray = this.toArray(new Integer[this.size()]);
        if (integerArray == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/IntList.toArray must not return null");
        }
        return integerArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public int[] toIntArray() {
        int[] result = new int[this.size()];
        if (this.list instanceof PrimitiveIntList) {
            PrimitiveIntList plist = (PrimitiveIntList)this.list;
            for (int i = 0; i < plist.size(); ++i) {
                result[i] = plist.getInt(i);
            }
        } else {
            for (int i = 0; i < this.list.size(); ++i) {
                Integer in = (Integer)this.list.get(i);
                result[i] = in == null ? 0 : in;
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/IntList.toIntArray must not return null");
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public IntList subList(int fromIndex, int toIndex) {
        IntList intList = new IntList(this.list.subList(fromIndex, toIndex));
        if (intList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/IntList.subList must not return null");
        }
        return intList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public IntList clone() {
        IntList intList = IntList.create(this);
        if (intList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/IntList.clone must not return null");
        }
        return intList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public IntList add(Integer ... values) {
        super.addAll(values);
        IntList intList = this;
        if (intList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/IntList.add must not return null");
        }
        return intList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public IntList add(int ... values) {
        for (int value : values) {
            this.add(value);
        }
        IntList intList = this;
        if (intList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/IntList.add must not return null");
        }
        return intList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public IntList sort() {
        super.sort();
        IntList intList = this;
        if (intList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/IntList.sort must not return null");
        }
        return intList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public IntList asUnmodifiable() {
        IntList intList = new IntList(Collections.unmodifiableList(this.list));
        if (intList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/IntList.asUnmodifiable must not return null");
        }
        return intList;
    }

    private static class PrimitiveIntList
    extends AbstractList<Integer>
    implements RandomAccess {
        protected transient int[] intValues;
        protected transient int size;

        public PrimitiveIntList(int capacity) {
            this.intValues = new int[capacity];
            this.size = 0;
        }

        @Override
        public Integer get(int index) {
            return this.getInt(index);
        }

        @Override
        public boolean add(Integer value) {
            if (value == null) {
                throw new IllegalArgumentException("Do not accept null values");
            }
            return this.addInt(value);
        }

        @Override
        public Integer remove(int index) {
            return this.removeInt(index);
        }

        public int getInt(int index) {
            this.checkRange(index);
            return this.intValues[index];
        }

        public boolean addInt(int value) {
            this.ensureCapacity(this.size + 1);
            this.intValues[this.size++] = value;
            return true;
        }

        public int removeInt(int index) {
            this.checkRange(index);
            ++this.modCount;
            int oldValue = this.intValues[index];
            int numMoved = this.size - index - 1;
            if (numMoved > 0) {
                System.arraycopy(this.intValues, index + 1, this.intValues, index, numMoved);
            }
            return oldValue;
        }

        public int setInt(int index, int element) {
            this.checkRange(index);
            int oldValue = this.intValues[index];
            this.intValues[index] = element;
            return oldValue;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public Integer set(int index, Integer element) {
            return this.setInt(index, element);
        }

        private void checkRange(int index) {
            if (index < 0 || index >= this.size) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
        }

        private void ensureCapacity(int capacity) {
            ++this.modCount;
            if (capacity > this.intValues.length) {
                int newCap = Math.max(this.intValues.length << 1, capacity);
                this.intValues = Arrays.copyOf(this.intValues, newCap);
            }
        }
    }
}

