/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.collections.iterator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;

public class ReverseIterable<E>
implements Iterable<E>,
Iterator<E> {
    private ListIterator<E> listIterator;

    public ReverseIterable(List<E> list) {
        this.listIterator = list.listIterator(list.size());
    }

    public ReverseIterable(Iterable<E> iterable) {
        this(ReverseIterable.createListFromIterable(iterable));
    }

    @Override
    public Iterator<E> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.listIterator.hasPrevious();
    }

    @Override
    public E next() {
        return this.listIterator.previous();
    }

    @Override
    public void remove() {
        this.listIterator.remove();
    }

    private static <T> List<T> createListFromIterable(@NotNull Iterable<T> iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/iterator/ReverseIterable.createListFromIterable must not be null");
        }
        ArrayList<T> copy = new ArrayList<T>();
        for (T t : iterable) {
            copy.add(t);
        }
        return copy;
    }
}

