/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.collections;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import oracle.bpm.collections.PriorityQueue;
import oracle.bpm.collections.iterator.NoRemoveIterator;
import oracle.bpm.lang.Cast;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Heap<T>
implements PriorityQueue<T> {
    @NotNull
    private final Comparator<? super T> comparator;
    private transient int concurrencyCount = 0;
    @NotNull
    private transient T[] heap;
    private int size;
    private static final int NOT_FOUND = -1;
    protected static final int DEFAULT_INITIAL_CAPACITY = 10;

    private Heap(Comparator<? super T> comparator, int initialCapacity) {
        this.comparator = comparator;
        this.heap = this.createArray(initialCapacity + 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Heap<T> create() {
        Heap heap = new Heap(new NaturalComparator(), 10);
        if (heap == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/Heap.create must not return null");
        }
        return heap;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Heap<T> create(int initialCapacity) {
        Heap heap = new Heap(new NaturalComparator(), initialCapacity);
        if (heap == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/Heap.create must not return null");
        }
        return heap;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Heap<T> create(Comparator<? super T> c) {
        Heap<? super T> heap = new Heap<T>(c, 10);
        if (heap == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/Heap.create must not return null");
        }
        return heap;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Heap<T> create(@NotNull Comparator<? super T> c, int initialCapacity) {
        if (c == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/Heap.create must not be null");
        }
        Heap<? super T> heap = new Heap<T>(c, initialCapacity);
        if (heap == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/Heap.create must not return null");
        }
        return heap;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Comparator<? super T> getComparator() {
        Comparator<? super T> comparator = this.comparator;
        if (comparator == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/Heap.getComparator must not return null");
        }
        return comparator;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public T element() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.heap[1];
    }

    @Override
    @Nullable
    public T peek() {
        return this.isEmpty() ? null : (T)this.heap[1];
    }

    @Override
    public boolean add(T obj) {
        this.ensureCapacity(this.size + 1);
        this.heap[++this.size] = obj;
        Heap.bottomUp(this.size, this.heap, this.comparator);
        return true;
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.getCapacity();
        if (minCapacity > oldCapacity) {
            T[] oldHeap = this.heap;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.heap = this.createArray(newCapacity);
            System.arraycopy(oldHeap, 1, this.heap, 1, this.size);
        }
        ++this.concurrencyCount;
    }

    @Override
    public void clear() {
        ++this.concurrencyCount;
        for (int i = 1; i <= this.size; ++i) {
            this.heap[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean contains(Object obj) {
        return this.indexOf(obj) != -1;
    }

    @Override
    public Iterator<T> iterator() {
        return new HeapIterator();
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size];
        this.copyElements(result);
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.size) {
            a = (Object[])Cast.force(Array.newInstance(a.getClass().getComponentType(), this.size));
        }
        this.copyElements(a);
        return a;
    }

    @Override
    public boolean remove(Object obj) throws NoSuchElementException {
        boolean found;
        int index = this.indexOf(obj);
        boolean bl = found = index != -1;
        if (found) {
            this.extract(index);
        }
        return found;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object element : collection) {
            if (this.contains(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        boolean modified = false;
        for (T element : collection) {
            modified |= this.add(element);
        }
        return modified;
    }

    public int indexOf(Object obj) {
        Object element = obj;
        return this.find(1, element);
    }

    @Override
    public int size() {
        return this.size;
    }

    public T extract(int i) throws NoSuchElementException {
        if (i <= 0 || i > this.size) {
            throw new NoSuchElementException();
        }
        T result = this.heap[i];
        this.heap[i] = null;
        Heap.topDown(i, this.heap, this.size, this.comparator);
        --this.size;
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object o : c) {
            result |= this.remove(o);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        ArrayList<T> toBeRemoved = new ArrayList<T>();
        for (T e : this.heap) {
            if (c.contains(e)) continue;
            toBeRemoved.add(e);
        }
        return this.removeAll(toBeRemoved);
    }

    @Override
    @Nullable
    public T poll() {
        return this.isEmpty() ? null : (T)this.extract(1);
    }

    @Override
    public T remove() throws NoSuchElementException {
        return this.extract(1);
    }

    @Override
    public boolean offer(T obj) {
        return this.add(obj);
    }

    private static int parent(int i) {
        return i >> 1;
    }

    private static boolean hasParent(int i) {
        return i > 1;
    }

    private static int leftChild(int i) {
        return i << 1;
    }

    private static int rightChild(int i) {
        return (i << 1) + 1;
    }

    private static boolean isLeaf(int i, int size) {
        return i > size >> 1;
    }

    private static <T> void bottomUp(int index, T[] heap, Comparator<? super T> comparator) {
        int v;
        while (Heap.hasParent(index) && comparator.compare(heap[index], heap[v = Heap.parent(index)]) > 0) {
            T obj = heap[index];
            heap[index] = heap[v];
            heap[v] = obj;
            index = v;
        }
    }

    private static boolean hasRightChild(int i, int size) {
        return Heap.rightChild(i) <= size;
    }

    private static <T> void topDown(int index, T[] heap, int size, Comparator<? super T> comparator) {
        while (!Heap.isLeaf(index, size)) {
            int next;
            if (!Heap.hasRightChild(index, size)) {
                next = Heap.leftChild(index);
            } else {
                int left = Heap.leftChild(index);
                int right = Heap.rightChild(index);
                next = comparator.compare(heap[right], heap[left]) > 0 ? right : left;
            }
            heap[index] = heap[next];
            index = next;
        }
        heap[index] = heap[size];
        Heap.bottomUp(index, heap, comparator);
    }

    private void copyElements(Object[] result) {
        int sz = this.size();
        T[] elements = this.createArray(sz + 1);
        System.arraycopy(this.heap, 1, elements, 1, sz);
        int i = 0;
        while (sz > 0) {
            result[i] = this.heap[1];
            Heap.topDown(1, this.heap, sz, this.comparator);
            --sz;
            --sz;
            ++i;
        }
    }

    private int find(int from, T obj) {
        int result = -1;
        int cmp = this.comparator.compare(this.heap[from], obj);
        if (cmp == 0) {
            result = from;
        } else if (cmp > 0 && !Heap.isLeaf(from, this.size) && (result = this.find(Heap.leftChild(from), obj)) == -1 && Heap.hasRightChild(from, this.size)) {
            result = this.find(Heap.rightChild(from), obj);
        }
        return result;
    }

    private int getCapacity() {
        return this.heap.length - 1;
    }

    private T[] createArray(int sz) {
        return new Object[sz];
    }

    private class HeapIterator
    extends NoRemoveIterator<T> {
        int expectedCount;
        int index;

        private HeapIterator() {
            this.expectedCount = Heap.this.concurrencyCount;
        }

        @Override
        public boolean hasNext() {
            return this.index < Heap.this.size();
        }

        @Override
        public T next() {
            this.concurrencyCheck();
            try {
                return Heap.this.heap[++this.index];
            }
            catch (IndexOutOfBoundsException e) {
                this.concurrencyCheck();
                throw new NoSuchElementException();
            }
        }

        private void concurrencyCheck() {
            if (Heap.this.concurrencyCount != this.expectedCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private static class NaturalComparator<T>
    implements Comparator<T> {
        private NaturalComparator() {
        }

        @Override
        public int compare(T k1, T k2) {
            return k1 == k2 ? 0 : (k1 == null ? -1 : (k2 == null ? 1 : ((Comparable)k1).compareTo(k2)));
        }
    }
}

