/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.collections;

import java.util.AbstractList;
import java.util.List;

public final class Combination {
    private final int[] data;
    private final int k;
    private final int n;

    private Combination(int n, int k, int[] data) {
        this.n = n;
        this.k = k;
        this.data = data;
    }

    public static <T> List<List<T>> listAll(final List<T> elements, final int k) {
        return new AbstractList<List<T>>(){
            int size;
            {
                this.size = Combination.choose(elements.size(), k);
            }

            @Override
            public List<T> get(int index) {
                return Combination.createCombination(elements.size(), k, index).applyTo(elements);
            }

            @Override
            public int size() {
                return this.size;
            }
        };
    }

    public static int choose(int n, int k) {
        int iMax;
        int delta;
        if (n < 0 || k < 0) {
            throw new IllegalArgumentException("n,k must be  greater than 0");
        }
        if (n < k) {
            return 0;
        }
        if (n == k) {
            return 1;
        }
        if (k < n - k) {
            delta = n - k;
            iMax = k;
        } else {
            delta = k;
            iMax = n - k;
        }
        int result = delta + 1;
        for (int i = 2; i <= iMax; ++i) {
            result = result * (delta + i) / i;
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        for (int i = 0; i < this.k; ++i) {
            sb.append(this.data[i]);
            sb.append(' ');
        }
        sb.append('}');
        return sb.toString();
    }

    private static Combination createCombination(int n, int k, int index) {
        int i;
        int size = Combination.choose(n, k);
        if (index >= size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        int[] data = new int[k];
        int a = n;
        int b = k;
        int x = size - 1 - index;
        for (i = 0; i < k; ++i) {
            data[i] = Combination.largestV(a, b, x);
            x -= Combination.choose(data[i], b);
            a = data[i];
            --b;
        }
        for (i = 0; i < k; ++i) {
            data[i] = n - 1 - data[i];
        }
        return new Combination(n, k, data);
    }

    private static int largestV(int a, int b, int x) {
        int v = a - 1;
        while (Combination.choose(v, b) > x) {
            --v;
        }
        return v;
    }

    private <T> List<T> applyTo(final List<T> elements) {
        if (elements.size() != this.n) {
            throw new IllegalArgumentException("expecting " + this.n + " elements");
        }
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return elements.get(Combination.this.data[index]);
            }

            @Override
            public int size() {
                return Combination.this.k;
            }
        };
    }
}

