/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.capability;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.capability.Capability;
import oracle.bpm.capability.CapabilityListener;
import oracle.bpm.capability.CapabilityService;
import oracle.bpm.lang.Platform;

public class DefaultCapabilityService
implements CapabilityService {
    protected List<Capability> capabilities = new ArrayList<Capability>();
    private static final Capability DUMMY = new Capability(){

        @Override
        public void addListener(CapabilityListener listener) {
        }

        @Override
        public boolean dependsOn(Capability capability) {
            return false;
        }

        @Override
        public void disable() {
        }

        @Override
        public void enable() {
        }

        @Override
        public String getId() {
            return null;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public List<Capability> getSubCapabilities() {
            return new ArrayList<Capability>(0);
        }

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public void removeListener(CapabilityListener listener) {
        }
    };

    @Override
    public List<Capability> getAllCapabilities() {
        return this.capabilities;
    }

    @Override
    public Capability findCapability(String id) {
        return this.findCapability(id, this.getAllCapabilities());
    }

    public void addCapability(Capability capability) {
        this.capabilities.add(capability);
    }

    @Override
    public List<Capability> getEnabledCapabilities() {
        ArrayList<Capability> enabledCapabilities = new ArrayList<Capability>();
        for (Capability capability : this.getAllCapabilities()) {
            if (!capability.isEnabled()) continue;
            enabledCapabilities.add(capability);
        }
        return enabledCapabilities;
    }

    @Override
    public List<Capability> getDisabledCapabilities() {
        ArrayList<Capability> disabledCapabilities = new ArrayList<Capability>();
        for (Capability capability : this.getAllCapabilities()) {
            if (capability.isEnabled()) continue;
            disabledCapabilities.add(capability);
        }
        return disabledCapabilities;
    }

    @Override
    public void disableCapability(Capability capability) {
        this.disableDependants(capability);
        capability.disable();
    }

    @Override
    public void enableCapability(Capability capability) {
        this.enableDependants(capability);
        capability.enable();
    }

    protected Capability findCapability(String id, List<Capability> capabilities) {
        Capability result = null;
        for (Capability capability : capabilities) {
            if (capability.getId().equals(id)) {
                result = capability;
                break;
            }
            this.findCapability(id, capability.getSubCapabilities());
        }
        return result != null ? result : DUMMY;
    }

    private void disableDependants(Capability capability) {
        List<Capability> enabledCapabilities = Platform.getCapabilityService().getEnabledCapabilities();
        for (Capability enabledCapability : enabledCapabilities) {
            if (!enabledCapability.dependsOn(capability)) continue;
            this.disableCapability(enabledCapability);
        }
    }

    private void enableDependants(Capability capability) {
        List<Capability> disabledCapabilities = Platform.getCapabilityService().getDisabledCapabilities();
        for (Capability disabledCapability : disabledCapabilities) {
            if (!disabledCapability.dependsOn(capability)) continue;
            this.enableCapability(disabledCapability);
        }
    }
}

