/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmobject.runtime;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import oracle.bpm.bpmobject.runtime.XMLObject;
import oracle.bpm.bpmobject.runtime.XMLText;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.Time;
import oracle.bpm.util.Base64;
import oracle.bpm.util.Conversion;
import oracle.bpm.util.HexBinary;
import org.jetbrains.annotations.Nullable;

public class XMLValue {
    private static final String ARRAY_TYPE = "arrayType";
    private static final String ARRAY_ELEMENT_NAME = "element";
    private static final String ANY_TYPE = "anyType";
    private static final String BASE64_BINARY = "base64Binary";
    private static final String BOOLEAN = "boolean";
    private static final String DATE_TIME = "dateTime";
    private static final String DECIMAL = "decimal";
    private static final String GDAY = "gDay";
    private static final String GMONTH = "gMonth";
    private static final String GMONTHDAY = "gMonthDay";
    private static final String GYEARMONTH = "gYearMonth";
    private static final String HEX_BINARY = "hexBinary";
    private static final String INTEGER = "integer";
    private static final String DURATION = "duration";
    private static final String DOUBLE = "double";
    private static final String STRING = "string";
    private static final String DATE = "date";
    private static final String TIME = "time";
    private static final Integer ZERO = 0;

    public static Object convertFrom(Object value, String typeSignature) {
        char type = typeSignature.charAt(0);
        if (value instanceof XMLObject && type != 'X' && type != 'A') {
            if (value instanceof XMLText) {
                value = value.toString();
            } else {
                XMLObject xmlResponse = (XMLObject)value;
                Map<QName, String> xmlResponseAttr = xmlResponse.getAttributes();
                if ((type == '[' || type == '{') && xmlResponseAttr.containsKey(new QName("http://schemas.xmlsoap.org/soap/encoding/", ARRAY_TYPE))) {
                    value = ((XMLObject)value).getContent();
                } else {
                    Object newValue = ((XMLObject)value).getContent();
                    Object object = value = newValue instanceof XMLText ? newValue.toString() : value;
                }
            }
            if (value instanceof String) {
                value = ((String)value).trim();
            }
        }
        Serializable result = null;
        block0 : switch (type) {
            case '[': 
            case '{': {
                ArrayList<Object> list;
                String elementType = typeSignature.substring(1);
                if (value instanceof String) {
                    String str = (String)value;
                    int length = str.length();
                    char[] chars = new char[length];
                    str.getChars(0, length, chars, 0);
                    ArrayList<Object> elements = new ArrayList<Object>(length / 10);
                    for (int i = 0; i < length; ++i) {
                        int start = i;
                        while (i < length && !Character.isWhitespace(chars[i])) {
                            ++i;
                        }
                        if (start == i) continue;
                        elements.add(XMLValue.convertFrom(new String(chars, start, i - start), elementType));
                    }
                    result = elements;
                    break;
                }
                if (value instanceof List) {
                    list = (ArrayList<Object>)Cast.force(value);
                    int length = list.size();
                    for (int i = 0; i < length; ++i) {
                        Object elem = list.get(i);
                        list.set(i, XMLValue.convertFrom(elem, elementType));
                    }
                    result = list;
                    break;
                }
                if (value != null && value.getClass().isArray()) {
                    list = new ArrayList();
                    int length = Array.getLength(value);
                    for (int i = 0; i < length; ++i) {
                        Object elem = Array.get(value, i);
                        list.add(XMLValue.convertFrom(elem, elementType));
                    }
                    result = list;
                    break;
                }
                if (!(value instanceof XMLObject)) break;
                list = new ArrayList<Object>();
                list.add(XMLValue.convertFrom(value, elementType));
                result = list;
                break;
            }
            case 'B': {
                result = Conversion.tojava_lang_Boolean(value);
                break;
            }
            case 'D': {
                result = Conversion.tojava_math_BigDecimal(value);
                break;
            }
            case '5': {
                result = Conversion.tojava_lang_Integer(Str.replace((String)value, "-", ""));
                break;
            }
            case '6': {
                result = Conversion.tojava_lang_Integer(Str.replace((String)value, "-", ""));
                break;
            }
            case 'I': {
                switch (typeSignature.length() > 1 ? (int)typeSignature.charAt(1) : 56) {
                    case 49: {
                        result = Conversion.tojava_lang_Byte(value);
                        break block0;
                    }
                    case 50: {
                        result = Conversion.tojava_lang_Short(value);
                        break block0;
                    }
                    case 52: {
                        result = Conversion.tojava_lang_Integer(value);
                        break block0;
                    }
                    case 56: {
                        result = Conversion.tojava_lang_Long(value);
                        break block0;
                    }
                }
                assert (false) : "Invalid length for integer type";
                break;
            }
            case 'V': {
                result = Conversion.tooracle_bpm_lang_Interval(value);
                break;
            }
            case 'R': {
                switch (typeSignature.length() > 1 ? (int)typeSignature.charAt(1) : 56) {
                    case 52: {
                        result = Conversion.tojava_lang_Float(value);
                        break block0;
                    }
                    case 56: {
                        result = Conversion.tojava_lang_Double(value);
                        break block0;
                    }
                }
                assert (false) : "Invalid length for real type";
                break;
            }
            case 'S': {
                result = value;
                break;
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '7': 
            case 'T': {
                result = Conversion.tooracle_bpm_lang_Time(value);
                break;
            }
            case 'E': {
                typeSignature = typeSignature.substring(1);
                StringTokenizer items = new StringTokenizer(typeSignature, ",");
                result = ZERO;
                int i = 0;
                while (items.hasMoreTokens()) {
                    if (items.nextToken().equals(value)) {
                        result = i;
                    }
                    ++i;
                }
                break;
            }
            case 'X': {
                result = value;
                break;
            }
            case 'Y': {
                if (value == null) break;
                result = (Serializable)(value instanceof byte[] ? (byte[])value : Base64.decode(value.toString()));
                break;
            }
            case 'H': {
                result = (Serializable)HexBinary.decode(value.toString());
                break;
            }
            case 'A': {
                result = value;
                break;
            }
            default: {
                throw new RuntimeException("Illegal signature: (" + typeSignature + ") value: " + value.toString());
            }
        }
        return result;
    }

    public static Object convertTo(Object value, String targetSignature) {
        return XMLValue.convertTo(value, targetSignature, null, null, false);
    }

    public static Object convertTo(Object value, String targetSignature, @Nullable String elementName, @Nullable String elementNamespace, boolean elementIsQualified) {
        boolean condition;
        assert (targetSignature != null) : "Target signature is null";
        Cloneable result = null;
        char type = targetSignature.charAt(0);
        switch (type) {
            case '[': 
            case '{': {
                List list = (List)value;
                int length = list != null ? list.size() : 0;
                String elementType = targetSignature.substring(1);
                if (XMLValue.isComplexTypeArray(targetSignature) || elementName != null) {
                    ArrayList<Object> array = new ArrayList<Object>();
                    if (elementName == null) {
                        elementName = ARRAY_ELEMENT_NAME;
                    }
                    for (int i = 0; i < length; ++i) {
                        Object elem = list.get(i);
                        if (elem == null) continue;
                        Object element = XMLValue.convertTo(elem, elementType, elementName, elementNamespace, elementIsQualified);
                        array.add(element);
                    }
                    result = array;
                    break;
                }
                StringBuilder array = new StringBuilder();
                for (int i = 0; i < length; ++i) {
                    Object elem = list.get(i);
                    if (elem == null) continue;
                    array.append(XMLValue.convertTo(elem, elementType, elementName, elementNamespace, elementIsQualified).toString());
                    if (i + 1 >= length) continue;
                    array.append(' ');
                }
                result = new XMLText(array.toString());
                break;
            }
            case '5': {
                if (value != null) {
                    value = String.format("%02d", value);
                    value = "---" + value;
                }
                result = new XMLText((String)value);
                break;
            }
            case '6': {
                if (value != null) {
                    value = String.format("%02d", value);
                    value = "--" + value;
                }
                result = new XMLText((String)value);
                break;
            }
            case 'V': {
                if (value instanceof Interval) {
                    value = ((Interval)value).toXMLString();
                }
                result = new XMLText((String)value);
                break;
            }
            case 'B': 
            case 'D': 
            case 'I': 
            case 'R': 
            case 'S': {
                if (value != null && !(value instanceof String)) {
                    value = value.toString();
                }
                result = new XMLText((String)value);
                break;
            }
            case '1': {
                if (value != null) {
                    value = ((Time)value).toTimeString();
                }
                result = new XMLText((String)value);
                break;
            }
            case '4': {
                if (value != null) {
                    value = ((Time)value).toGMonthDayString();
                }
                result = new XMLText((String)value);
                break;
            }
            case '3': {
                if (value != null) {
                    value = ((Time)value).toGYearMonthString();
                }
                result = new XMLText((String)value);
                break;
            }
            case '2': 
            case 'T': {
                if (value != null) {
                    value = ((Time)value).toXMLString();
                }
                result = new XMLText((String)value);
                break;
            }
            case '7': {
                if (value != null) {
                    value = ((Time)value).toDateString();
                }
                result = new XMLText((String)value);
                break;
            }
            case 'X': {
                if (value instanceof XMLObject) {
                    XMLObject xmlObject = (XMLObject)value;
                    if (elementName != null) {
                        xmlObject.setTagName(elementName);
                    }
                    if (elementNamespace != null) {
                        xmlObject.setElementNamespace(elementNamespace);
                    }
                    xmlObject.setElementIsQualified(elementIsQualified);
                    result = value;
                    break;
                }
                XMLObject xmlobj = new XMLObject();
                xmlobj.addChild(new XMLText(String.valueOf(value)));
                result = xmlobj;
                break;
            }
            case 'E': {
                targetSignature = targetSignature.substring(1);
                String text = String.valueOf(value).trim();
                long number = Long.parseLong(text);
                StringTokenizer items = new StringTokenizer(targetSignature, ",");
                int i = 0;
                while (items.hasMoreTokens()) {
                    String elem = items.nextToken();
                    if ((long)i == number) {
                        result = new XMLText(elem);
                        break;
                    }
                    ++i;
                }
                if (result != null) break;
                return new XMLText("");
            }
            case 'Y': {
                if (value != null) {
                    value = Base64.encode((byte[])value);
                }
                result = new XMLText((String)value);
                break;
            }
            case 'H': {
                if (value != null) {
                    value = HexBinary.encode((byte[])value);
                }
                result = new XMLText((String)value);
                break;
            }
            default: {
                throw new RuntimeException("Illegal signature " + targetSignature);
            }
        }
        boolean bl = condition = result instanceof XMLObject || result instanceof List;
        assert (condition);
        if (elementName != null && result instanceof XMLText) {
            XMLObject obj = new XMLObject(elementName, null, elementIsQualified);
            obj.setElementNamespace(elementNamespace);
            obj.addChild((XMLText)result);
            result = obj;
        }
        return result;
    }

    static boolean isComplexTypeArray(String typeSignature) {
        char type = typeSignature.charAt(0);
        char elementType = typeSignature.charAt(1);
        return type == '{' || type == '[' && elementType == 'X';
    }

    static String getNamespace(String typeSignature) {
        int colon = typeSignature.indexOf(58);
        String result = colon != -1 ? typeSignature.substring(colon + 1) : (typeSignature.charAt(0) != 'X' ? "http://www.w3.org/2001/XMLSchema" : null);
        return result;
    }

    static String getXsiType(String typeSignature) {
        String xsiType = null;
        char type = typeSignature.charAt(0);
        switch (type) {
            case 'X': {
                xsiType = typeSignature.substring(1);
                int colon = xsiType.indexOf(58);
                if (colon == -1) break;
                xsiType = xsiType.substring(0, colon);
                break;
            }
            case 'A': {
                xsiType = ANY_TYPE;
                break;
            }
            case 'Y': {
                xsiType = BASE64_BINARY;
                break;
            }
            case 'B': {
                xsiType = BOOLEAN;
                break;
            }
            case '2': {
                xsiType = DATE_TIME;
                break;
            }
            case 'D': {
                xsiType = DECIMAL;
                break;
            }
            case '5': {
                xsiType = GDAY;
                break;
            }
            case '6': {
                xsiType = GMONTH;
                break;
            }
            case '4': {
                xsiType = GMONTHDAY;
                break;
            }
            case '3': {
                xsiType = GYEARMONTH;
                break;
            }
            case 'H': {
                xsiType = HEX_BINARY;
                break;
            }
            case 'I': {
                xsiType = INTEGER;
                break;
            }
            case 'V': {
                xsiType = DURATION;
                break;
            }
            case 'R': {
                xsiType = DOUBLE;
                break;
            }
            case 'S': {
                xsiType = STRING;
                break;
            }
            case 'T': {
                xsiType = DATE;
                break;
            }
            case '1': {
                xsiType = TIME;
            }
        }
        return xsiType;
    }
}

