/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmobject.runtime;

import oracle.bpm.bpmobject.runtime.XMLObject;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.lang.Str;
import oracle.bpm.util.Base64;
import oracle.bpm.util.Conversion;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XMLText
extends XMLObject {
    private final StringBuilder content = new StringBuilder();
    private transient Text textNode;
    static final long serialVersionUID = 3705528411929148484L;
    static final long serialCheck = -4331426345761853558L;

    public XMLText(String text) {
        this();
        this.setText(text);
    }

    XMLText(Text textNode) {
        this(textNode.getWholeText());
        this.setTextNode(textNode);
    }

    private XMLText() {
        super((Element)null);
    }

    public void append(String newText) {
        this.content.append(newText);
    }

    @Override
    @Nullable
    public String getElementNamespace() {
        return null;
    }

    @Override
    public DynamicObject getContentToShow() {
        return DynamicObject.valueOf(this.content);
    }

    @Override
    public String getTagName() {
        return null;
    }

    public void setText(String text) {
        StringBuilder builder = this.content;
        builder.setLength(0);
        if (text != null) {
            builder.append(text);
        }
    }

    public String getText() {
        return this.content.toString();
    }

    @Override
    @Deprecated
    public void generateXML(IndentedPrintWriter out, boolean root, XMLObject.NSMap nspaces) {
        out.print(Str.toXMLString(this.content));
    }

    @Override
    public Object getValue(int kind) {
        return XMLText.fromString(this.content.toString(), kind);
    }

    @Override
    public String toString() {
        return this.content.toString();
    }

    void setTextNode(Text text) {
        Text oldText = this.textNode;
        if (oldText != text) {
            XMLText.clearUserData(oldText);
            this.textNode = text;
            this.setUserData(text);
        }
    }

    @Override
    Node getNode() {
        return this.textNode;
    }

    @Override
    void setNode(Node node) {
        this.setTextNode((Text)node);
    }

    private static Object fromString(String value, int kind) {
        if (Str.isEmpty(value)) {
            return null;
        }
        switch (kind) {
            case 1: {
                return Conversion.tojava_lang_Boolean(value);
            }
            case 2: {
                return Conversion.tojava_lang_Double(value).intValue();
            }
            case 3: {
                return Conversion.tojava_math_BigDecimal(value);
            }
            case 4: {
                return Conversion.tojava_lang_Double(value);
            }
            case 5: {
                return value;
            }
            case 6: {
                return Conversion.tooracle_bpm_lang_Time(value);
            }
            case 7: {
                return Conversion.tooracle_bpm_lang_Interval(value);
            }
            case 8: {
                return Base64.decode(value);
            }
        }
        return null;
    }
}

