/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmobject.runtime;

import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import oracle.bpm.bpmobject.runtime.XMLObject;
import oracle.bpm.bpmobject.runtime.XMLText;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SortedChildrenList
extends AbstractList<XMLObject> {
    private final XMLObject root;

    SortedChildrenList(XMLObject root) {
        this.root = root;
    }

    @Override
    public int size() {
        Element element = this.getElement();
        return element == null ? 0 : element.getChildNodes().getLength();
    }

    @Override
    public boolean isEmpty() {
        return !this.getElement().hasChildNodes();
    }

    @Override
    public XMLObject get(int index) {
        return XMLObject.valueOf(this.getNode(index));
    }

    @Override
    public XMLObject set(int index, XMLObject element) {
        this.makeLocal(element);
        Node node = element.getNode();
        Node oldNode = this.getNode(index);
        this.getElement().replaceChild(node, oldNode);
        return XMLObject.valueOf(oldNode);
    }

    public XMLObject set(int index, @NotNull XMLObject xmlElement, int elementPosition) {
        XMLObject result;
        if (xmlElement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bpmobject/runtime/SortedChildrenList.set must not be null");
        }
        if (elementPosition != -1) {
            result = this.remove(index);
            this.add(xmlElement, elementPosition);
        } else {
            result = this.set(index, xmlElement);
        }
        return result;
    }

    @Override
    public boolean add(XMLObject e) {
        this.add(this.size(), e, -1);
        return true;
    }

    @Override
    public void add(int index, @NotNull XMLObject element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bpmobject/runtime/SortedChildrenList.add must not be null");
        }
        this.add(index, element, index);
    }

    public void add(@NotNull XMLObject element, int elementPosition) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bpmobject/runtime/SortedChildrenList.add must not be null");
        }
        this.add(-1, element, elementPosition);
    }

    @Override
    public XMLObject remove(int index) {
        Node node = this.getNode(index);
        this.getElement().removeChild(node);
        return XMLObject.valueOf(node);
    }

    public List<XMLObject> sortChildrenList() {
        return this;
    }

    @Override
    public boolean addAll(int index, Collection<? extends XMLObject> c) {
        Node refChild = this.findInsertPosition(index);
        for (XMLObject xMLObject : c) {
            this.makeLocal(xMLObject);
            this.insertBefore(xMLObject.getNode(), refChild);
            xMLObject.elementPosition = index;
        }
        return true;
    }

    private void insertBefore(@NotNull Node newNode, @Nullable Node refChild) {
        if (newNode == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bpmobject/runtime/SortedChildrenList.insertBefore must not be null");
        }
        Element element = this.getElement();
        if (refChild == null) {
            element.appendChild(newNode);
        } else {
            element.insertBefore(newNode, refChild);
        }
    }

    private Element getElement() {
        return this.root.getElement();
    }

    private void makeLocal(XMLObject element) {
        Document thisDocument = this.getElement().getOwnerDocument();
        Node node = element.getNode();
        Node newNode = null;
        if (node == null) {
            XMLText xmlText = (XMLText)element;
            xmlText.setTextNode(thisDocument.createTextNode(xmlText.getText()));
        } else if (node.getOwnerDocument() == thisDocument) {
            if (node.getParentNode() != null) {
                newNode = node.cloneNode(true);
            }
        } else {
            newNode = node.getParentNode() != null ? thisDocument.importNode(node, true) : thisDocument.adoptNode(node);
        }
        if (newNode != null) {
            XMLObject.fixUserData(node, newNode);
        }
    }

    private void add(int index, @NotNull XMLObject xmlElement, int elementPosition) {
        if (xmlElement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bpmobject/runtime/SortedChildrenList.add must not be null");
        }
        this.makeLocal(xmlElement);
        Node node = xmlElement.getNode();
        Node refChild = elementPosition != -1 ? this.findInsertPosition(elementPosition) : (index >= 0 && index < this.size() ? this.getNode(index) : null);
        this.insertBefore(node, refChild);
        xmlElement.elementPosition = elementPosition;
    }

    @Nullable
    private Node findInsertPosition(int elementPosition) {
        Node result = null;
        if (elementPosition != -1) {
            int i = this.size();
            while (--i >= 0) {
                int childPosition;
                Node child = this.getNode(i);
                if (child.getNodeType() != 1 || (childPosition = XMLObject.valueOf((Node)child).elementPosition) == -1) continue;
                if (childPosition <= elementPosition) break;
                result = child;
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Node getNode(int index) {
        Node result = this.getElement().getChildNodes().item(index);
        if (result == null) {
            throw new IndexOutOfBoundsException();
        }
        Node node = result;
        if (node == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/bpmobject/runtime/SortedChildrenList.getNode must not return null");
        }
        return node;
    }
}

