/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.util.HashMap;
import oracle.bpm.lang.Decimal;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.RegExp;
import oracle.bpm.lang.Time;
import oracle.bpm.util.VariableDummper;

public class DebugValue {
    public static byte debug(byte value, int line, String varName) {
        return DebugValue.debugByte(value, line, varName);
    }

    public static short debug(short value, int line, String varName) {
        return DebugValue.debugShort(value, line, varName);
    }

    public static int debug(int value, int line, String varName) {
        return DebugValue.debugInt(value, line, varName);
    }

    public static double debug(double value, int line, String varName) {
        return DebugValue.debugDouble(value, line, varName);
    }

    public static char debug(char value, int line, String varName) {
        return DebugValue.debugChar(value, line, varName);
    }

    public static Object debug(Object value, int line, String varName) {
        return DebugValue.debugObject(value, line, varName);
    }

    public static long debug(long value, int line, String varName) {
        return DebugValue.debugLong(value, line, varName);
    }

    public static float debug(float value, int line, String varName) {
        return DebugValue.debugFloat(value, line, varName);
    }

    public static boolean debug(boolean value, int line, String varName) {
        return DebugValue.debugBoolean(value, line, varName);
    }

    public static boolean debugBoolean(boolean value, int line, String varName) {
        DebugValue.out(line, varName, value);
        return value;
    }

    public static byte debugByte(byte value, int line, String varName) {
        DebugValue.out(line, varName, value);
        return value;
    }

    public static char debugChar(char value, int line, String varName) {
        DebugValue.out(line, varName, Character.valueOf(value));
        return value;
    }

    public static double debugDouble(double value, int line, String varName) {
        DebugValue.out(line, varName, value);
        return value;
    }

    public static float debugFloat(float value, int line, String varName) {
        DebugValue.out(line, varName, Float.valueOf(value));
        return value;
    }

    public static int debugInt(int value, int line, String varName) {
        DebugValue.out(line, varName, value);
        return value;
    }

    public static long debugLong(long value, int line, String varName) {
        DebugValue.out(line, varName, value);
        return value;
    }

    public static void debugNull(int line, String varName) {
        DebugValue.out(line, varName, null);
    }

    public static Object debugObject(Object value, int line, String varName) {
        DebugValue.out(line, varName, value);
        return value;
    }

    public static short debugShort(short value, int line, String varName) {
        DebugValue.out(line, varName, value);
        return value;
    }

    public static void main(String[] args) {
        DebugValue.debug((byte)10, 0, "byte");
        DebugValue.debug((short)10, 0, "short");
        DebugValue.debug(10, 0, "int");
        DebugValue.debug(10L, 0, "long");
        DebugValue.debug('x', 0, "char");
        DebugValue.debug("hello \nworld", 0, "String");
        DebugValue.debug(true, 0, "boolean");
        DebugValue.debug(Boolean.TRUE, 0, "Boolean");
        DebugValue.debug(10.0f, 0, "float");
        DebugValue.debug(10.0, 0, "double");
        DebugValue.debug(Time.valueOf(2000, 10, 10), 0, "time");
        DebugValue.debug(Interval.valueOf(0L), 0, "interval");
        DebugValue.debug(RegExp.valueOf("/./x/"), 0, "regexp");
        DebugValue.debug(null, 0, "null");
        DebugValue.debug(Decimal.ZERO, 0, "decimal");
        DebugValue.debug(new int[]{1, 2, 3}, 0, "int[]");
        DebugValue.debug(new long[]{1L, 2L, 3L}, 0, "long[]");
        DebugValue.debug(new char[]{'a', 'b'}, 0, "char[]");
        DebugValue.debug(new byte[]{-1, 0, 1, 14}, 0, "bytes");
        HashMap<Integer, String> a = new HashMap<Integer, String>();
        a.put(10, "ten");
        a.put(20, "twenty");
        DebugValue.debug(a, 0, "map");
    }

    private static void out(int line, String varName, Object value) {
        System.out.println("[" + line + "] " + varName + " = " + VariableDummper.asString(value));
    }
}

