/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler.langs.visualbasic;

import oracle.bpm.compiler.Args;
import oracle.bpm.compiler.ArrayConst;
import oracle.bpm.compiler.ArrayReference;
import oracle.bpm.compiler.Assignment;
import oracle.bpm.compiler.BaseCILSourceGenerator;
import oracle.bpm.compiler.Block;
import oracle.bpm.compiler.Cast;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.Declaration;
import oracle.bpm.compiler.Deref;
import oracle.bpm.compiler.DoBlock;
import oracle.bpm.compiler.Exit;
import oracle.bpm.compiler.For;
import oracle.bpm.compiler.ForEach;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.If;
import oracle.bpm.compiler.InvalidLanguageException;
import oracle.bpm.compiler.Invoke;
import oracle.bpm.compiler.Is;
import oracle.bpm.compiler.JavaFor;
import oracle.bpm.compiler.LabeledStatement;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.compiler.MemberAccess;
import oracle.bpm.compiler.MemberReference;
import oracle.bpm.compiler.Method;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.On;
import oracle.bpm.compiler.OnExit;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.StringCat;
import oracle.bpm.compiler.Switch;
import oracle.bpm.compiler.TransformCall;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.TypeSpec;
import oracle.bpm.compiler.While;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;

public class VisualBasicCILSourceGenerator
extends BaseCILSourceGenerator
implements SourceGenerator {
    public VisualBasicCILSourceGenerator() throws InvalidLanguageException {
        this(LanguageSpec.getLanguageSpec("VisualBasic"));
    }

    public VisualBasicCILSourceGenerator(LanguageSpec langSpec) {
        super(langSpec);
        this.generateIsNullAsEq = true;
        this.generateNotBeforeIs = true;
    }

    @Override
    public void generate(TransformCall transformCall, Node source, Node target, Node library) {
        this.print("CType(");
        this.generateTransformArgs(source);
        this.print(", ");
        this.generateExpr(target);
        this.print(", ");
        this.generateExpr(library);
        this.print(")");
    }

    @Override
    public void generate(Declaration decl) {
        this.print("Dim ");
        super.generate(decl);
    }

    @Override
    public void generate(StringCat cat, Node left, Node right) {
        this.generateExpr(left);
        this.printSpaceDelimited(this.getNames().getConcatOperator());
        this.generateExpr(right);
    }

    @Override
    public void generate(Cast cast) {
        TypeDescription targetType = cast.getTypeDescription();
        Node expr = cast.getExpr();
        Node type = cast.getTargetType();
        this.generateCast(targetType, expr, type);
    }

    @Override
    public void generate(Conversion conversion, Node op) {
        if (!conversion.isSyntheticCast()) {
            this.generateCast(conversion.getTypeDescription(), op, null);
        } else {
            this.generateExpr(op);
        }
    }

    @Override
    public void generate(Method method) {
        boolean hasExceptions;
        boolean isFunction = !method.getResultType().isVoid();
        this.print(isFunction ? "Function " : "Sub ");
        this.printIdentifier(method.getName());
        MethodTypeDescription methodType = method.getMethodType();
        this.generateMethodArgs(methodType, false);
        this.generateMethodResult(methodType);
        this.println();
        this.indent();
        Block declarations = method.getDeclarations();
        Block exceptions = method.getExceptions();
        OnExit onExit = method.getOnExit();
        boolean bl = hasExceptions = exceptions != null && exceptions.hasChildren();
        if (declarations.hasChildren()) {
            this.generate(declarations);
            this.pw.printSeparator();
        }
        if (hasExceptions || onExit != null) {
            this.println("Try ");
            this.indent();
        }
        this.generate(method.getStatements());
        if (hasExceptions) {
            this.unindent();
            exceptions.generate(this);
        }
        if (onExit != null) {
            onExit.generate(this);
        }
        if (hasExceptions || onExit != null) {
            this.println("End Try");
        }
        this.unindent();
        this.print("End ");
        this.println(isFunction ? "Function" : "Sub");
        this.pw.close();
    }

    @Override
    public void generate(DoBlock doblock) {
        boolean isTry;
        Block exceptions = doblock.getExceptions();
        OnExit onExit = doblock.getOnExit();
        boolean bl = isTry = exceptions != null && exceptions.hasChildren() || onExit != null;
        if (isTry) {
            this.print("Try");
        } else {
            this.print("Do");
        }
        this.println(" ");
        this.generateIndented(doblock.getDeclarations());
        this.generateIndented(doblock.getStatements());
        if (exceptions != null) {
            ((Node)exceptions).generate(this);
        }
        if (onExit != null) {
            onExit.generate(this);
        }
        if (isTry) {
            this.println("End Try");
        } else {
            this.println("End Do");
        }
        this.generateSeparatorAfter(doblock);
    }

    @Override
    public void generate(Is is, Node expr, TypeDescription type, boolean negative) {
        if (type != TypeFactory.getNull()) {
            if (negative) {
                this.print("Not ");
                negative = false;
            }
            this.print("TypeOf ");
        }
        super.generate(is, expr, type, negative);
    }

    @Override
    public void generate(On on) {
        this.print("Catch ");
        on.getOp2().generate(this);
        this.printSpaceDelimited("As");
        on.getOp1().generate(this);
        this.println();
        this.generateIndented(on.getOp3());
    }

    @Override
    public void generate(Exit exit, Node predicate, Node label) {
        Method currentMember;
        this.generateSeparatorBefore(exit);
        if (predicate != null) {
            predicate.setParenthesis(true);
            this.print("If ");
            this.generateExpr(predicate);
            this.println(" Then");
            this.indent();
        }
        this.print("Exit");
        if (label != null) {
            this.printSpace();
            label.generate(this);
        } else if (!exit.isInLoop() && (currentMember = exit.getCurrentMember()) != null) {
            this.printSpace();
            this.printIdentifier(currentMember.getMethodType().getName());
        }
        this.generateStatementSeparator(exit);
        if (predicate != null) {
            this.unindent();
            this.println("End If");
        }
        this.generateSeparatorAfter(exit);
    }

    @Override
    public void generate(ArrayConst arrayConst, boolean isMap) {
        super.generate(arrayConst, isMap);
    }

    @Override
    public void generate(If ifnode) {
        if (!(ifnode.getParent() instanceof If)) {
            this.generateSeparatorBefore(ifnode);
        }
        this.print("If");
        this.generateIfPredicate(ifnode.getPredicate());
        this.println("Then");
        this.generateIndented(ifnode.getThen());
        if (ifnode.hasElse()) {
            Node elseNode = ifnode.getElse();
            if (elseNode instanceof If) {
                this.generateElseIf(elseNode);
            } else {
                this.generateElse(elseNode);
            }
        } else {
            this.println("End If");
        }
        this.generateSeparatorAfter(ifnode);
    }

    @Override
    public void generate(JavaFor javaFor) {
        Node parent = javaFor.getParent();
        LabeledStatement labeled = (LabeledStatement)(parent instanceof LabeledStatement ? parent : null);
        if (javaFor.isArrayIterator()) {
            Node decl = javaFor.getInit().getFirst();
            String index = decl.getSymbol().getName();
            MemberAccess arrayLength = (MemberAccess)javaFor.getCond().getOp2();
            Node array = arrayLength.getObject();
            if (labeled != null) {
                this.generateLabel(labeled);
            }
            this.print("For ");
            this.printIdentifier(index);
            this.printSpaceDelimited("=");
            this.generateExpr(array);
            this.println("");
            this.indent();
            javaFor.getBody().generate(this);
            this.unindent();
            this.print("Next ");
            this.println(index);
        } else {
            this.generateSeparatorBefore(javaFor);
            this.println("Do");
            this.indent();
            javaFor.getInit().getFirst().generate(this);
            if (labeled != null) {
                this.generateLabel(labeled);
            }
            this.print("While ");
            this.generateExpr(javaFor.getCond());
            this.println("");
            this.indent();
            javaFor.getBody().generate(this);
            javaFor.getReinit().generate(this);
            this.unindent();
            this.println("End While");
            this.unindent();
            this.println("End Do");
        }
    }

    @Override
    public void generate(While whileNode, Node predicate, Node body) {
        this.generateSeparatorBefore(whileNode);
        this.print("While ");
        this.generateExpr(predicate);
        this.println();
        this.generateIndented(body);
        this.print("End While");
        this.generateStatementSeparator(whileNode);
        this.generateSeparatorAfter(whileNode);
    }

    @Override
    public void generate(For fornode, Node index, Node range, Node body) {
        this.generateSeparatorBefore(fornode);
        this.print("For ");
        index.generate(this);
        this.printSpaceDelimited("As");
        this.generateType(index.getTypeDescription(), this.getContext(fornode));
        this.printSpaceDelimited("=");
        this.generateExpr(range);
        this.println();
        this.generateIndented(body);
        this.print("Next ");
        index.generate(this);
        this.println();
        this.generateSeparatorAfter(fornode);
    }

    @Override
    public void generate(ForEach foreach, Node index, Node array, Node where, Node body) {
        this.generateSeparatorBefore(foreach);
        this.print("For Each ");
        this.printIdentifier(index.getText());
        this.printSpaceDelimited("In");
        this.generateExpr(array);
        this.println();
        if (where == null) {
            this.generateIndented(body);
        } else {
            this.print("If ");
            this.clearSynthetic(where);
            where.generate(this);
            this.println(" Then");
            body.generate(this);
            this.generateIndented(body);
            this.println("End If");
        }
        this.print("Next ");
        index.generate(this);
        this.println();
        this.generateSeparatorAfter(foreach);
    }

    @Override
    public void generate(Invoke invoke, Node object, Args inArgs, Args outArgs, String memberName) {
        boolean basicReference;
        boolean bl = basicReference = object instanceof Identifier || object instanceof Const || object instanceof MemberReference || object instanceof ArrayReference || object instanceof Deref && object.getOp1() instanceof TypeSpec || "delete".equals(memberName);
        if (basicReference) {
            super.generate(invoke, object, inArgs, outArgs, memberName);
        } else {
            Invoke targetInvoke;
            MethodTypeDescription member = invoke.getMemberType();
            if (member.isConstructor()) {
                this.generateConstructorName(invoke, member);
            } else {
                if (member.isStatic()) {
                    object.generate(this);
                    this.print(".");
                }
                this.printIdentifier(memberName);
            }
            this.print("(");
            if (!(member.isStatic() || member.isConstructor() || object.isSynthetic())) {
                object.generate(this);
                if (this.hasArgs(inArgs) || this.hasArgs(outArgs)) {
                    this.print(", ");
                }
            }
            this.generate(inArgs);
            if (this.hasArgs(outArgs)) {
                if (this.hasArgs(inArgs)) {
                    this.print(", ");
                }
                this.generate(outArgs);
            }
            if ((targetInvoke = invoke.getTargetInvoke()) != null) {
                this.print(")");
                this.generateRelayTo(targetInvoke);
            } else {
                this.print(")");
            }
            if (invoke.isStatement()) {
                this.generateStatementSeparator(invoke);
                this.generateSeparatorAfter(invoke);
            }
        }
    }

    @Override
    public void generate(Switch switchNode, Node expr, Node cases) {
        this.generateSeparatorBefore(switchNode);
        this.print("Select ");
        expr.generate(this);
        this.println();
        this.indent();
        while (cases != null) {
            cases.generate(this);
            cases = cases.getNext();
        }
        this.unindent();
        this.println("End Select");
        this.generateSeparatorAfter(switchNode);
    }

    @Override
    public void generate(Switch.Case caseNode, Node cond, Node body) {
        this.print("Case ");
        cond.generate(this);
        this.println();
        this.generateIndented(body);
    }

    @Override
    public void generate(Switch.Default defaultNode, Node body) {
        this.println("Case Else ");
        this.generateIndented(body);
    }

    @Override
    public void generate(Assignment assignment, Node target, Node value) {
        if (assignment.isStatement()) {
            super.generate(assignment, target, value);
        } else {
            this.pw.print("Do (");
            super.generate(assignment, target, value);
            this.pw.print(")");
        }
    }

    @Override
    public void generateTargetObjectExpression(Node object, Invoke invoke) {
        if (object instanceof ArrayReference && invoke.isStatement()) {
            TypeDescription type = object.getTypeDescription();
            String baseId = "a" + type.getName();
            String varName = object.findFreeId(baseId);
            Declaration decl = new Declaration(varName, type, object);
            try {
                decl.initialize(invoke);
                decl.checkType();
            }
            catch (TypeException e) {
                e.printStackTrace();
            }
            this.generate(decl);
            this.print(varName);
            this.print(".");
        } else {
            super.generateTargetObjectExpression(object, invoke);
        }
    }

    @Override
    protected SourceGenerator createSqlGenerator() {
        BaseCILSourceGenerator sg = (BaseCILSourceGenerator)super.createSqlGenerator();
        sg.getNames().setTimeStart("#");
        sg.getNames().setTimeEnd("#");
        return sg;
    }

    @Override
    protected void generateArgsForRelayTo(Args args) {
        this.generateArgsForInteractiveStm(args, null);
    }

    @Override
    protected void generateElse(Node elseNode) {
        this.println("Else");
        this.generateIndented(elseNode);
        this.println("End If");
    }

    private void generateCast(TypeDescription targetType, Node expr, Node type) {
        int kind = targetType.getKind();
        int length = targetType.getLength();
        String primitiveCast = null;
        switch (kind) {
            case 2: {
                if (length <= 8) {
                    primitiveCast = "CByte";
                    break;
                }
                if (length <= 16) {
                    primitiveCast = "CShort";
                    break;
                }
                if (length <= 32) {
                    primitiveCast = "CInt";
                    break;
                }
                primitiveCast = "CLng";
                break;
            }
            case 3: {
                primitiveCast = "CDec";
                break;
            }
            case 5: {
                primitiveCast = length == 1 ? "CChar" : (length == -1 ? "CStr" : null);
                break;
            }
            case 4: {
                primitiveCast = length == 32 ? "CSng" : "CDbl";
                break;
            }
            case 1: {
                primitiveCast = "CBool";
            }
        }
        expr.setParenthesis(false);
        if (primitiveCast != null) {
            this.print(primitiveCast);
            this.print("(");
            this.generateExpr(expr);
            this.print(")");
        } else {
            this.print("CType(");
            this.generateExpr(expr);
            this.print(", ");
            if (type != null) {
                type.generate(this);
            } else {
                this.generateType(targetType, this.getContext(expr));
            }
            this.print(")");
        }
    }
}

