/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler.langs.visualbasic;

import fuego.parser.MismatchedTokenException;
import fuego.parser.RecognitionException;
import fuego.parser.TokenStream;
import fuego.parser.TokenStreamException;
import fuego.parser.collections.AST;
import oracle.bpm.compiler.Arg;
import oracle.bpm.compiler.Args;
import oracle.bpm.compiler.ArrayReference;
import oracle.bpm.compiler.Block;
import oracle.bpm.compiler.Declaration;
import oracle.bpm.compiler.Deref;
import oracle.bpm.compiler.DoBlock;
import oracle.bpm.compiler.Function;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.InputField;
import oracle.bpm.compiler.InputFields;
import oracle.bpm.compiler.MemberReference;
import oracle.bpm.compiler.NamedNode;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.SetElement;
import oracle.bpm.compiler.SetMember;
import oracle.bpm.compiler.SwitchCases;
import oracle.bpm.compiler.TransformCall;
import oracle.bpm.compiler.TypeSpec;
import oracle.bpm.compiler.langs.visualbasic.VisualBasicCILBaseParser;

public final class VisualBasicCILParser
extends VisualBasicCILBaseParser {
    public VisualBasicCILParser(TokenStream lexer) {
        super(lexer);
        this.setSqlExitTokens(new int[]{208, 59});
    }

    public static Node processInputFields(Node result) {
        Node fields = null;
        Node lastField = null;
        Node current = result;
        while (current != null) {
            Node next = current.getNext();
            if (current instanceof InputField) {
                current.removeFromParent();
                if (current == result) {
                    result = next;
                }
                if (fields == null) {
                    fields = current;
                } else {
                    lastField.setNext(current);
                }
                lastField = current;
            }
            current = next;
        }
        InputFields input = new InputFields((AST)fields);
        input.setNext(result);
        return input;
    }

    public static Node processRelayToArgs(Node result) {
        Node targetId = result;
        Args args = Function.createArgs(result.getNext(), null);
        args.setArgType(256L);
        targetId.setNext(args.getFirst());
        args.setFirst(targetId);
        result = args;
        return result;
    }

    @Override
    public void args() throws RecognitionException, TokenStreamException {
        super.args();
        this.result = Function.createArgs(this.result, null);
    }

    @Override
    public void assignment() throws RecognitionException, TokenStreamException {
        super.assignment();
        Node originalResult = this.result;
        Node op1 = this.result.getOp1();
        Node expr = this.result.getOp2();
        if (op1 instanceof Deref) {
            this.result.setOperands(op1.getOp1(), expr);
        } else if (op1 instanceof MemberReference) {
            SetMember setMember = new SetMember();
            setMember.setFirst(op1.getFirst());
            setMember.addChild((AST)expr);
            this.result = setMember;
        } else if (op1 instanceof ArrayReference) {
            SetElement setElement = new SetElement();
            setElement.setFirst(op1.getFirst());
            setElement.addChild((AST)expr);
            this.result = setElement;
        } else if (op1 instanceof Function) {
            Node argType;
            Node argValue;
            int childCount = op1.childCount();
            Node functionId = op1.getOp1();
            if (childCount == 1) {
                SetElement setElement = new SetElement();
                setElement.addOneChild(functionId);
                setElement.addOneChild(expr);
                this.result = setElement;
            } else if (childCount == 3 && !((argValue = (argType = op1.getOp2()).getNext()) instanceof NamedNode)) {
                SetElement setElement = new SetElement();
                setElement.addOneChild(functionId);
                setElement.addOneChild(argValue);
                setElement.addOneChild(expr);
                this.result = setElement;
            }
        }
        if (this.result != originalResult) {
            this.result.initialize(originalResult);
        }
    }

    @Override
    public void callStatement() throws RecognitionException, TokenStreamException {
        super.callStatement();
        this.result.setExpression(false);
    }

    @Override
    public void caseClauses() throws RecognitionException, TokenStreamException {
        super.caseClauses();
        this.result = new SwitchCases((AST)this.result);
    }

    @Override
    public void castExpr() throws RecognitionException, TokenStreamException {
        super.castExpr();
        if (this.result instanceof TransformCall) {
            Node cast = this.result.getFirst();
            Node first = cast.getFirst();
            Node last = first.getLast();
            last.setNext(cast.getNext());
            this.result.setFirst(first);
        }
    }

    @Override
    public void catchStatement() throws RecognitionException, TokenStreamException {
        super.catchStatement();
        this.result.setOperands(this.result.getOp2(), this.result.getOp1(), this.result.getOp3());
    }

    @Override
    public void catchStatements() throws RecognitionException, TokenStreamException {
        super.catchStatements();
        this.result = new Block((AST)this.result);
    }

    @Override
    public void derefPrimary() throws RecognitionException, TokenStreamException {
        super.derefPrimary();
        this.result = new Deref(this.result);
    }

    @Override
    public void doLoopStatement() throws RecognitionException, TokenStreamException {
        super.doLoopStatement();
        if (this.result instanceof DoBlock) {
            this.result.addChild((AST)new Block());
        }
    }

    @Override
    public void emptyStatement() throws RecognitionException, TokenStreamException {
        super.emptyStatement();
        this.result = this.betweenStatement(null, null);
    }

    @Override
    public void fields() throws RecognitionException, TokenStreamException {
        super.fields();
        this.result = VisualBasicCILParser.processInputFields(this.result);
    }

    @Override
    public void function() throws RecognitionException, TokenStreamException {
        super.function();
        VisualBasicCILParser.addDeclarationBlock(this.result);
    }

    @Override
    public void ifStatement() throws RecognitionException, TokenStreamException {
        super.ifStatement();
        if (this.result.childCount() == 1) {
            this.result.addChild((AST)new Block());
        }
    }

    @Override
    public void inMode() throws RecognitionException, TokenStreamException {
        super.inMode();
        this.result = new Arg.Type(1L);
    }

    @Override
    public void inoutMode() throws RecognitionException, TokenStreamException {
        super.inoutMode();
        this.result = new Arg.Type(3L);
    }

    @Override
    public void match(int token) throws MismatchedTokenException, TokenStreamException {
        if (token == 5) {
            if (this.LA(1) == 5 || this.LA(1) == 1) {
                this.consume();
            } else {
                MismatchedTokenException e = new MismatchedTokenException(this.tokenNames, this.LT(1), token, false, this.getFilename());
                this.reportWarning((RecognitionException)e);
            }
            return;
        }
        super.match(token);
    }

    @Override
    public void multiDeclaration() throws RecognitionException, TokenStreamException {
        super.multiDeclaration();
        this.result = Declaration.make(this.result, this.result.getLast());
    }

    @Override
    public void oneStatement() throws RecognitionException, TokenStreamException {
        super.oneStatement();
        this.result = new Block((AST)this.result);
    }

    @Override
    public void outArg() throws RecognitionException, TokenStreamException {
        super.outArg();
        if (this.result.getNext() != null) {
            this.result = new NamedNode((AST)this.result, (AST)this.result.getNext());
        }
    }

    @Override
    public void outMode() throws RecognitionException, TokenStreamException {
        super.outMode();
        this.result = new Arg.Type(2L);
    }

    @Override
    public void primitiveCast() throws RecognitionException, TokenStreamException {
        super.primitiveCast();
        this.result.setOperands(this.result.getOp2(), this.result.getOp1());
    }

    @Override
    public void procedure() throws RecognitionException, TokenStreamException {
        super.procedure();
        VisualBasicCILParser.addDeclarationBlock(this.result);
    }

    @Override
    public void reference() throws RecognitionException, TokenStreamException {
        super.reference();
        if (this.result instanceof Identifier) {
            this.result = new Deref(this.result);
        }
    }

    @Override
    public void relay() throws RecognitionException, TokenStreamException {
        super.relay();
        this.result = VisualBasicCILParser.processRelayToArgs(this.result);
    }

    @Override
    public void simpleType() throws RecognitionException, TokenStreamException {
        super.simpleType();
        this.result = new TypeSpec((AST)this.result, null, null);
    }

    @Override
    public void statement() throws RecognitionException, TokenStreamException {
        Node before = this.betweenStatement(null, null);
        super.statement();
        this.result = this.betweenStatement(this.result, null);
        if (before != null) {
            before.getLast().setNext(this.result);
            this.result = before;
        }
    }

    @Override
    public void statements() throws RecognitionException, TokenStreamException {
        super.statements();
        this.result = new Block((AST)this.result);
    }

    @Override
    public void value() throws RecognitionException, TokenStreamException {
        super.value();
        this.result.setParenthesis(true);
    }

    @Override
    protected boolean isDelimiter(int token) {
        return super.isDelimiter(token) || token == 5;
    }

    static void addDeclarationBlock(Node result) {
        assert (result instanceof DoBlock) : "Node is not a DoBlock. Tree: \n" + result.dump();
        Node statements = result.getFirst().getLast();
        Block declaration = Block.makeEmpty(result);
        Node prev = statements.getPrev();
        if (prev == null) {
            result.setFirst(declaration);
        } else {
            prev.setNext(declaration);
        }
        declaration.setNext(statements);
    }
}

