/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import java.util.HashMap;
import java.util.Map;
import oracle.bpm.compiler.BasicMonitor;
import oracle.bpm.compiler.BreakPoint;
import oracle.bpm.compiler.ConditionalBreakPoint;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.compiler.FunctionDefinition;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NullStatement;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.Scope;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.ValueReference;
import oracle.bpm.compiler.langs.fuego.FuegoCILSourceGenerator;
import oracle.bpm.lang.Any;
import oracle.bpm.type.SourceCode;

public class Watch {
    private RunningMonitor basicMonitor;
    private BreakPoint bp;
    private String dumpedValue;
    private boolean evaluationInProcess;
    private String expression;
    private Map<Scope, Node> expressions = new HashMap<Scope, Node>();
    private Object value = null;
    public static final String NOT_IN_SCOPE = "EXPRESSION_NOT_IN_SCOPE";

    public Watch(ConditionalBreakPoint bp) {
        this();
        this.expression = bp.getText();
        this.bp = bp;
    }

    public Watch(String expression) {
        this();
        this.expression = expression;
    }

    private Watch() {
        this.basicMonitor = new BasicMonitor();
        this.basicMonitor.setEvaluateWatchesEnabled(true);
    }

    public BreakPoint getBreakPoint() {
        return this.bp;
    }

    public void setDumpedValue(String text) {
        this.dumpedValue = text;
    }

    public String getDumpedValue() {
        if (this.dumpedValue != null) {
            return this.dumpedValue;
        }
        Object value = this.getValue();
        if (value instanceof ValueReference) {
            value = ((ValueReference)value).get();
        }
        return FuegoCILSourceGenerator.generateCILForValue(value);
    }

    public boolean isEditable() {
        return this.getValue() instanceof ValueReference;
    }

    public String getText() {
        return this.expression;
    }

    public void setValue(Object value) {
        this.dumpedValue = null;
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public void reset() {
        this.value = null;
    }

    public String toString() {
        return "Watch[" + (this.bp != null ? "BreakPoint, " : "") + this.getText() + "]";
    }

    public boolean isEvaluationInProcess() {
        return this.evaluationInProcess;
    }

    public void setEvaluationInProcess(boolean evaluationInProcess) {
        this.evaluationInProcess = evaluationInProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean evaluate(Node step) {
        Object value;
        if (this.isEvaluationInProcess()) {
            return false;
        }
        Node expression = this.getExpression(step);
        try {
            if (expression == null) {
                value = NOT_IN_SCOPE;
            } else {
                this.setEvaluationInProcess(true);
                value = expression.run(this.basicMonitor);
            }
            if (value instanceof Symbol) {
                value = new ValueReference.VariableReference((Symbol)value);
            }
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            value = e;
        }
        finally {
            this.setEvaluationInProcess(false);
        }
        if (!Any.equals(value, this.value)) {
            this.value = value;
            this.dumpedValue = null;
            return true;
        }
        return false;
    }

    private Node getExpression(Node node) {
        Scope scope = node.getScope();
        Node expression = this.expressions.get(scope);
        if (expression != null) {
            return expression instanceof NullStatement ? null : expression;
        }
        FuegoCompiler compiler = node.getCompiler();
        expression = compiler.createWatch(SourceCode.create(this.expression, "Fuego"), node);
        if (expression instanceof FunctionDefinition) {
            expression = ((FunctionDefinition)expression).getExpr();
        }
        if (expression instanceof Conversion) {
            Conversion conv = (Conversion)expression;
            expression = conv.getOperand();
        }
        if (expression != null) {
            expression.getScope().setStepEnabled(false);
        } else {
            expression = new NullStatement();
        }
        this.expressions.put(scope, expression);
        return expression;
    }
}

