/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.ConstFormatException;
import oracle.bpm.compiler.ConstGenerator;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.IntervalConst;
import oracle.bpm.compiler.InvalidTimeException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.TimeFormatException;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.filter.Operation;
import org.jetbrains.annotations.NonNls;

public class TimeConst
extends Const {
    private String originalConst;
    private Time value = null;
    @NonNls
    private static final String NOW_TEXT = "now";
    static final long serialVersionUID = 6388538287594048512L;
    static final long serialCheck = 141127331741854116L;

    public TimeConst(Token t) {
        this(t, t.getText());
    }

    TimeConst(@NonNls String txt) {
        this(null, txt);
    }

    private TimeConst(Token t, String txt) {
        super(t, TypeFactory.getTime());
        if (txt.equals("") || txt.equals(NOW_TEXT)) {
            return;
        }
        String str = txt;
        try {
            this.value = Time.valueOf(str);
        }
        catch (TimeFormatException firstTry) {
            try {
                int first = txt.indexOf(47);
                if (first > 2) {
                    this.value = Time.valueOf(txt);
                } else {
                    int second = txt.indexOf(47, first + 1);
                    int last = txt.indexOf(32);
                    if (last == -1) {
                        last = txt.length();
                    }
                    str = txt.substring(second + 1, last) + "/" + txt.substring(first + 1, second) + "/" + txt.substring(0, first) + txt.substring(last);
                    this.value = Time.valueOf(str);
                }
            }
            catch (StringIndexOutOfBoundsException e) {
                this.exception = new InvalidTimeException((Node)this, txt);
            }
            catch (TimeFormatException e) {
                this.exception = new ConstFormatException((Node)this, e);
            }
        }
        this.originalConst = str;
    }

    public static TimeConst createNow() {
        return new TimeConst("");
    }

    @Override
    public String getSyntheticName() {
        return TimeConst.createSyntheticNameFromType(this.getTypeDescription(), TimeConst.translate(this.getText()));
    }

    @Override
    public String getText() {
        return this.isNow() ? NOW_TEXT : this.originalConst;
    }

    public boolean isNow() {
        return this.value == null;
    }

    public Time getValue() {
        return this.value;
    }

    @Override
    public void generate(ConstGenerator cg) {
        cg.generate(this);
    }

    @Override
    public String toString() {
        return super.toString() + "'" + this.getText() + "'";
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    final boolean equals(Node b) {
        return b instanceof TimeConst && this.value.equals(((TimeConst)b).value);
    }

    @Override
    boolean isCollectable() {
        return !this.isNow();
    }

    @Override
    boolean isConstant() {
        return !this.isNow();
    }

    @Override
    Operation getOperationTree() {
        if (this.isParameter()) {
            return new Operation(0, "?", null);
        }
        return new Operation(24, null, null, this.getText());
    }

    TimeConst add(IntervalConst b) {
        this.value = this.value.add(b.value);
        this.originalConst = this.value.toString();
        return this;
    }

    @Override
    int compare(Node b) {
        return this.value.compareTo(((TimeConst)b).value);
    }

    @Override
    void generateSQLCode(StringBuffer sql) {
        sql.append(" ? ");
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        return this.isNow() ? Time.now() : this.value;
    }

    TimeConst sub(IntervalConst b) {
        this.value = this.value.sub(b.value);
        this.originalConst = this.value.toString();
        return this;
    }

    IntervalConst sub(TimeConst b) {
        return new IntervalConst(this.value.sub(b.value), this);
    }

    private static String translate(String text) {
        if (text == null) {
            return null;
        }
        String search = "/:-+.";
        String replace = "scmpd";
        StringBuilder result = new StringBuilder();
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            int p = "/:-+.".indexOf(c);
            result.append(p < 0 ? c : "scmpd".charAt(p));
        }
        return result.toString();
    }
}

