/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.CompilerExceptionShell;
import oracle.bpm.compiler.DefaultConst;
import oracle.bpm.compiler.Deref;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.FlowContext;
import oracle.bpm.compiler.FlowException;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.MemberReferenceException;
import oracle.bpm.compiler.NoSuchComponentException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NotInstantiableException;
import oracle.bpm.compiler.NotThrowableException;
import oracle.bpm.compiler.ObjectClass;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.TypeSpec;
import oracle.bpm.compiler.UndefinedVariableException;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.RuntimeCILExecutionException;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;

public class Throw
extends Node {
    private boolean userDefined = false;
    private static TypeDescription throwableType = null;
    static final long serialVersionUID = -7579720823111787141L;
    static final long serialCheck = 6900794899056609088L;

    public Throw(Token t) {
        super(t);
    }

    Throw() {
        this((Token)null);
    }

    @Override
    public String getText() {
        return "throw";
    }

    public boolean isUserDefined() {
        return this.userDefined;
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this, this.getFirst());
    }

    @Override
    protected boolean splitToPrint() {
        return true;
    }

    static Throw exception(String exception, Node init) {
        Throw node = new Throw();
        node.setFirst(new Identifier(exception));
        node.initialize(init);
        return node;
    }

    @Override
    FlowContext checkFlow(FlowContext context) throws FlowException {
        Node op = this.getFirst();
        op.checkFlow(context);
        Symbol symbol = op.getSymbol();
        if (symbol != null) {
            context.use(symbol, op);
        }
        context.breaksFlow(true);
        return context;
    }

    @Override
    Node checkType() throws TypeException {
        if (this.getKind() != -1) {
            return this;
        }
        this.setTypeDescription(TypeFactory.getVoid());
        TypeDescription type = null;
        Node expr = this.getFirst();
        try {
            expr = expr.checkType();
            if (expr == null) {
                throw new UndefinedVariableException(this.getFirst());
            }
            type = expr.getTypeDescription();
            if (expr instanceof TypeSpec) {
                expr = new DefaultConst(this.getFirst(), type).checkType();
            }
        }
        catch (TypeException e) {
            if (e instanceof UndefinedVariableException || e instanceof MemberReferenceException) {
                block14: {
                    Node first = this.getFirst();
                    try {
                        type = TypeSpec.findType(first);
                    }
                    catch (NoSuchComponentException nsc) {
                        if (!this.getCurrentLanguage().isFuego1() || !(first instanceof Deref)) break block14;
                        first = new Identifier(oracle.bpm.util.Identifier.capitalize(first.getTypeText()));
                        first.setParent(this);
                        type = TypeSpec.findType(first);
                    }
                }
                if (type == null) {
                    throw e;
                }
                if (!type.hasDefaultInit()) {
                    throw NotInstantiableException.noDefaultInit(this.getFirst());
                }
                expr = new DefaultConst(this.getFirst(), type).checkType();
            }
            throw e;
        }
        if (!Modifier.isException(type.getModifiers())) {
            this.reportError(new NotThrowableException(this.getFirst(), type));
        }
        if (throwableType == null) {
            try {
                throwableType = this.findType("Java.Lang.Throwable");
            }
            catch (TypeException e) {
                this.reportError(e);
            }
        }
        this.userDefined = !throwableType.isAssignableFrom(type);
        this.setOperand(expr);
        return this;
    }

    @Override
    void generate(CodeGenerator codeGenerator) throws CodeGenerationException {
        codeGenerator.generate(this);
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        Throwable exception;
        Node expr = this.getFirst();
        if (!this.userDefined) {
            exception = (Throwable)expr.notNullValue(rm);
        } else {
            TypeDescription exceptionType = expr.getTypeDescription();
            FuegoCompiler compiler = this.getCompiler();
            ObjectClass classForType = ObjectClass.getOrCreate(compiler, exceptionType);
            Object obj = classForType != null ? compiler.createInvokeable(exceptionType.asObject(), null) : expr.notNullValue(rm);
            exception = new RuntimeCILExecutionException(obj);
            exception.fillInStackTrace();
        }
        rm.exceptionEvent(new CompilerExceptionShell((Node)this, exception));
        return null;
    }
}

