/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.compiler.CompilerException;
import oracle.bpm.compiler.TemplateSpec;
import oracle.bpm.type.SourceCode;

public class TemplateLibrary {
    private Map<String, TemplateSpec> templates = new HashMap<String, TemplateSpec>();
    private static TemplateLibrary instance;

    public static TemplateLibrary get() {
        if (instance == null) {
            instance = new TemplateLibrary();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplateSpec findById(String id) throws CompilerException {
        TemplateSpec result;
        Map<String, TemplateSpec> map = this.templates;
        synchronized (map) {
            result = this.templates.get(id);
            if (result == null) {
                result = this.loadTemplate(id);
                this.addTemplateSpec(id, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTemplateSpec(String id, TemplateSpec spec) {
        Map<String, TemplateSpec> map = this.templates;
        synchronized (map) {
            this.templates.put(id, spec);
        }
    }

    private TemplateSpec loadTemplate(String id) throws CompilerException {
        InputStream resource = null;
        try {
            int length;
            resource = this.getClass().getResourceAsStream("templates/" + id + ".template");
            InputStreamReader reader = new InputStreamReader(resource);
            StringBuilder builder = new StringBuilder();
            char[] buffer = new char[512];
            while ((length = reader.read(buffer)) > 0) {
                builder.append(buffer, 0, length);
            }
            SourceCode code = SourceCode.create(builder.toString(), "Fuego");
            TemplateSpec templateSpec = TemplateSpec.create(code);
            return templateSpec;
        }
        catch (IOException e) {
            throw new CompilerException(null);
        }
        finally {
            try {
                if (resource != null) {
                    resource.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

