/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.bcgen.FieldD;
import fuego.bcgen.TD;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.ArgumentMap;
import oracle.bpm.lang.ArgumentMapUtil;
import oracle.bpm.lang.Bool;
import oracle.bpm.lang.Char;
import oracle.bpm.lang.Decimal;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.lang.Int;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Invocator;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.Real;
import oracle.bpm.lang.RegExp;
import oracle.bpm.lang.RuntimeCILExecutionException;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.sql.SQLObject;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;

public class TDKit {
    static final FieldD DECIMAL_ZERO = FieldD.create(Decimal.class, "ZERO");
    public static final ObjectType INVOKEABLE = TD.getObjectType(Invokeable.class);
    public static final ObjectType INVOCATOR = TD.getObjectType(Invocator.class);
    public static final ObjectType SQL_OBJECT = TD.getObjectType(SQLObject.class);
    static final ObjectType FUEGO_CHAR = TD.getObjectType(Char.class);
    static final ObjectType FUEGO_BOOL = TD.getObjectType(Bool.class);
    static final ObjectType FUEGO_DECIMAL = TD.getObjectType(Decimal.class);
    static final ObjectType FUEGO_INT = TD.getObjectType(Int.class);
    static final ObjectType FUEGO_REAL = TD.getObjectType(Real.class);
    static final ObjectType INTERVAL = TD.getObjectType(Interval.class);
    static final ObjectType TIME = TD.getObjectType(Time.class);
    static final ObjectType STR = TD.getObjectType(Str.class);
    static final ObjectType REGEXP = TD.getObjectType(RegExp.class);
    static final ObjectType JAVACLASS = TD.getObjectType(JavaClass.class);
    static final ObjectType ANY = TD.getObjectType(Any.class);
    static final ObjectType CONVERSION = TD.getObjectType(oracle.bpm.util.Conversion.class);
    static final ObjectType ARGUMENT_MAP_UTIL = TD.getObjectType(ArgumentMapUtil.class);
    static final ObjectType ARGUMENT_MAP = TD.getObjectType(ArgumentMap.class);
    static final ObjectType RUNTIME_CIL_EXCECUTION_EXCEPTION = TD.getObjectType(RuntimeCILExecutionException.class);
    static final ObjectType DYNAMIC = TD.getObjectType(DynamicObject.class);

    static Type getType(TypeDescription type, String externalType) {
        Type result;
        if (type.isArray() && type.isPrimitive()) {
            String t = externalType == null ? null : externalType.substring(0, externalType.length() - 2);
            result = TD.getArrayType(TDKit.getType(type.getElementType(), t));
        } else {
            result = TD.valueOf(Conversion.getJavaType(type, externalType));
        }
        return result;
    }

    static ObjectType utility(TypeDescription typeDescription) {
        ObjectType result;
        if (typeDescription.isInt()) {
            result = FUEGO_INT;
        } else if (typeDescription.isReal()) {
            result = FUEGO_REAL;
        } else if (typeDescription.isDecimal()) {
            result = FUEGO_DECIMAL;
        } else if (typeDescription.isInterval()) {
            result = INTERVAL;
        } else if (typeDescription.isTime()) {
            result = TIME;
        } else if (typeDescription.isBool()) {
            result = FUEGO_BOOL;
        } else {
            throw new IllegalArgumentException("Not utility class for: " + typeDescription);
        }
        return result;
    }

    static FieldD valueField(Type type) {
        assert (type instanceof ObjectType);
        String className = ((ObjectType)type).getClassName();
        try {
            return FieldD.create(Class.forName(className), "value");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

