/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import java.util.List;
import java.util.Set;
import oracle.bpm.compiler.Assignment;
import oracle.bpm.compiler.Block;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.CollectionPool;
import oracle.bpm.compiler.Diadic;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.FlowContext;
import oracle.bpm.compiler.FlowException;
import oracle.bpm.compiler.LocalVar;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.SwitchCases;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;

public class Switch
extends Node {
    private static final String SWITCH_EXPR = "switchExpr";

    public Switch(Token t) {
        super(t);
    }

    Switch() {
    }

    @Override
    public String getText() {
        return "switch";
    }

    @Override
    public void generate(SourceGenerator cw) {
        Node cond = this.getOp1();
        if (this.getKind() != -1) {
            cond = cond.getOp2();
        }
        cw.generate(this, cond, this.getOp2());
    }

    @Override
    protected String getStatementSeparator() {
        return "\n";
    }

    @Override
    protected boolean splitToPrint() {
        return true;
    }

    @Override
    FlowContext checkFlow(FlowContext context) throws FlowException {
        FlowContext split;
        Node assign = this.getFirst();
        assign.checkFlow(context);
        List<FlowContext> contexts = CollectionPool.getArrayList();
        boolean hasDefault = false;
        for (Node current = assign.getNext(); current != null; current = current.getNext()) {
            split = context.split();
            contexts.add(split);
            current.checkFlow(split);
            hasDefault |= current instanceof Default;
        }
        if (!hasDefault) {
            split = context.split();
            split.breaksFlow(false);
            contexts.add(split);
        }
        context.join(contexts.toArray(new FlowContext[contexts.size()]));
        context.breaksFlow(false);
        CollectionPool.releaseArrayList(contexts);
        return context;
    }

    @Override
    Node checkType() throws TypeException {
        if (this.getKind() != -1) {
            return this;
        }
        Node expr = this.getFirst();
        Case current = (Case)expr.getNext();
        expr = expr.checkType();
        TypeDescription exprType = expr.getTypeDescription();
        LocalVar tmp = LocalVar.create(SWITCH_EXPR, exprType, this);
        Assignment assign = new Assignment(tmp, expr);
        assign.setNext(current);
        Set<String> cases = CollectionPool.getHashSet();
        while (current != null) {
            current.checkType(exprType, tmp, cases);
            current = (Case)current.getNext();
        }
        this.setFirst(assign);
        this.setTypeDescription(TypeFactory.getVoid());
        return this;
    }

    @Override
    void generate(CodeGenerator cg) throws CodeGenerationException {
        cg.generate(this);
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        Boolean match;
        Node assign = this.getFirst();
        assign.run(rm);
        for (Case current = (Case)assign.getNext(); current != null && !Boolean.TRUE.equals(match = (Boolean)current.run(rm)); current = (Case)current.getNext()) {
        }
        return null;
    }

    public static class Default
    extends Case {
        public Default(Token t) {
            super(t);
        }

        Default() {
        }

        @Override
        public String getText() {
            return "default";
        }

        @Override
        public void generate(SourceGenerator cw) {
            cw.generate(this, this.getOp1());
        }

        Node checkType(TypeDescription exprType, LocalVar expr, Set cases) throws TypeException {
            if (this.getKind() != -1) {
                return this;
            }
            Node op1 = this.getOp1();
            if (op1 instanceof Block) {
                Block block = (Block)op1;
                op1 = block.checkType(false);
            } else {
                op1 = op1.checkType();
            }
            this.setOperand(op1);
            this.setTypeDescription(TypeFactory.getVoid());
            return this;
        }

        Object run(RunningMonitor rm, Object expr) throws ExecutionException {
            this.getOp1().run(rm);
            return Boolean.TRUE;
        }
    }

    public static class Case
    extends Diadic {
        static final long serialVersionUID = -962055590874344826L;
        static final long serialCheck = 908782393183563339L;

        public Case(Token t) {
            super(t);
        }

        Case() {
        }

        @Override
        public String getText() {
            return "case";
        }

        @Override
        public void generate(SourceGenerator cw) {
            cw.generate(this, this.getOp1(), this.getOp2());
        }

        Node checkType(TypeDescription exprType, LocalVar expr, Set<String> set) throws TypeException {
            if (this.getKind() != -1) {
                return this;
            }
            SwitchCases cases = (SwitchCases)this.getOp1();
            Block block = (Block)this.getOp2();
            cases.checkType(expr, exprType, set);
            block.checkType(false);
            this.setOperands(cases, block);
            this.setTypeDescription(cases.getTypeDescription());
            return this;
        }

        @Override
        Object run(RunningMonitor rm) throws ExecutionException {
            Node cond = this.getOp1();
            Boolean match = (Boolean)cond.run(rm);
            if (match != null && match.booleanValue()) {
                this.getOp2().run(rm);
            }
            return match;
        }
    }
}

