/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.compiler.ValueReference;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;

public class StackFrame {
    private TypeDescription component;
    private int line;
    private MethodTypeDescription method;
    private List<StackVariable> variables = new ArrayList<StackVariable>();

    public StackFrame(TypeDescription component, MethodTypeDescription method) {
        this(component, method, -1);
    }

    public StackFrame(TypeDescription component, MethodTypeDescription method, int line) {
        this.component = component;
        this.method = method;
        this.line = line;
    }

    public TypeDescription getComponent() {
        return this.component;
    }

    public String getComponentName() {
        return this.component.getName();
    }

    public int getLine() {
        return this.line;
    }

    public MethodTypeDescription getMethod() {
        return this.method;
    }

    public String getMethodName() {
        return this.method.getName();
    }

    public String toString() {
        return "" + this.component + "." + this.method + (this.line != -1 ? "(line " + this.line + ")" : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushVariable(String name, TypeDescription type, Object value) {
        List<StackVariable> list = this.variables;
        synchronized (list) {
            this.variables.add(new StackVariable(name, type, value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popVariable(String name) {
        List<StackVariable> list = this.variables;
        synchronized (list) {
            int size = this.variables.size();
            for (int i = size - 1; i >= 0; --i) {
                StackVariable var = this.variables.get(i);
                if (!var.getName().equals(name)) continue;
                this.variables.remove(i);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StackVariable> getVariables() {
        List<StackVariable> list = this.variables;
        synchronized (list) {
            return new ArrayList<StackVariable>(this.variables);
        }
    }

    void updateLine(int line) {
        this.line = line;
    }

    public static class StackVariable {
        private String name;
        private TypeDescription type;
        private Object value;

        public StackVariable(String name, TypeDescription type, Object value) {
            this.name = name;
            this.type = type;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public TypeDescription getType() {
            return this.type;
        }

        public void setType(TypeDescription type) {
            this.type = type;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(ValueReference value) {
            this.value = value;
        }
    }
}

