/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.cil.CilException;
import oracle.bpm.compiler.CompiledTemplate;
import oracle.bpm.compiler.CompilerException;
import oracle.bpm.compiler.Completion;
import oracle.bpm.compiler.CompletionResult;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.compiler.InvalidLanguageException;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.Parameter;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TemplateFactory;
import oracle.bpm.compiler.TemplateParameter;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import org.jetbrains.annotations.NonNls;

public class SourceTemplate {
    private boolean addToPopup;
    private String description;
    private String group;
    private String id;
    private Node tree;

    public SourceTemplate(Node tree) {
        this(tree, null, null);
    }

    public SourceTemplate(Node tree, @NonNls String id, @NonNls String description) {
        this.id = id;
        this.description = description;
        this.tree = tree;
        this.addToPopup = true;
    }

    public void setAddToPopup(boolean addToPopup) {
        this.addToPopup = addToPopup;
    }

    public boolean isAddToPopup() {
        return this.addToPopup;
    }

    public String getDescription() {
        return this.description;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getGroup() {
        return this.group;
    }

    public String getId() {
        return this.id;
    }

    public CompiledTemplate compile(FuegoCompiler compiler, MethodTypeDescription targetMethod, int offset) {
        ArrayList<Node> parameters = new ArrayList<Node>();
        try {
            String language = targetMethod.getCodeLanguage();
            LanguageSpec langSpec = LanguageSpec.getLanguageSpec(language);
            SourceGenerator generator = langSpec.createSourceGenerator();
            StringWriter out = new StringWriter();
            generator.setOptions("m");
            generator.setWriter(out);
            this.tree.generate(generator);
            generator.close();
            this.collectTemplateParameters(this.tree, parameters, offset);
            return new CompiledTemplate(out.toString(), parameters);
        }
        catch (InvalidLanguageException e) {
            return new CompiledTemplate("", parameters);
        }
    }

    private void collectTemplateParameters(Node tree, List<Node> parameters, int startOffset) {
        if (tree instanceof Parameter) {
            TemplateParameter parameter = (TemplateParameter)((Object)tree);
            if (startOffset != -1) {
                parameter.setPasteOffset(parameter.getPasteOffset() + startOffset);
            }
            parameters.add(tree);
        }
        for (Node current = tree.getFirst(); current != null; current = current.getNext()) {
            this.collectTemplateParameters(current, parameters, startOffset);
        }
    }

    static class MemberSourceTemplate
    extends SourceTemplate {
        MethodTypeDescription member;

        public MemberSourceTemplate(MethodTypeDescription member) {
            super(null);
            this.member = member;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CompiledTemplate compile(FuegoCompiler compiler, MethodTypeDescription targetMethod, int offset) {
            try {
                TypeDescription parent = targetMethod.getParent();
                compiler.addObjectClass(parent.asObject());
                CompletionResult result = compiler.complete(targetMethod, offset);
                Completion completion = null;
                if (result != null) {
                    completion = result.getCompletion();
                }
                ((SourceTemplate)this).tree = TemplateFactory.createMemberTemplate(completion, null, this.member);
                CompiledTemplate compiledTemplate = super.compile(compiler, targetMethod, offset);
                return compiledTemplate;
            }
            catch (CompilerException e) {
                CompiledTemplate compiledTemplate = new CompiledTemplate("", null);
                return compiledTemplate;
            }
            catch (CilException e) {
                CompiledTemplate compiledTemplate = new CompiledTemplate("", null);
                return compiledTemplate;
            }
            finally {
                compiler.reset();
            }
        }
    }
}

