/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import fuego.parser.collections.AST;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.compiler.ArrayConst;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.CompilerExceptionShell;
import oracle.bpm.compiler.ConstantPool;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.IntConst;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.QualifiedName;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SQLNotAllowedException;
import oracle.bpm.compiler.SQLScope;
import oracle.bpm.compiler.Scope;
import oracle.bpm.compiler.SqlColumnReference;
import oracle.bpm.compiler.Tables;
import oracle.bpm.compiler.Ternary;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.TypeSpec;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.sql.SQLObject;
import oracle.bpm.sql.SQLUtils;

abstract class SQLStatement
extends Ternary {
    protected Tables tables;
    private ArrayList<Node> parameters = new ArrayList();
    private ArrayConst types;
    static final String SCHEMA = "schema";

    SQLStatement() {
        this((Token)null);
    }

    SQLStatement(Token t) {
        super(t);
    }

    public String getCode() {
        StringBuffer result = new StringBuffer();
        this.generateSQLCode(result);
        return result.toString();
    }

    public ArrayConst getTypes() {
        return this.types;
    }

    protected String getAbstractConfigName() {
        return this.tables.getAbstractConfigName();
    }

    @Override
    protected boolean splitToPrint() {
        return true;
    }

    static Node checkColumns(Node node) throws TypeException {
        Node previous = null;
        Node current = node.getFirst();
        while (current != null) {
            Node next = current.getNext();
            if (current instanceof Identifier || current instanceof QualifiedName) {
                current = new SqlColumnReference((AST)current);
                current.setParent(node);
                current.setScope(node.getScope());
            }
            current = current instanceof SqlColumnReference ? ((SqlColumnReference)current).checkType(true) : current.checkType();
            current.setNext(next);
            if (previous == null) {
                node.setFirst(current);
            } else {
                previous.setNext(current);
            }
            previous = current;
            current = next;
        }
        return node;
    }

    ArrayList<Node> getParameters() {
        return this.parameters;
    }

    String getRealConfigName() {
        return this.getCompiler().getRealConfiguration(this.getAbstractConfigName());
    }

    String getSchema() {
        TypeDescription table;
        String schema = null;
        int count = this.tables.getTablesCount();
        if (count > 0 && !Boolean.valueOf((table = this.tables.getTable(0)).asObject().getProperty("withoutSchemaName")).booleanValue()) {
            schema = table.asObject().getProperty(SCHEMA);
        }
        return schema;
    }

    @Override
    void setScope(Scope scp) {
        if (this.getScope() != null) {
            return;
        }
        Scope newscp = scp.makeSubScope(new SQLScope());
        super.setScope(newscp);
    }

    boolean isUpdate() {
        return true;
    }

    Tables checkTable(Node node) throws TypeException {
        return this.checkTables(node);
    }

    Tables checkTables(Node node) throws TypeException {
        if (!this.getCurrentMember().isRunsOnServer()) {
            this.reportError(new SQLNotAllowedException(this));
        }
        if (node instanceof TypeSpec) {
            node = new Tables(node);
        }
        this.tables = (Tables)node.checkType();
        String abstractConfigName = this.getAbstractConfigName();
        if (abstractConfigName != null && !abstractConfigName.equals("")) {
            this.checkRealConfiguration(abstractConfigName, this.getCurrentMember().getMethodType());
        }
        return this.tables;
    }

    @Override
    void collectConstants(ConstantPool cp) {
        super.collectConstants(cp);
        if (this.types != null) {
            this.types.collectConstants(cp);
        }
        if (this.parameters != null) {
            for (Node param : this.parameters) {
                param.collectConstants(cp);
            }
        }
    }

    void collectParameters(Node source) throws TypeException {
        if (source == null) {
            return;
        }
        assert (source.getKind() != -1) : "Cannot collect parameters. Node is not compiled: " + source.dump();
        Node first = null;
        Node last = null;
        List<Node> list = new ArrayList<Node>();
        list = source.collectParameters(list);
        for (Node param : list) {
            this.parameters.add(Conversion.promoteParameter(param));
            if (first == null) {
                last = first = this.sqltype(param);
                continue;
            }
            last.setNext(this.sqltype(param));
            last = last.getNext();
        }
        if (first != null) {
            if (this.types != null) {
                this.types.getFirst().getLast().setNext(first);
            } else {
                this.types = new ArrayConst(this.getScope(), first, true);
            }
            this.types = (ArrayConst)this.types.checkType();
            this.types.setMustClone(false);
            this.types.setPrimitive(true);
            this.types.setElementsPrimitive(true);
        }
    }

    @Override
    void generate(CodeGenerator codeGenerator) throws CodeGenerationException {
        codeGenerator.generate(this);
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        SQLScope sqlscope;
        Object[] args = null;
        StringBuffer sql = new StringBuffer();
        this.generateSQLCode(sql);
        Scope scp = this.getScope();
        boolean issqlscp = scp.isSQLScope();
        SQLScope sQLScope = sqlscope = scp instanceof SQLScope ? (SQLScope)scp : null;
        if (sqlscope != null) {
            sqlscope.setSQLScopeEnabled(false);
        }
        if (this.parameters != null && this.parameters.size() > 0) {
            ArrayList<Object> argsList = new ArrayList<Object>();
            for (Node param : this.parameters) {
                argsList.add(param.value(rm));
            }
            args = argsList.toArray();
        }
        if (sqlscope != null) {
            sqlscope.setSQLScopeEnabled(issqlscp);
        }
        int[] argTypes = this.types != null ? (int[])this.types.value(rm) : null;
        String schema = null;
        int count = this.tables.getTablesCount();
        if (count > 0) {
            TypeDescription table = this.tables.getTable(0);
            schema = table.asObject().getProperty(SCHEMA);
        }
        try {
            if (this.isUpdate()) {
                SQLObject.executeUpdate(this.getRealConfigName(), schema, sql.toString(), args, argTypes);
                return null;
            }
            return SQLObject.executeQuery(this.getRealConfigName(), schema, sql.toString(), args, argTypes);
        }
        catch (Exception e) {
            throw new CompilerExceptionShell((Node)this, (Throwable)e);
        }
    }

    private Node sqltype(Node param) {
        assert (param.getKind() != 0) : param.toString();
        int type = SQLUtils.getSQLType(param.getKind());
        return new IntConst((long)type, param);
    }
}

