/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.compiler.CollectionPool;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.Scope;
import oracle.bpm.compiler.SymbolTable;
import oracle.bpm.lang.ObjectTypeDescription;

public class SQLScope
extends Scope {
    private int count;
    private boolean enabled = true;
    private List<String> grouping;
    private List<ObjectTypeDescription> tables = new ArrayList<ObjectTypeDescription>();

    public SQLScope() {
        this(null);
    }

    public SQLScope(FuegoCompiler compiler) {
        super(compiler, new SymbolTable(null, false));
        this.grouping = CollectionPool.getArrayList();
    }

    @Override
    public SymbolTable getSymbolTable() {
        if (!this.enabled) {
            return super.getSymbolTable().getDefaultTable();
        }
        return super.getSymbolTable();
    }

    void setColumnCount(int count) {
        this.count = count;
    }

    int getColumnCount() {
        return this.count;
    }

    @Override
    boolean isSQLScope() {
        return this.enabled;
    }

    void setSQLScopeEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    List<ObjectTypeDescription> getTables() {
        if (this.getSuperScope() instanceof SQLScope) {
            List<ObjectTypeDescription> tables = ((SQLScope)this.getSuperScope()).getTables();
            ArrayList<ObjectTypeDescription> all = new ArrayList<ObjectTypeDescription>(this.tables);
            all.addAll(tables);
            return all;
        }
        return this.tables;
    }

    void addGroupingColumn(String column) {
        this.grouping.add(column);
    }

    void addTable(ObjectTypeDescription table) {
        this.tables.add(table);
    }

    ObjectTypeDescription findTable(Node object) {
        String text = object.getText();
        ObjectTypeDescription tableType = null;
        List<ObjectTypeDescription> tables = this.getTables();
        int length = tables.size();
        for (int i = 0; i < length; ++i) {
            ObjectTypeDescription ttype = tables.get(i);
            if (!ttype.getName().equalsIgnoreCase(text)) continue;
            tableType = ttype;
            break;
        }
        return tableType;
    }

    boolean hasGroupingColumns() {
        return this.grouping.size() != 0;
    }
}

