/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import oracle.bpm.cil.CilException;
import oracle.bpm.cil.MessageListener;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.oparser.Option;
import oracle.bpm.oparser.OptionParser;
import oracle.bpm.type.SourceCode;

public class RunCil
extends OptionParser
implements MessageListener {
    private StringList arguments;
    private final Option<String> languaje = this.addOption('l', "language", "Source language");
    private BufferedReader source;
    private final Option<Boolean> verbose = this.addOption('v', "verbose", "Show messages", false);
    private final Option<Boolean> warning = this.addOption('w', "warning", "Show warnings", false);

    public RunCil(String[] args) {
        super(args);
        this.arguments = this.parse();
    }

    public static void main(String[] args) {
        try {
            RunCil runner = new RunCil(args);
            if (runner.checkInput()) {
                runner.run();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    @Override
    public String getAppName() {
        return "cil";
    }

    @Override
    public void reportError(CilException exception) {
        this.report("Error: ", exception);
    }

    @Override
    public void reportWarning(CilException exception) {
        if (this.warning.getValue().booleanValue()) {
            this.report("Warning: ", exception);
        }
    }

    public ObjectTypeDescription createMain(SourceCode sourceCode) {
        ObjectTypeDescription target = new ObjectTypeDescription("Main");
        MethodTypeDescription method = MethodTypeDescription.createMain();
        method.setCode(sourceCode);
        target.addMember(method);
        return target;
    }

    private boolean checkInput() {
        boolean result = false;
        if (this.arguments.isEmpty()) {
            this.printHelp();
        } else {
            try {
                this.source = new BufferedReader(new FileReader((String)this.arguments.get(0)));
                this.arguments.remove(0);
                result = true;
            }
            catch (FileNotFoundException e) {
                System.err.println("Can't open: " + (String)this.arguments.get(0));
            }
        }
        return result;
    }

    private void run() throws CilException {
        SourceCode sourceCode = this.loadSourceCode();
        ObjectTypeDescription main = this.createMain(sourceCode);
        FuegoCompiler compiler = this.createCompiler();
        compiler.addObjectClass(main);
        compiler.compile();
    }

    private FuegoCompiler createCompiler() {
        FuegoCompiler compiler = new FuegoCompiler();
        if (this.verbose.getValue().booleanValue()) {
            compiler.setDirective(512);
        }
        compiler.setMessageListener(this);
        return compiler;
    }

    private void report(String type, CilException exception) {
    }

    private SourceCode loadSourceCode() {
        CharArrayWriter buffer = new CharArrayWriter();
        try {
            String line = this.source.readLine();
            if (line != null) {
                String csq = line.startsWith("#!") ? "\n" : line;
                buffer.write(csq, 0, csq.length());
            }
            while ((line = this.source.readLine()) != null) {
                buffer.write(line, 0, line.length());
            }
        }
        catch (IOException e) {
            System.err.print(e);
            System.exit(2);
        }
        return SourceCode.create(buffer.toCharArray(), this.languaje.getValue());
    }
}

