/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.ConstGenerator;
import oracle.bpm.compiler.InvalidNumberException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.filter.Operation;

public final class RealConst
extends Const {
    double value;
    static final long serialVersionUID = 2593342722329274823L;
    static final long serialCheck = 8360751196530708984L;

    public RealConst(Token t) {
        this(t, t.getText(), TypeFactory.getNone());
    }

    RealConst(String txt) {
        this(null, txt, TypeFactory.getNone());
    }

    RealConst(String txt, TypeDescription expectedType) {
        this(null, txt, expectedType);
    }

    private RealConst(Token t, String txt, TypeDescription expectedType) {
        super(t, expectedType);
        try {
            this.value = txt.equals("") ? 0.0 : Double.valueOf(txt);
            this.setTypeDescription(this.typeForValue(this.value));
            this.setPrimitive(this.getTypeDescription().isPrimitive());
            this.checkRange(expectedType, txt);
            if (Double.isInfinite(this.value)) {
                this.exception = new InvalidNumberException((Node)this, txt);
            }
        }
        catch (NumberFormatException e) {
            this.value = 0.0;
            this.exception = new InvalidNumberException((Node)this, txt);
        }
    }

    public static Number createValue(double value, TypeDescription type) {
        Number result = type.getLength() == 32 ? (Number)Float.valueOf((float)value) : (Number)value;
        return result;
    }

    @Override
    public Object getPrimitiveValue() {
        return this.isPrimitive() ? (Number)RealConst.createValue(this.value, this.getTypeDescription()) : (Number)null;
    }

    @Override
    public String getSyntheticName() {
        return RealConst.createSyntheticNameFromType(this.getTypeDescription(), String.valueOf(this.value));
    }

    @Override
    public String getText() {
        return Double.toString(this.value);
    }

    @Override
    public Node negate() {
        this.value = -this.value;
        return this;
    }

    @Override
    public void generate(ConstGenerator cg) {
        cg.generate(this);
    }

    @Override
    public String toString() {
        return super.toString() + (this.getTypeDescription().isPrimitive() ? this.getText() : "{" + this.getText() + "}");
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    @Override
    boolean isCollectable() {
        return !this.getTypeDescription().isPrimitive();
    }

    @Override
    Const compute(int op, Node bNode) {
        double b = ((RealConst)bNode).value;
        switch (op) {
            case 0: {
                this.value += b;
                break;
            }
            case 1: {
                this.value -= b;
                break;
            }
            case 2: {
                this.value *= b;
                break;
            }
            case 3: {
                this.value /= b;
                break;
            }
            case 4: {
                this.value %= b;
            }
        }
        return this;
    }

    boolean equals(Node b) {
        return b instanceof RealConst ? this.value == ((RealConst)b).value : false;
    }

    @Override
    Operation getOperationTree() {
        if (this.isParameter()) {
            return new Operation(0, "?", null);
        }
        return new Operation(22, null, null, this.getText());
    }

    @Override
    int compare(Node bNode) {
        double b = ((RealConst)bNode).value;
        return this.value < b ? -1 : (this.value > b ? 1 : 0);
    }

    @Override
    void generateSQLCode(StringBuffer query) {
        query.append(this.isParameter() ? " ? " : this.getText());
    }

    @Override
    Object run(RunningMonitor rm) {
        return RealConst.createValue(this.value, this.getTypeDescription());
    }

    TypeDescription typeForValue(double value) {
        return value >= 3.4028234663852886E38 ? TypeFactory.getPrimitiveReal(64) : TypeFactory.getPrimitiveReal(32);
    }

    private void checkRange(TypeDescription expectedType, String txt) {
        if (expectedType.getKind() != -1) {
            if (this.getTypeDescription().getLength() > expectedType.getLength()) {
                this.value = 0.0;
                this.exception = new InvalidNumberException(this, txt, expectedType);
            }
            this.setTypeDescription(expectedType);
        }
    }
}

