/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import fuego.parser.collections.AST;
import oracle.bpm.compiler.IntConst;
import oracle.bpm.compiler.InvalidColumnException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NodeIterator;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.SqlColumnReference;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.type.TypeFactory;

public class OrderBy
extends Node {
    static final long serialVersionUID = 3422789429230299937L;
    static final long serialCheck = 1101412435486424548L;

    public OrderBy(Token t) {
        super(t);
    }

    OrderBy() {
    }

    @Override
    public String getText() {
        return "order-by";
    }

    @Override
    public void generate(SourceGenerator cw) {
        cw.generate(this);
    }

    @Override
    Node checkType() throws TypeException {
        this.getScope().setOnlyLocal(true);
        NodeIterator cols = this.getChildren();
        while (cols.hasNext()) {
            cols.next().checkType();
        }
        this.getScope().setOnlyLocal(false);
        return this;
    }

    @Override
    void generateSQLCode(StringBuffer sql) {
        sql.append(" ORDER BY ");
        this.generateCommaDelimitedSQL(this.getFirst(), sql);
    }

    public static class DescCol
    extends Col {
        static final long serialVersionUID = -5640510932232567415L;
        static final long serialCheck = 65671303308196471L;

        public DescCol(Token t) {
            super(t, true);
        }
    }

    public static class Col
    extends SqlColumnReference {
        boolean desc;
        static final long serialVersionUID = 2781449312554282669L;
        static final long serialCheck = 114514344110461401L;

        public Col(Token t) {
            this(t, false);
        }

        public Col(AST ast) {
            super(ast);
        }

        Col() {
            this(null, false);
        }

        Col(Token t, boolean desc) {
            super(t);
            this.desc = desc;
        }

        @Override
        public String getText() {
            return this.desc ? "desc" : "asc";
        }

        @Override
        Node checkType() throws TypeException {
            Node op = this.getFirst();
            if (op instanceof IntConst) {
                long value = ((IntConst)op).value;
                if (value < 1L || value > (long)this.getSQLScope().getColumnCount()) {
                    throw new InvalidColumnException(this.getFirst());
                }
            } else {
                super.checkType(true);
            }
            this.setTypeDescription(TypeFactory.getVoid());
            return this;
        }

        @Override
        void generateSQLCode(StringBuffer sql) {
            sql.append(" ");
            Node op = this.getFirst();
            if (op.isConstant()) {
                op.generateSQLCode(sql);
            } else {
                super.generateSQLCode(sql);
            }
            sql.append(this.desc ? " DESC " : "");
        }
    }
}

