/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.Diadic;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NonNumericException;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.Kind;
import oracle.bpm.lang.TypeDescription;

final class NumDiadic {
    NumDiadic() {
    }

    static Diadic promote(Diadic node) throws TypeException {
        Node o1 = node.getOp1();
        Node o2 = node.getOp2();
        int k1 = o1.getKind();
        int k2 = o2.getKind();
        if (!Kind.isNumber(k1)) {
            throw new NonNumericException(o1);
        }
        if (!Kind.isNumber(k2)) {
            throw new NonNumericException(o2);
        }
        TypeDescription t1 = o1.getTypeDescription();
        TypeDescription t2 = o2.getTypeDescription();
        TypeDescription p = t1.promote(t2);
        p = p.primitiveEquivalent(true);
        o1 = Conversion.promote(o1, p);
        o2 = Conversion.promote(o2, p);
        node.setOperands(o1, o2);
        return node;
    }
}

