/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.bcgen.TD;
import fuego.parser.CommonHiddenStreamToken;
import fuego.parser.FuegoToken;
import fuego.parser.Token;
import fuego.parser.collections.AST;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.bpm.cil.CilException;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.compiler.AmbiguousComponentNameException;
import oracle.bpm.compiler.BaseObjectClass;
import oracle.bpm.compiler.Block;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.CodeStyle;
import oracle.bpm.compiler.CompilerException;
import oracle.bpm.compiler.CompilerExceptionShell;
import oracle.bpm.compiler.CompilerParserException;
import oracle.bpm.compiler.CompletionException;
import oracle.bpm.compiler.ConstantPool;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.DoBlock;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.ExtractedMethod;
import oracle.bpm.compiler.FlowContext;
import oracle.bpm.compiler.FlowException;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.compiler.FuegoInvokeable;
import oracle.bpm.compiler.InternalException;
import oracle.bpm.compiler.InvalidLanguageException;
import oracle.bpm.compiler.InvalidNode;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.compiler.MemberReferenceException;
import oracle.bpm.compiler.Method;
import oracle.bpm.compiler.MissingConfigurationException;
import oracle.bpm.compiler.NoSuchComponentException;
import oracle.bpm.compiler.NodeIterator;
import oracle.bpm.compiler.NullReferenceException;
import oracle.bpm.compiler.ObjectClass;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SQLScope;
import oracle.bpm.compiler.Scope;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.SourceWriter;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.SymbolTable;
import oracle.bpm.compiler.Template;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.ValueReference;
import oracle.bpm.compiler.Watch;
import oracle.bpm.lang.Int;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.sql.ColumnReference;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.SourceCode;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeFinder;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.filter.Operation;
import oracle.bpm.util.ASTNode;
import oracle.bpm.util.ObjectWatch;
import org.apache.bcel.generic.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Node
extends ASTNode
implements Cloneable {
    protected Scope scope = null;
    private Method currentMember;
    private boolean evaluateWatches;
    private short flags = (short)2;
    private Node parent;
    private Node prev;
    private TypeDescription typeDescription = TypeFactory.getNone();
    private static final boolean HEAVY_ASSERTS = Boolean.getBoolean("oracle.bpm.compiler.heavyasserts");
    static final String STATEMENT_SEPARATOR = ";\n";
    public static final int PARAMETER = 1;
    public static final int PARAMETRIC = 2;
    public static final int STATEMENT = 4;
    public static final int PARENTHESIS = 8;
    public static final int SYNTHETIC = 16;
    public static final int COMMENTED = 32;
    public static final int LEFT = 64;
    public static final int MUST_CLONE = 128;
    public static final int PRIMITIVE = 256;
    public static final int FIRST_SYMBOL_USE = 512;

    public Node() {
    }

    protected Node(AST ast) {
        this();
        this.initialize(ast);
        this.setFirst((Node)ast);
        this.setNext(null);
    }

    Node(Token t) {
        this();
        if (t != null) {
            this.initialize(t);
        }
    }

    public static String show(AST node) {
        return node == null ? "(null)" : ((Node)node).show();
    }

    public static Node deepCopy(Node n) {
        if (n == null) {
            return null;
        }
        Node newNode = Node.copyWithLinks(n);
        newNode.parent = null;
        newNode.right = null;
        newNode.prev = null;
        if (!n.hasChildren()) {
            newNode.setFirst(null);
        } else {
            Node last = null;
            NodeIterator it = n.getChildren(true);
            while (it.hasNext()) {
                Node current = Node.deepCopy(it.next());
                if (last == null) {
                    newNode.setFirst(current);
                } else {
                    last.setNext(current);
                }
                last = current;
            }
        }
        return newNode;
    }

    public final void setFirstChild(AST n) {
        Node.assertNotContains(n, (AST)this);
        if (n instanceof Node) {
            Node node = (Node)n;
            node.setParent(this);
            node.prev = null;
            if (this.getLine() == 0) {
                this.copyPositionFrom(node);
            }
        }
        super.setFirstChild(n);
    }

    public final void setNextSibling(AST ast) {
        assert (ast != this);
        Node.assertNotContains(ast, (AST)this);
        super.setNextSibling(ast);
        if (ast instanceof Node) {
            Node node = (Node)ast;
            node.prev = this;
            node.setParent(null);
        }
    }

    public final void addAll(List<? extends Node> nodeList) {
        if (!nodeList.isEmpty()) {
            Node prev = this.getFirst();
            if (prev != null) {
                while (prev.getNext() != null) {
                    prev = prev.getNext();
                }
            }
            for (Node node : nodeList) {
                node.setNext(null);
                if (prev == null) {
                    this.setFirst(node);
                } else {
                    prev.setNext(node);
                }
                prev = node;
            }
        }
    }

    public final void addChild(AST ast) {
        if (ast != null) {
            Node.assertNotContains(ast, (AST)this);
            Node prev = this.getFirst();
            if (prev == null) {
                this.setFirst((Node)ast);
            } else {
                while (prev.getNext() != null) {
                    prev = prev.getNext();
                }
                prev.setNext((Node)ast);
            }
        }
    }

    public boolean isHolder() {
        Symbol symbol = this.getSymbol();
        return symbol != null && symbol.isHolder();
    }

    public Node getTargetValue() {
        return null;
    }

    public String getText() {
        return "";
    }

    public String getTypeText() {
        return null;
    }

    public void addOneChild(Node node) {
        node.setNext(null);
        this.addChild((AST)node);
    }

    public int childCount() {
        Node current = this.getFirst();
        int count = 0;
        while (current != null) {
            current = current.getNext();
            ++count;
        }
        return count;
    }

    public void complete(int completionType, Node argument) throws CompletionException {
        throw new UnsupportedOperationException();
    }

    public boolean equalsTree(Node n) {
        if (n != null && n.getClass() == this.getClass() && n.getText().equals(this.getText())) {
            Node child = this.getFirst();
            Node other = n.getFirst();
            while (child != null) {
                if (!child.equalsTree(other)) {
                    return false;
                }
                child = child.getNext();
                other = other.getNext();
            }
            return other == null;
        }
        return false;
    }

    public MethodTypeDescription findMember(TypeDescription type, String name, int kind, Node init) {
        return this.findMember(type, name, kind, init, true);
    }

    public MethodTypeDescription findMember(TypeDescription type, String name, int kind, Node init, boolean findClosest) {
        return this.findMember(type, name, kind, init, findClosest, true);
    }

    public MethodTypeDescription findMember(TypeDescription type, String name, int kind, Node init, boolean findClosest, boolean all) {
        return this.findMember(type, name, kind, init, findClosest, all, true);
    }

    public MethodTypeDescription findMember(TypeDescription type, String name, int kind, Node init, boolean findClosest, boolean all, boolean warn) {
        MethodTypeDescription member = this.findMember(type, name, TypeFinder.Scope.DEFAULT, kind);
        if (member == null) {
            ObjectClass currentType = this.getCurrentClass();
            if (currentType.getTypeDescription() == type) {
                if (all) {
                    member = this.findMember(type, name, TypeFinder.Scope.PARENT, kind);
                }
                if (member == null) {
                    member = currentType.findSyntheticMember(name);
                }
            }
            if (member == null && findClosest) {
                boolean oneResult;
                MethodTypeDescription[] members = type.findClosestMembers(name, 0, kind);
                LanguageSpec currentLanguage = this.getCurrentLanguage();
                boolean bl = currentLanguage.isFuego1() ? members.length >= 1 : (oneResult = members.length == 1);
                if (oneResult && !members[0].isConstructor()) {
                    boolean isSqlIgnorable;
                    boolean bl2 = isSqlIgnorable = members[0].getParent().isSql() && members[0].getName().equalsIgnoreCase(name);
                    if (currentLanguage.isLastVersion() && !isSqlIgnorable && warn) {
                        this.reportWarning(new MemberReferenceException(init, type, name, members[0].getName()));
                    }
                    return members[0];
                }
                if (members.length == 0 && type.isSql() && this.isNumber(name) && currentLanguage.isOldTypePrecedenceEnabled()) {
                    member = type.asObject().findAttributeByPosition(Integer.parseInt(name));
                }
            }
        }
        return member;
    }

    public MethodTypeDescription findMethod(TypeDescription type, String name, Node init) {
        return this.findMember(type, name, 14, init);
    }

    public void initialize(Node node) {
        assert (node != this);
        this.copyPositionFrom(node);
        if (node != null) {
            Node parent;
            Scope scope = node.getScope();
            if (scope != null) {
                this.setScope(scope);
            }
            if ((parent = node.getParent()) != null && parent != this) {
                this.setParent(parent);
            }
        }
    }

    @Override
    public void initialize(Token tok) {
        super.initialize(tok);
        FuegoToken fuegoToken = (FuegoToken)tok;
        this.setOffset(fuegoToken.getOffset());
        this.setLength(fuegoToken.getLength());
    }

    @Override
    public final void initialize(int t, String txt) {
    }

    public Node negate() throws TypeException {
        return this;
    }

    public void reportError(CilException error) {
        Node parent = this.getParent();
        if (parent == null) {
            assert (false) : "Could not propagate " + error + " to parent of " + this + " (" + this.getClassName() + ")";
        } else {
            if (error.getLine() <= 0) {
                error.setLine(this.getLine());
                error.setColumn(this.getColumn());
                error.setOffset(this.getOffset());
            }
            parent.reportError(error);
        }
    }

    public void reportWarning(CilException warning) {
        Node parent = this.getParent();
        if (parent == null) {
            assert (false) : "Could not propagate " + warning + " to parent of " + this + " (" + this.getClassName() + ")";
        } else {
            parent.reportWarning(warning);
        }
    }

    public String dump() {
        StringWriter writer;
        block2: {
            writer = new StringWriter();
            try {
                this.dump(writer);
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)("Unexpected exception: " + e));
            }
        }
        writer.flush();
        return writer.toString();
    }

    public void dump(Writer writer) throws IOException {
        Node.dump(this, 0, writer, false, new Int.Holder(0L));
    }

    public NodeIterator getChildren() {
        return new NodeIterator(this, this.getFirst(), false);
    }

    public final Node getFirst() {
        return (Node)this.down;
    }

    public final Node getOp1() {
        return (Node)this.down;
    }

    public final Node getOp2() {
        return (Node)this.down.right;
    }

    public LanguageSpec getCurrentLanguage() {
        Method current = this.getCurrentMember();
        return current != null ? current.getLanguageSpec() : null;
    }

    public Method getCurrentMember() {
        Node parent = this.getParent();
        return parent != null ? parent.getCurrentMember() : null;
    }

    public void setExpression(boolean expr) {
        this.setStatement(!expr);
    }

    public Node setFirst(Node node) {
        assert (node != this) : "Attempt to set 'this' as first child";
        Node.assertNotContains((AST)node, (AST)this);
        this.down = node;
        if (node != null) {
            node.setParent(this);
            node.prev = null;
        }
        return node;
    }

    public int getKind() {
        return this.getTypeDescription().getKind();
    }

    public final Node getNext() {
        return (Node)this.right;
    }

    public Node getLast() {
        Node last = this;
        while (last.getNext() != null) {
            last = last.getNext();
        }
        return last;
    }

    public Node setNext(Node n) {
        if (n == this) {
            throw new IllegalArgumentException("Attempt to set 'this' as next node");
        }
        Node.assertNotContains((AST)n, (AST)this);
        this.right = n;
        if (n != null) {
            n.prev = this;
            n.parent = null;
        }
        return n;
    }

    public Node getOp3() {
        return (Node)this.down.right.right;
    }

    public final void setOperands(Node a, Node b) {
        assert (a != this);
        assert (b != this);
        b.setNextSibling(null);
        a.setNextSibling((AST)b);
        this.setFirstChild((AST)a);
    }

    public final void setOperands(Node a, Node b, Node c) {
        if (c != null && c.getNext() != null) {
            c.setNext(null);
        }
        b.setNext(c);
        a.setNext(b);
        this.setFirst(a);
    }

    public void setParent(Node parent) {
        assert (parent != this) : "Cyclic assignment of parent for " + this.getClassName();
        Node.assertNotContains((AST)this, (AST)parent);
        assert (parent != null || this.parent == null || this.prev != null) : "Attempt to remove our parent";
        if (parent == this) {
            throw new IllegalArgumentException("Attempt to set 'this' as parent.");
        }
        this.parent = parent;
    }

    public Node getParent() {
        if (this.parent == null && this.prev != null) {
            return this.prev.getParent();
        }
        return this.parent;
    }

    public final Node getPrev() {
        return this.prev;
    }

    public void setParenthesis(boolean p) {
        this.flags = p ? (short)(this.flags | 8) : (short)(this.flags & 0xFFFFFFF7);
    }

    public void setStatement(boolean statement) {
        this.flags = statement ? (short)(this.flags | 4) : (short)(this.flags & 0xFFFFFFFB);
    }

    public boolean isStatement() {
        return (this.flags & 4) != 0;
    }

    public Symbol getSymbol() {
        return null;
    }

    public SymbolTable getSymbolTable() {
        assert (this.scope != null) : "Scope is null for node '" + this.getClassName() + "'. context: \n" + this.dumpContext();
        return this.scope.getSymbolTable();
    }

    public boolean isSynthetic() {
        return (this.flags & 0x10) != 0;
    }

    public TypeDescription getTypeDescription() {
        return this.typeDescription;
    }

    public String findFreeId(String id) {
        SymbolTable symbols = this.getSymbolTable();
        String newId = id;
        int n = 1;
        while (symbols.get(newId) != null) {
            newId = id + ++n;
        }
        return newId;
    }

    public void generate(SourceGenerator cw) {
    }

    public boolean hasChildren() {
        return this.down != null;
    }

    public Node removeFromParent() {
        Node parent = this.getParent();
        if (parent != null) {
            Node prev = null;
            for (Node current = parent.getFirst(); current != null; current = current.getNext()) {
                if (current == this) {
                    if (prev != null) {
                        prev.setNext(current.getNext());
                    } else {
                        parent.setFirst(current.getNext());
                    }
                    break;
                }
                prev = current;
            }
        } else {
            Node next = this.getNext();
            if (this.prev != null) {
                this.prev.setNext(next);
            }
            if (next != null) {
                next.prev = this.prev;
            }
        }
        this.parent = null;
        this.prev = null;
        this.setNext(null);
        assert (this.getPrev() == null) : "Prev should be null";
        assert (this.getNext() == null) : "Next should be null";
        assert (this.getParent() == null) : "Parent should be null";
        return this;
    }

    public Scope getScope() {
        return this.scope;
    }

    public boolean isExpression() {
        return !this.isStatement();
    }

    public void gen(CodeGenerator codeGenerator) throws CodeGenerationException {
        codeGenerator.emitLineNumber(this.getLine());
        try {
            this.generate(codeGenerator);
        }
        catch (CodeGenerationException e) {
            e.setNode(this);
            throw e;
        }
    }

    protected static void dump(Node node, int d, Writer out, boolean html, Int.Holder count) throws IOException {
        String text;
        ++count.value;
        if (count.value > 2000L) {
            out.write("Recursive reference ?\n");
            return;
        }
        String position = node.getLine() + ":" + node.getColumn() + "," + node.getOffset() + ":" + node.getLength();
        out.write(Str.pad(position, 12));
        String clname = node.getClassName();
        if (html) {
            clname = ObjectWatch.getDefault().getId(node);
        }
        if ((clname = Str.valueOf(' ', d * 2) + clname).length() < 30) {
            clname = Str.pad(clname, 30);
        }
        out.write(clname + ": ");
        String nodeText = node.getText();
        CommonHiddenStreamToken before = node.getHiddenBefore();
        CommonHiddenStreamToken after = node.getHiddenAfter();
        if (before != null && before.getType() != 0) {
            nodeText = "<" + before.getText() + ">" + nodeText;
        }
        if (after != null && after.getType() != 0) {
            nodeText = nodeText + "<" + after.getText() + ">";
        }
        if ((text = Str.valueOf(' ', d * 2) + "[" + nodeText + "]").length() < 30) {
            text = Str.pad(text, 30);
        }
        out.write(text + ": ");
        String type = ((Object)node.getTypeDescription()).toString();
        Node parent = node.getParent();
        String parentText = parent != null ? parent.getClassName() : "null";
        out.write(Str.valueOf(' ', d * 2) + "<" + type + ">^" + parentText + "\n");
        for (Node current = (Node)node.down; current != null; current = current.getNext()) {
            Node.dump(current, d + 1, out, html, count);
        }
    }

    protected boolean isAssignableFrom45(TypeDescription targetType, TypeDescription sourceType) {
        boolean assignableFrom = false;
        if (this.getCurrentLanguage().isFuego1()) {
            assignableFrom = sourceType.isCollection() && targetType.isObject() || sourceType.isObject() && targetType.isCollection() || sourceType.isIterator() && targetType.isObject() || sourceType.isObject() && targetType.isIterator();
        }
        return assignableFrom;
    }

    protected String getStatementSeparator() {
        return STATEMENT_SEPARATOR;
    }

    protected void afterStep(RunningMonitor rm) throws ExecutionException {
        if (!rm.isEvaluateWatchesEnabled()) {
            return;
        }
        this.evaluateWatches(rm.getWatches(), rm);
    }

    protected void checkRealConfiguration(String abstractConfigName, TypeDescription type) throws MissingConfigurationException {
        String configuration = this.getCompiler().getRealConfiguration(abstractConfigName);
        if (configuration == null) {
            MissingConfigurationException exception = new MissingConfigurationException(this, abstractConfigName, type);
            this.reportError(exception);
        }
    }

    protected String dump(String description) {
        String out = "\n======================================== " + description + " ========================================\n";
        out = out + "hashCode: " + this.hashCode() + "\n";
        out = out + this.dump();
        out = out + "\n==============================================================================================";
        return out;
    }

    protected TypeDescription getDeclarationFor(Node child) {
        Node parent = this.getParent();
        return parent != null ? parent.getDeclarationFor(this) : null;
    }

    protected TypeDescription findType(String component) throws TypeException {
        return this.findType(component, true);
    }

    protected TypeDescription findType(String component, boolean failIfNotFound) throws TypeException {
        TypeDescription result;
        assert (!component.equals("")) : "Attempt to find empty component name. Context: \n" + this.dumpContext();
        ComponentCatalog catalog = this.getCatalog();
        ObjectClass cl = this.getCurrentClass();
        try {
            boolean isModule;
            TypeRef type = catalog.find(component, cl != null ? cl.getTypeDescription() : null);
            if (type == null && failIfNotFound) {
                throw new NoSuchComponentException(this, component);
            }
            result = type != null ? type.get() : null;
            boolean bl = isModule = result != null && result.isModule();
            if (isModule && this.getCurrentLanguage().isOldTypePrecedenceEnabled()) {
                result = Node.findNoModule(component, catalog);
            }
        }
        catch (AmbiguousTypeNameException e) {
            result = Node.handleAmbiguousType(e, this);
        }
        if (result != null && cl != null) {
            cl.getObjectType().declareDependency(result);
        }
        return result;
    }

    protected Object notNull(Object value, TypeDescription expectedType, RunningMonitor rm) throws ExecutionException {
        Symbol symbol = null;
        if (value instanceof Symbol) {
            symbol = (Symbol)value;
            value = symbol.getValue();
        }
        if (value == null) {
            String name = null;
            if (symbol != null) {
                name = symbol.getName();
                expectedType = symbol.getType();
            }
            if (expectedType != null) {
                ValueReference ref = new ValueReference(value, expectedType, name);
                rm.exceptionEvent(new NullReferenceException(this, ref));
                value = ref.get();
            } else {
                rm.exceptionEvent(new NullReferenceException(this));
            }
        }
        return value;
    }

    protected Object notNullValue(RunningMonitor rm) throws ExecutionException {
        return this.notNull(this.run(rm), this.getTypeDescription(), rm);
    }

    protected Object notNullValue(TypeDescription expectedType, RunningMonitor rm) throws ExecutionException {
        return this.notNull(this.run(rm), expectedType, rm);
    }

    protected void printDump(String description) {
        System.out.println(this.dump(description));
    }

    protected ValueReference reference(Object value, TypeDescription type) {
        return this.reference(value, type, "");
    }

    protected ValueReference reference(Object value, TypeDescription type, String name) {
        return new ValueReference(value, type, name);
    }

    protected void step(RunningMonitor rm) throws ExecutionException {
        Scope scope = this.getScope();
        assert (scope != null) : this;
        if (!scope.isStepEnabled()) {
            return;
        }
        if (this.getLine() <= 0) {
            return;
        }
        rm.stepEvent(this.getLine(), this.getColumn());
    }

    static void assertNotContains(AST current, AST node) {
        assert (Node.checkNotContains((Node)current, (Node)node)) : "Cyclic reference: '" + current.getClass() + "' contains '" + node.getClass() + "'";
    }

    static boolean contains(AST current, AST node) {
        if (current == null || node == null) {
            return false;
        }
        for (AST next = current; next != null; next = next.getNextSibling()) {
            if (next == node) {
                return true;
            }
            AST child = next.getFirstChild();
            if (!Node.contains(child, node)) continue;
            return true;
        }
        return false;
    }

    static Node copy(Node n) {
        if ((n = Node.copyWithLinks(n)) != null) {
            n.dettach();
        }
        return n;
    }

    static Node copyWithLinks(Node n) {
        if (n == null) {
            return null;
        }
        try {
            return (Node)n.clone();
        }
        catch (CloneNotSupportedException exc) {
            throw new Error(exc);
        }
    }

    static TypeDescription findNoModule(String component, ComponentCatalog catalog) throws AmbiguousTypeNameException {
        TypeDescription result = null;
        if (catalog instanceof MutableComponentCatalog) {
            MutableComponentCatalog repository = (MutableComponentCatalog)catalog;
            TypeRef type = repository.findType(component, null, null, false);
            result = type != null ? type.get() : null;
        }
        return result;
    }

    static TypeDescription handleAmbiguousType(AmbiguousTypeNameException e, Node node) throws AmbiguousComponentNameException {
        AmbiguousComponentNameException e2 = new AmbiguousComponentNameException(node, e);
        LanguageSpec langSpec = node.getCurrentLanguage();
        boolean hasHiddenTypes = e.hasAnyHiddenType();
        if (!(hasHiddenTypes || langSpec != null && langSpec.isOldTypePrecedenceEnabled())) {
            throw e2;
        }
        TypeDescription result = e.getHighest45PrecedenceType();
        if (result == null) {
            throw e2;
        }
        return result;
    }

    static void validate(Node node) {
        if (node != null) {
            node.validate();
        }
    }

    Node getAutoDeclared(TypeDescription varType, boolean silent) throws TypeException {
        return this.checkType();
    }

    ComponentCatalog getCatalog() {
        return this.getCurrentClass().getCatalog();
    }

    NodeIterator getChildren(boolean copyLinks) {
        return new NodeIterator(this.getFirst(), copyLinks);
    }

    String getClassName() {
        String clname = this.getClass().getName();
        return clname.substring(clname.lastIndexOf(46) + 1);
    }

    void setColumnReference(ColumnReference ref) {
        assert (false) : "setColumnReference() Not defined for " + this.getClassName();
    }

    ColumnReference getColumnReference() {
        return null;
    }

    boolean isCommented() {
        return (this.flags & 0x20) != 0;
    }

    TypeDescription canonicalType(@Nullable TypeDescription type) {
        TypeRef ref = this.canonicalType((TypeRef)type);
        return ref == null ? null : ref.get();
    }

    TypeRef canonicalType(@Nullable TypeRef type) {
        return type == null || this.scope == null ? type : this.getCompiler().canonicalType(type);
    }

    FuegoCompiler getCompiler() {
        if (this.scope == null) {
            throw new IllegalStateException("Node without scope: " + this.getText() + "\nContext:\n" + this.dumpContext());
        }
        return this.scope.getCompiler();
    }

    boolean getCompilerDirective(int directive) {
        return this.getCompiler().getDirective(directive);
    }

    boolean isCompletion() {
        return false;
    }

    boolean isComplexExpression() {
        return true;
    }

    String getComponentName() {
        return "";
    }

    boolean isConstant() {
        return false;
    }

    boolean isConversion() {
        return false;
    }

    ObjectClass getCurrentClass() {
        ObjectClass result = null;
        if (this.scope != null) {
            SymbolTable symbols = this.scope.getSymbolTable();
            result = symbols.getCurrentClass();
        }
        if (result == null) {
            Node parent = this.getParent();
            result = parent != null ? parent.getCurrentClass() : null;
        }
        return result;
    }

    DoBlock getCurrentDoBlock() {
        Node parent = this.getParent();
        return parent != null ? parent.getCurrentDoBlock() : null;
    }

    Block getCurrentBlock() {
        Node parent = this.getParent();
        return parent != null ? parent.getCurrentBlock() : null;
    }

    TypeDescription getDeclaration() {
        Node parent = this.getParent();
        return parent != null ? parent.getDeclarationFor(this) : null;
    }

    List<CilException> getErrors() {
        return Collections.emptyList();
    }

    boolean isExternal() {
        return false;
    }

    boolean isFormat() {
        return false;
    }

    boolean isGeneratingSource() {
        return this.getCompiler().getDirective(1);
    }

    void setHolderValue(Object holder, Object value) throws ExecutionException {
        try {
            JavaClass.setHolderValue(holder, value);
        }
        catch (Exception e) {
            throw new CompilerExceptionShell(this, (Throwable)e);
        }
    }

    Object getHolderValue(Object holder) throws ExecutionException {
        try {
            return JavaClass.getHolderValue(holder);
        }
        catch (Exception e) {
            throw new CompilerExceptionShell(this, (Throwable)e);
        }
    }

    boolean isIncrement() {
        return false;
    }

    Node getIncrementedVariable() {
        return null;
    }

    int getInheritedLength() {
        int offset = this.getOffset();
        int length = this.getLength();
        for (Node parent = this.getParent(); (offset < 0 || length < 0) && parent != null; parent = parent.getParent()) {
            offset = parent.getOffset();
            length = parent.getLength();
        }
        return length;
    }

    int getInheritedOffset() {
        int offset = this.getOffset();
        for (Node parent = this.getParent(); offset < 0 && parent != null; parent = parent.getParent()) {
            offset = parent.getOffset();
        }
        return offset;
    }

    String getJavaType() {
        return this.getTypeDescription().javaType();
    }

    boolean isLazyHolder() {
        Symbol symbol = this.getSymbol();
        return symbol != null && symbol.isLazyHolder();
    }

    Node getLeftDescendant() {
        Node result = this;
        for (Node child = this.getFirst(); child != null; child = child.getNext()) {
            Node left = child.getLeftDescendant();
            if (left.isSynthetic() || left.getOffset() < 0 || left.getOffset() >= result.getOffset()) continue;
            result = left;
        }
        return result;
    }

    void setLeftValue(boolean left) {
        this.flags = left ? (short)(this.flags | 0x40) : (short)(this.flags & 0xFFFFFFBF);
    }

    boolean isLeftValue() {
        return (this.flags & 0x40) != 0;
    }

    void setMustClone(boolean clone) {
        this.flags = clone ? (short)(this.flags | 0x80) : (short)(this.flags & 0xFFFFFF7F);
    }

    ObjectTypeDescription getObjectType() {
        return this.getTypeDescription().asObject();
    }

    void setOperand(Node n) {
        n.setNext(null);
        this.setFirst(n);
    }

    void setCommented(boolean commented) {
        this.flags = commented ? (short)(this.flags | 0x20) : (short)(this.flags & 0xFFFFFFDF);
    }

    Operation getOperationTree() {
        if (this.isParameter()) {
            return new Operation(0, "?", null);
        }
        throw new UnsupportedOperationException(this.getClassName() + ".getOperationTree() not implemented");
    }

    void setParameter(boolean parameter) {
        this.flags = parameter ? (short)(this.flags | 1) : (short)(this.flags & 0xFFFFFFFE);
    }

    boolean isParameter() {
        return (this.flags & 1) != 0;
    }

    void setParametric(boolean p) {
        this.flags = p ? (short)(this.flags | 2) : (short)(this.flags & 0xFFFFFFFD);
    }

    boolean isParametric() {
        return (this.flags & 2) != 0;
    }

    void setFirstSymbolUse(boolean first) {
        this.flags = first ? (short)(this.flags | 0x200) : (short)(this.flags & 0xFFFFFDFF);
    }

    boolean isFirstSymbolUse() {
        return (this.flags & 0x200) != 0;
    }

    boolean getParenthesis() {
        return (this.flags & 8) != 0;
    }

    void setPrimitive(boolean p) {
        this.flags = p ? (short)(this.flags | 0x100) : (short)(this.flags & 0xFFFFFEFF);
    }

    boolean isPrimitive() {
        return (this.flags & 0x100) != 0;
    }

    void setRequiredParent(Node parent) {
        assert (parent != null) : "Attempt to set a null parent to '" + this.getClass() + "'. Text: " + this.getText();
        this.setParent(parent);
    }

    Node getRightDescendant() {
        Node result = this;
        for (Node child = this.getFirst(); child != null; child = child.getNext()) {
            Node right = child.getRightDescendant();
            if (right.isSynthetic() || right.getOffset() < 0 || right.getOffset() <= result.getOffset()) continue;
            result = right;
        }
        return result;
    }

    SQLScope getSQLScope() {
        return this.scope instanceof SQLScope ? (SQLScope)this.scope : null;
    }

    boolean isSQLScope() {
        return this.getScope().isSQLScope();
    }

    void setScope(Scope scp) {
        this.scope = scp;
        for (Node current = this.getFirst(); current != null; current = current.getNext()) {
            current.setScope(scp);
        }
        TypeDescription type = this.typeDescription;
        if (type != null) {
            this.setTypeDescription(type);
        }
    }

    SourceCode getSourceCode() {
        Method member = this.getCurrentMember();
        return member != null ? member.getMethodType().getCode() : null;
    }

    void setSynthetic(boolean synthetic) {
        this.flags = synthetic ? (short)(this.flags | 0x10) : (short)(this.flags & 0xFFFFFFEF);
    }

    Type getTD() {
        return TD.valueOf(this.getTypeDescription());
    }

    Symbol getThis() {
        ObjectClass currentClass = this.getCurrentClass();
        return currentClass != null ? currentClass.getSymbol() : null;
    }

    BaseObjectClass getTopLevelClass() {
        Node parent = this.getParent();
        assert (parent != null) : this.getClassName() + " doesn't have a parent: " + this;
        return parent.getTopLevelClass();
    }

    int getTreeLength() {
        Node left = this.getLeftDescendant();
        Node right = this.getRightDescendant();
        int leftOffset = left.getInheritedOffset();
        int rightOffset = right.getInheritedOffset();
        return rightOffset - leftOffset + right.getInheritedLength();
    }

    int getTreeOffset() {
        Node leftDescendant = this.getLeftDescendant();
        return leftDescendant.getInheritedOffset();
    }

    final void setTypeDescription(@NotNull TypeDescription type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/compiler/Node.setTypeDescription must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("TypeDescription is null");
        }
        this.typeDescription = this.canonicalType(type);
    }

    int getUniqueNumber() {
        Method currentMember = this.getCurrentMember();
        assert (currentMember != null) : "Cannot find 'current member' for '" + this + "'. Context: \n" + this.dumpContext();
        return currentMember.getUniqueNumber();
    }

    void setVariable(RunningMonitor rm, Object value) throws ExecutionException {
        Symbol varSymbol = (Symbol)this.run(rm);
        assert (varSymbol != null) : "Missing symbol for " + this.getClassName() + ". Context: \n" + this.dumpContext();
        if (this.isHolder()) {
            Object holder = varSymbol.getValue();
            if (holder == null) {
                String ht = varSymbol.getHolderType();
                try {
                    holder = JavaClass.forName(ht).newInstance();
                    varSymbol.setValue(holder);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.setHolderValue(holder, value);
        } else {
            varSymbol.setValue(value);
        }
    }

    List<CilException> getWarnings() {
        return Collections.emptyList();
    }

    void bindParameters(Template refactor) {
        for (Node current = this.getFirst(); current != null; current = current.getNext()) {
            current.bindParameters(refactor);
        }
    }

    FlowContext checkFlow(FlowContext context) throws FlowException {
        for (Node current = this.getFirst(); current != null; current = current.getNext()) {
            current.checkFlow(context);
        }
        context.breaksFlow(false);
        return context;
    }

    boolean checkParameter(StringBuffer query) {
        if (this.isParameter()) {
            query.append(" ? ");
        }
        return this.isParameter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Node checkType(TypeDescription targetType) throws TypeException {
        boolean isEnum;
        boolean bl = isEnum = targetType != null && targetType.isEnum();
        if (isEnum) {
            this.getScope().pushCurrentEnum(targetType.asEnum());
        }
        try {
            Node node = this.checkType();
            return node;
        }
        catch (TypeException e) {
            if (targetType == null) {
                throw e;
            }
            this.reportError(e);
            this.setTypeDescription(targetType);
            Node node = this;
            return node;
        }
        finally {
            if (isEnum) {
                this.getScope().popCurrentEnum();
            }
        }
    }

    Node checkType() throws TypeException {
        if (this.hasType()) {
            return this;
        }
        Node current = this.getFirst();
        Node previous = null;
        while (current != null) {
            Node next = current.getNext();
            if (!(current instanceof InvalidNode) && current.getKind() == -1) {
                if ((current = current.checkType()).getKind() == -1) assert (false) : "Node doesn't have a type after checkType(): " + current.getClassName() + " (" + current + ")";
                current.setNext(next);
                if (previous == null) {
                    this.setFirst(current);
                } else {
                    previous.setNext(current);
                }
            }
            previous = current;
            current = next;
        }
        return this;
    }

    Node checkType(int arg) throws TypeException {
        return this.checkType();
    }

    void collectConstants(ConstantPool cp) {
        for (Node current = this.getFirst(); current != null; current = current.getNext()) {
            current.collectConstants(cp);
        }
    }

    List<Node> collectParameters(List<Node> params) {
        int last = params.size();
        for (Node current = this.getFirst(); current != null; current = current.getNext()) {
            params = current.collectParameters(params);
            if (current.isParametric()) continue;
            this.setParametric(false);
        }
        if (this.isParametric()) {
            params = params.subList(0, last);
            params.add(this);
            this.setParameter(true);
        }
        return params;
    }

    int compare(Node b) {
        assert (false) : this.getClassName();
        return 0;
    }

    Node compile(FuegoCompiler compiler) throws CompilerException {
        Node current = this;
        try {
            this.parse(compiler);
            if (compiler.getDirective(16)) {
                System.out.println(compiler.getDirective(64) ? current.dump() : current.show());
            }
            if (compiler.getDirective(128)) {
                return current;
            }
            current = current.checkType();
            if (compiler.getDirective(32)) {
                System.out.println(compiler.getDirective(64) ? current.dump() : current.show());
            }
            FlowContext context = new FlowContext(compiler.getUsageListener());
            current.checkFlow(context);
            context.reset();
        }
        catch (CompilerParserException e) {
            throw e;
        }
        catch (InvalidLanguageException e) {
            throw e;
        }
        catch (CompilerException e) {
            throw e;
        }
        catch (Throwable unexpected) {
            InternalException e = new InternalException(this, unexpected);
            this.reportError(e);
            throw e;
        }
        return current;
    }

    void copyParentFrom(Node node) {
        if (node != null) {
            Node parent = node.getParent();
            this.setParent(parent);
        }
    }

    final Node dettach() {
        this.setFirst(null);
        this.setNext(null);
        this.parent = null;
        this.prev = null;
        return this;
    }

    void copyTreePositionFrom(Node init) {
        if (init != null) {
            Node left = init.getLeftDescendant();
            Node right = init.getRightDescendant();
            int leftOffset = left.getOffset();
            int rightOffset = right.getOffset();
            this.setOffset(leftOffset);
            this.setLength(rightOffset - leftOffset + right.getLength());
        }
    }

    String dumpContext() {
        Node current;
        ArrayList<Node> parents = new ArrayList<Node>();
        for (current = this; current != null; current = current.getParent()) {
            parents.add(current);
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = parents.size() - 1; i >= 0; --i) {
            String symbolsList;
            SymbolTable symbols;
            current = (Node)parents.get(i);
            String className = Str.pad(current.getClassName(), 16);
            String typeText = this.getTypeDescription().getText();
            Scope scope = current.scope;
            SymbolTable symbolTable = symbols = scope != null ? scope.getSymbolTable() : null;
            if (symbols != null) {
                Set keys = symbols.keySet();
                symbolsList = keys.toString();
            } else {
                symbolsList = "null";
            }
            String text = className + "<scope=" + (scope != null) + ", type=" + typeText + ", symbols=" + symbolsList + "> " + current.getText();
            buffer.append(text);
            buffer.append("\n");
        }
        return buffer.toString();
    }

    Node externalNode() {
        return this;
    }

    void extractArguments(ExtractedMethod method) {
        Node current = this.getFirst();
        while (current != null) {
            Node next = current.getNext();
            current.extractArguments(method);
            current = next;
        }
    }

    void generate(CodeGenerator codeGenerator) throws CodeGenerationException {
        codeGenerator.generate(this);
    }

    Node getAutoDeclared(TypeDescription varType) throws TypeException {
        return this.getAutoDeclared(varType, false);
    }

    <T> T findChildByClass(Class<T> cl) {
        Node current;
        for (current = this.getFirst(); current != null && !cl.isAssignableFrom(current.getClass()); current = current.getNext()) {
        }
        return cl.cast(current);
    }

    Method findCurrentMember() {
        Node parent;
        if (this.currentMember == null && (parent = this.getParent()) != null) {
            this.currentMember = parent.getCurrentMember();
        }
        return this.currentMember;
    }

    Node findNodeAtPosition(int offset) {
        Node result = null;
        Node current = this.getFirst();
        while (current != null) {
            Node next = current.getNext();
            result = current.findNodeAtPosition(offset);
            if (result != null) break;
            current = next;
        }
        if (result == null && this.getOffset() != -1 && offset >= this.getOffset() && offset <= this.getOffset() + this.getLength()) {
            result = this;
        }
        return result;
    }

    <T> T findParentByClass(Class<T> cl) {
        Node current;
        for (current = this; current != null && !cl.isAssignableFrom(current.getClass()); current = current.getParent()) {
        }
        return cl.cast(current);
    }

    void generateCILSource(SourceWriter pw, CodeStyle style) {
        pw.print("[" + this.getClass().getName() + ".class]");
    }

    void generateCommaDelimitedSQL(Node first, StringBuffer sql) {
        while (first != null) {
            first.generateSQLCode(sql);
            if (first.getNext() != null) {
                sql.append(", ");
            }
            first = first.getNext();
        }
    }

    void generateSQLCode(StringBuffer query) {
        query.append("[").append(this.getClassName()).append("]");
    }

    final void invalidate() {
        this.dettach();
        this.setTypeDescription(TypeFactory.getNone());
    }

    boolean hasType() {
        return this.getKind() != -1;
    }

    boolean mustClone() {
        return (this.flags & 0x80) != 0;
    }

    void parse(FuegoCompiler compiler) throws CompilerException {
    }

    void pullStatmentUp(Node statement) {
        Node parent = this.getParent();
        if (parent != null) {
            parent.pullStatmentUp(statement);
        }
    }

    Node refactor(CodeStyle ss) {
        NodeIterator it = this.getChildren();
        while (it.hasNext()) {
            Node n = it.next();
            try {
                Node newnode = n.refactor(ss);
                if (n == newnode) continue;
                it.replace(newnode);
            }
            catch (Exception unexpected) {
                this.reportError(new InternalException(n, (Throwable)unexpected));
            }
        }
        return this;
    }

    Node removeFirst() {
        Node first = this.getFirst();
        if (first != null) {
            this.setFirst(first.getNext());
            first.setNext(null);
        }
        return first;
    }

    Node replace(Node replacement) {
        return this.replace(replacement, true);
    }

    Node replace(Node replacement, boolean dettach) {
        if (replacement != this) {
            replacement.setNext(this.getNext());
            if (this.prev != null) {
                assert (this.prev.getNext() == this);
                this.prev.setNext(replacement);
            } else {
                assert (this.parent.getFirst() == this);
                this.parent.setFirst(replacement);
            }
            if (dettach) {
                this.dettach();
            }
        }
        return replacement;
    }

    Type getElementTD() {
        TypeDescription elementType = this.getTypeDescription().getElementType();
        elementType = elementType.primitiveEquivalent(false);
        if (this.isExternal()) {
            return TD.valueOf(Conversion.getJavaType(elementType, Conversion.getElementType(this.getJavaType())));
        }
        return TD.valueOf(elementType);
    }

    Object run(RunningMonitor rm) throws ExecutionException {
        return this.run(rm, new Object[0], null);
    }

    Object run(RunningMonitor rm, Object[] args, FuegoInvokeable instance) throws ExecutionException {
        return null;
    }

    String show() {
        return this.toStringList() + "::" + ((Object)this.typeDescription).toString();
    }

    void validate() {
        StringList errors = this.validateTree(new HashSet<Node>(), StringList.create(), null);
        for (String msg : errors) {
            System.out.println("ERROR: " + msg);
        }
    }

    StringList validateTree(Set<Node> seen, StringList errors, Node parent) {
        String nodeMsg = "'" + this.getClassName();
        if (seen.contains(this)) {
            errors.add(nodeMsg + " is duplicated in the tree and should be cloned.");
            return errors;
        }
        seen.add(this);
        if (this.getKind() == -1) {
            // empty if block
        }
        if (this.getLine() <= 0 || this.getColumn() <= 0) {
            // empty if block
        }
        if (this.prev == null || this.parent != null) {
            // empty if block
        }
        for (Node current = this.getFirst(); current != null; current = current.getNext()) {
            if (current instanceof InvalidNode) continue;
            current.validateTree(seen, errors, this);
        }
        return errors;
    }

    Object value(RunningMonitor rm, Class<?> expectedClass) throws ExecutionException {
        Symbol symbol = null;
        Object value = this.run(rm);
        if (value instanceof Symbol) {
            symbol = (Symbol)value;
            value = symbol.getValue();
        }
        if (value != null && expectedClass != null && !expectedClass.isAssignableFrom(value.getClass())) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Internal error: Expected ");
            buffer.append(expectedClass);
            buffer.append(", but found: ");
            buffer.append(value.getClass());
            buffer.append(", symbol: ");
            buffer.append(symbol);
            buffer.append("\nTree: \n");
            buffer.append(this.dump());
            buffer.append("\nContext: \n");
            buffer.append(this.dumpContext());
            throw new ClassCastException(buffer.toString());
        }
        return value;
    }

    Object value(RunningMonitor rm) throws ExecutionException {
        return this.value(rm, null);
    }

    private static boolean checkNotContains(Node current, Node node) {
        if (HEAVY_ASSERTS && Node.contains((AST)current, (AST)node)) {
            current.printDump("current");
            node.printDump("node");
            return false;
        }
        return true;
    }

    private MethodTypeDescription findMember(TypeDescription type, String name, TypeFinder.Scope scope, int kind) {
        return kind == 14 ? type.findMethod(name, scope) : (kind == 18 ? type.findAttribute(name, scope) : type.findMember(name, scope));
    }

    private boolean isNumber(String name) {
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isDigit(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private void evaluateWatches(List<Watch> watches, RunningMonitor rm) throws ExecutionException {
        this.evaluateWatches = rm.isEvaluateWatchesEnabled();
        rm.setEvaluateWatchesEnabled(false);
        if (watches != null) {
            for (Watch watch : watches) {
                if (!watch.evaluate(this)) continue;
                rm.watchEvent(watch);
            }
        }
        rm.setEvaluateWatchesEnabled(this.evaluateWatches);
    }
}

