/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import java.util.List;
import java.util.RandomAccess;
import oracle.bpm.compiler.Args;
import oracle.bpm.compiler.Block;
import oracle.bpm.compiler.Diadic;
import oracle.bpm.compiler.DoBlock;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.Invoke;
import oracle.bpm.compiler.LabeledStatement;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.Scope;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.TypeDescription;

public class LoopStatement
extends Diadic {
    private String name = "";
    static final long serialVersionUID = 7169847365468370347L;
    static final long serialCheck = -3090812347337688165L;

    LoopStatement() {
    }

    LoopStatement(Token t) {
        super(t);
    }

    public Node getArray() {
        return null;
    }

    public String getFilter() {
        return null;
    }

    public Symbol getIdentifier() {
        return null;
    }

    public boolean isIteratorUsed() {
        return false;
    }

    public List getParameters() {
        return null;
    }

    public Node getWhere() {
        return null;
    }

    public boolean hasFilteredIterable() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    protected String getStatementSeparator() {
        return "\n";
    }

    boolean isArray() {
        boolean result = false;
        Node array = this.getArray();
        if (array != null) {
            TypeDescription at = array.getTypeDescription();
            result = at.isPrimitive() || RandomAccess.class.isAssignableFrom(at.getJavaClass());
        }
        return result;
    }

    void setBody(Node body) {
        this.getBody().replace(body);
    }

    Node getBody() {
        return this.getOp3();
    }

    @Override
    void setScope(Scope scp) {
        if (this.getScope() != null) {
            return;
        }
        Scope newscp = scp.makeSubScope();
        super.setScope(newscp);
    }

    Node processBody(Node b) throws TypeException {
        Block block;
        Node result = this;
        Node parent = this.getParent();
        if (!(b instanceof DoBlock)) {
            this.addTimeoutCheck(b);
            return result;
        }
        DoBlock body = (DoBlock)b;
        if (!body.getName().equals("")) {
            this.setName(body.getName());
            body.setName("");
        }
        Block statements = body.getStatements();
        Node prev = body.getPrev();
        if (body.hasOnlyStatements()) {
            block = statements;
            statements.setNext(null);
        } else {
            block = Block.makeEmpty(body);
            block.setFirst(body);
        }
        prev.setNext(block);
        this.addTimeoutCheck(statements);
        if (this.getName() != null && !this.getName().equals("")) {
            result = new LabeledStatement(new Identifier(this.getName()), result);
            result.moveHiddenTokensFrom(this);
            result.setParent(parent);
            this.setName("");
            result = result.checkType();
        }
        return result;
    }

    private boolean isLoopCheckEnabled() {
        return false;
    }

    private void addTimeoutCheck(Node block) throws TypeException {
        if (this.isLoopCheckEnabled() && block instanceof Block) {
            Args args = Args.empty(block.getScope(), 1L);
            args.setParent(block);
            Node invoke = new Invoke("checkTimeout", "super", args);
            invoke.initialize(block);
            invoke = invoke.checkType();
            invoke.setNext(block.getFirst());
            block.setFirst(invoke);
        }
    }
}

