/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.lexer.LexerConfigurator;
import fuego.parser.TokenStream;
import fuego.parser.TokenStreamHiddenTokenFilter;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import oracle.bpm.compiler.CodeStyle;
import oracle.bpm.compiler.FuegoLexer;
import oracle.bpm.compiler.FuegoParser;
import oracle.bpm.compiler.InvalidLanguageException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.SourceTemplate;
import oracle.bpm.compiler.TemplateFactory;
import oracle.bpm.compiler.TokenNames;
import oracle.bpm.compiler.TypeSpecParser;
import oracle.bpm.compiler.langs.fuego.FuegoLanguageSpec;
import oracle.bpm.compiler.langs.java.JavaLanguageSpec;
import oracle.bpm.compiler.langs.visualbasic.VisualBasicLanguageSpec;
import oracle.bpm.compiler.msg.CompilerMsg;
import oracle.bpm.compiler.type.TypeRenderer;
import oracle.bpm.type.TypeParser;
import org.jetbrains.annotations.NotNull;

public abstract class LanguageSpec {
    private final String[] indentTokens;
    private LexerConfigurator lexerConfigurator;
    private final String[] matchingTokens;
    private final String[] overwriteTokens;
    private SourceTemplate[] templates;
    private TokenNames tokenNames;
    private TypeParser typeParser;
    private TypeRenderer typeRenderer;
    private final int version;
    @NotNull
    private static final Map<String, LanguageSpec> languagesById = new TreeMap<String, LanguageSpec>();
    @NotNull
    private static final Map<String, LanguageSpec> languagesByName = new TreeMap<String, LanguageSpec>();

    protected LanguageSpec(int version, String indentTokens, String matchingTokens, String overwriteTokens) {
        this.version = version;
        Pattern pattern = Pattern.compile("\\s*,\\s*");
        this.indentTokens = pattern.split(indentTokens);
        this.matchingTokens = pattern.split(matchingTokens);
        this.overwriteTokens = pattern.split(overwriteTokens);
    }

    public abstract CodeStyle createCodeStyle();

    public abstract SourceGenerator createSourceGenerator();

    public static LanguageSpec getLanguageSpec(String name) throws InvalidLanguageException {
        assert (name != null);
        LanguageSpec result = languagesById.get(name);
        if (result == null && (result = languagesByName.get(name)) == null) {
            throw new InvalidLanguageException(name);
        }
        return result;
    }

    public static LanguageSpec[] getSupportedLanguageSpecs() {
        Collection<LanguageSpec> languages = languagesByName.values();
        return languages.toArray(new LanguageSpec[languages.size()]);
    }

    public static String[] getSupportedLanguages() {
        Set<String> set = languagesByName.keySet();
        return set.toArray(new String[set.size()]);
    }

    public static FuegoParser createParser(String languageName, boolean skipFormatTokens) throws InvalidLanguageException {
        FuegoLexer stream;
        LanguageSpec languageSpec = LanguageSpec.getLanguageSpec(languageName);
        FuegoLexer lexer = new FuegoLexer(languageSpec);
        lexer.setCreateIndentTokens(!skipFormatTokens);
        lexer.setSkipFormatTokens(skipFormatTokens);
        if (skipFormatTokens) {
            stream = lexer;
        } else {
            TokenStreamHiddenTokenFilter filter = new TokenStreamHiddenTokenFilter((TokenStream)lexer);
            filter.hide(8);
            filter.hide(9);
            filter.hide(6);
            stream = filter;
        }
        FuegoParser parser = languageSpec.createParser(stream);
        parser.init(lexer);
        return parser;
    }

    public final String getId() {
        return this.getName() + this.getVersion();
    }

    public final LexerConfigurator getLexerConfigurator() {
        if (this.lexerConfigurator == null) {
            this.lexerConfigurator = this.createLexerConfigurator();
        }
        return this.lexerConfigurator;
    }

    public final String getName() {
        return this.getLexerConfigurator().getLanguageName();
    }

    public boolean isFuego() {
        return false;
    }

    public boolean isFuego1() {
        return false;
    }

    public String getLabel() {
        return this.getName();
    }

    public boolean isOldTypePrecedenceEnabled() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    public LanguageSpec getLatest() {
        try {
            return LanguageSpec.getLanguageSpec(this.getName());
        }
        catch (InvalidLanguageException e) {
            throw new RuntimeException(e);
        }
    }

    public TypeParser getTypeParser() {
        if (this.typeParser == null) {
            this.typeParser = this.createTypeParser();
        }
        return this.typeParser;
    }

    public TypeRenderer getTypeRenderer() {
        if (this.typeRenderer == null) {
            this.typeRenderer = this.createTypeRenderer();
        }
        return this.typeRenderer;
    }

    public int getVersion() {
        return this.version;
    }

    public String[] getIndentTokens() {
        return (String[])this.indentTokens.clone();
    }

    public boolean isLastVersion() {
        return languagesByName.get(this.getName()) == this;
    }

    public String[] getMatchingTokens() {
        return (String[])this.matchingTokens.clone();
    }

    public String[] getOverwriteTokens() {
        return (String[])this.overwriteTokens.clone();
    }

    public SourceTemplate[] getTemplates() {
        if (this.templates == null) {
            this.templates = this.createTemplates();
        }
        return (SourceTemplate[])this.templates.clone();
    }

    public TokenNames getTokenNames() {
        if (this.tokenNames == null) {
            this.tokenNames = this.createTokenNames();
        }
        return this.tokenNames;
    }

    public SourceTemplate[] createTemplates() {
        TokenNames names = this.getTokenNames();
        String decl = names.declarationStart;
        decl = "".equals(decl) ? "declaration" : decl;
        String sqlGroup = "Embedded Sql";
        String conditional = "Conditional statements";
        String loops = "Loop statements";
        String interactive = "Interactive statements";
        String exceptions = "Exception statements";
        return new SourceTemplate[]{LanguageSpec.createTemplate(TemplateFactory.createIf(), names.ifSymbol, "Conditional statements"), LanguageSpec.createTemplate(TemplateFactory.createIfElse(), names.ifSymbol + ' ' + names.elseSymbol, "Conditional statements"), LanguageSpec.createTemplate(TemplateFactory.createIfElseIf(), names.ifSymbol + ' ' + names.elseSymbol + names.ifSymbol, "Conditional statements"), LanguageSpec.createTemplate(TemplateFactory.createCase(), names.caseSymbol, "Conditional statements"), LanguageSpec.createTemplate(TemplateFactory.createWhile(), names.whileSymbol, "Loop statements"), LanguageSpec.createTemplate(TemplateFactory.createFor(), names.forSymbol, "Loop statements"), LanguageSpec.createTemplate(TemplateFactory.createForEach(), names.forEachSymbol, "Loop statements"), LanguageSpec.createTemplate(TemplateFactory.createDisplay(), names.displaySymbol, "Interactive statements"), LanguageSpec.createTemplate(TemplateFactory.createDisplayFull(), names.displaySymbol + " (" + CompilerMsg.FULL_SYNTAX + ')', "Interactive statements", true), LanguageSpec.createTemplate(TemplateFactory.createInput(), names.inputSymbol, "Interactive statements"), LanguageSpec.createTemplate(TemplateFactory.createObjectInput(), names.inputSymbol + '(' + CompilerMsg.BPM_OBJECT + ')', "Interactive statements", true), LanguageSpec.createTemplate(TemplateFactory.createInputFull(), names.inputSymbol + " (" + CompilerMsg.FULL_SYNTAX + ')', "Interactive statements", true), LanguageSpec.createTemplate(TemplateFactory.createInputInterceptor(), names.inputSymbol + " (interceptor)", "Interactive statements", true), LanguageSpec.createTemplate(TemplateFactory.createLog(), names.logSymbol), LanguageSpec.createTemplate(TemplateFactory.createReturn(), names.returnSymbol), LanguageSpec.createTemplate(TemplateFactory.createExit(), names.exitSymbol), LanguageSpec.createTemplate(TemplateFactory.createDeclaration(), decl), LanguageSpec.createTemplate(TemplateFactory.createAssignment(), "assignment", null, true), LanguageSpec.createTemplate(TemplateFactory.createThrow(), names.throwSymbol, "Exception statements"), LanguageSpec.createTemplate(TemplateFactory.createOnStatement(), names.onSymbol, "Exception statements"), LanguageSpec.createTemplate(TemplateFactory.createSqlDelete(), "DELETE (sql)", "Embedded Sql"), LanguageSpec.createTemplate(TemplateFactory.createSqlInsert(), "INSERT (sql)", "Embedded Sql"), LanguageSpec.createTemplate(TemplateFactory.createSqlInsertFromTable(), "INSERT from table (sql)", "Embedded Sql", true), LanguageSpec.createTemplate(TemplateFactory.createSqlUpdate(), "UPDATE (sql)", "Embedded Sql"), LanguageSpec.createTemplate(TemplateFactory.createSqlSelect(), "SELECT (sql)", "Embedded Sql"), LanguageSpec.createTemplate(TemplateFactory.createSqlSelectFull(), "SELECT (full sql)", "Embedded Sql", true)};
    }

    public String toString() {
        return "[Language: " + this.getName() + ", Version: " + this.getVersion() + ']';
    }

    protected abstract LexerConfigurator createLexerConfigurator();

    protected abstract FuegoParser createParser(TokenStream var1);

    protected abstract TypeRenderer createTypeRenderer();

    protected static void register(LanguageSpec languageSpec) {
        assert (languageSpec != null);
        languagesById.put(languageSpec.getId(), languageSpec);
        String name = languageSpec.getName();
        LanguageSpec prev = languagesByName.get(name);
        if (prev == null || prev.getVersion() < languageSpec.getVersion()) {
            languagesByName.put(name, languageSpec);
        }
        TypeRenderer.register(languageSpec.getId(), languageSpec.getTypeRenderer());
        TypeRenderer.register(languageSpec.getName(), languageSpec.getTypeRenderer());
    }

    protected TokenNames createTokenNames() {
        return new TokenNames();
    }

    protected TypeParser createTypeParser() {
        try {
            return new TypeSpecParser(LanguageSpec.createParser(this.getName(), false));
        }
        catch (InvalidLanguageException e) {
            assert (false);
            return null;
        }
    }

    private static SourceTemplate createTemplate(Node node, String id) {
        return LanguageSpec.createTemplate(node, id, null, false);
    }

    private static SourceTemplate createTemplate(Node node, String id, String group) {
        return LanguageSpec.createTemplate(node, id, group, false);
    }

    private static SourceTemplate createTemplate(Node node, String id, String group, boolean hide) {
        assert (id != null && id.length() > 0) : "Invalid id for: " + node;
        SourceTemplate codeTemplate = new SourceTemplate(node, id, id + " statement");
        codeTemplate.setAddToPopup(!hide);
        codeTemplate.setGroup(group);
        return codeTemplate;
    }

    private static void loadClass(Class clazz) {
        try {
            Class.forName(clazz.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    static {
        LanguageSpec.loadClass(FuegoLanguageSpec.class);
        LanguageSpec.loadClass(JavaLanguageSpec.class);
        LanguageSpec.loadClass(VisualBasicLanguageSpec.class);
    }
}

