/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.DoBlock;
import oracle.bpm.compiler.DuplicatedLabelException;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.ExitException;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.InvalidNodeException;
import oracle.bpm.compiler.LoopStatement;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.type.TypeFactory;

public class LabeledStatement
extends Node {
    static final long serialVersionUID = 4599853807389093437L;
    static final long serialCheck = 5536682430344142165L;

    public LabeledStatement(Token token) {
        super(token);
    }

    LabeledStatement() {
    }

    LabeledStatement(Identifier name, Node statement) {
        this.initialize(statement);
        this.setOperands(name, statement);
    }

    @Override
    public String getText() {
        return this.getId().getText();
    }

    @Override
    public void generate(SourceGenerator cw) {
        cw.generate(this);
    }

    @Override
    protected String getStatementSeparator() {
        return "\n";
    }

    static LabeledStatement find(String name, Node source) {
        LabeledStatement label = source.findParentByClass(LabeledStatement.class);
        while (label != null && !name.equals(label.getText())) {
            source = label.getParent();
            label = source.findParentByClass(LabeledStatement.class);
        }
        return label;
    }

    Node getId() {
        return this.getOp1();
    }

    Node getStatement() {
        return this.getOp2();
    }

    @Override
    Node checkType() throws TypeException {
        if (this.getKind() != -1) {
            return this;
        }
        Node id = this.getId();
        Node statement = this.getStatement();
        if (statement == null) {
            throw new InvalidNodeException(this);
        }
        if (!(statement instanceof LoopStatement)) {
            // empty if block
        }
        statement = statement.checkType();
        String label = id.getText();
        if (LabeledStatement.find(label, this.getParent()) != null || DoBlock.findByName(label, this) != null) {
            this.reportError(new DuplicatedLabelException(id));
        }
        this.setOperands(id, statement);
        this.setTypeDescription(TypeFactory.getVoid());
        return this;
    }

    @Override
    void generate(CodeGenerator codeGenerator) throws CodeGenerationException {
        codeGenerator.generate(this);
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        block2: {
            try {
                this.getStatement().run(rm);
            }
            catch (ExitException exit) {
                if (exit.getLabel() == null || exit.getLabel().equals(this.getText())) break block2;
                throw exit;
            }
        }
        return null;
    }
}

