/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.bpm.collections.Tuple;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.JavaGenerator;
import oracle.bpm.compiler.Node;
import oracle.bpm.component.Component;
import oracle.bpm.component.Modifiable;
import oracle.bpm.component.Replaceable;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.ArgumentMap;
import oracle.bpm.lang.Bool;
import oracle.bpm.lang.Cache;
import oracle.bpm.lang.Decimal;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.lang.Int;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.Real;
import oracle.bpm.lang.RegExp;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.util.ArrayUtils;
import oracle.bpm.util.CILUtils;
import oracle.bpm.util.Conversion;
import oracle.bpm.util.MemberArray;
import oracle.bpm.util.MemberUtils;
import org.jetbrains.annotations.NonNls;

public class JavaPrintWriter
extends IndentedPrintWriter {
    private Set<String> importClasses = new TreeSet<String>();
    private int openParen;

    public JavaPrintWriter(Writer w, boolean autoFlush) {
        super(w, autoFlush);
        this.addImport(Exception.class.getName());
        this.addImport(Throwable.class.getName());
        this.addImport(Object.class.getName());
        this.addImport(String.class.getName());
        this.addImport(BigDecimal.class.getName());
        this.addImport(ArgumentMap.class.getName());
        this.addImport(Any.class.getName());
        this.addImport(Interval.class.getName());
        this.addImport(Time.class.getName());
        this.addImport(Decimal.class.getName());
        this.addImport(Real.class.getName());
        this.addImport(Int.class.getName());
        this.addImport(Str.class.getName());
        this.addImport(Bool.class.getName());
        this.addImport(DynamicObject.class.getName());
        this.addImport(Invokeable.class.getName());
        this.addImport(RegExp.class.getName());
        this.addImport(JavaClass.class.getName());
        this.addImport(Cache.class.getName());
        this.addImport(Map.class.getName());
        this.addImport(HashMap.class.getName());
        this.addImport(LinkedHashMap.class.getName());
        this.addImport(TreeMap.class.getName());
        this.addImport(List.class.getName());
        this.addImport(ArrayList.class.getName());
        this.addImport(Iterator.class.getName());
        this.addImport(Conversion.class.getName());
        this.addImport(ArrayUtils.class.getName());
        this.addImport(CILUtils.class.getName());
        this.addImport(MemberUtils.class.getName());
        this.addImport(MemberArray.class.getName());
        this.addImport(Tuple.class.getName());
        this.addImport(Component.class.getName());
        this.addImport(Modifiable.class.getName());
        this.addImport(Replaceable.class.getName());
    }

    public void addImport(String cl) {
        this.importClasses.add(cl);
    }

    public void printBinaryOp(Node op1, String operator, Node op2, JavaGenerator cg) throws CodeGenerationException {
        op1.gen(cg);
        this.print(' ');
        this.print(operator);
        this.print(' ');
        op2.gen(cg);
    }

    public void printBlock(Node body, JavaGenerator cg) throws CodeGenerationException {
        this.println('{');
        this.indent();
        body.gen(cg);
        this.dedent();
        this.println('}');
    }

    public void printFunctionCall(String func, Node arg1, Node arg2, Node arg3, JavaGenerator cg) throws CodeGenerationException {
        this.print(func);
        this.print('(');
        arg1.gen(cg);
        this.print(", ");
        arg2.gen(cg);
        this.print(", ");
        arg3.gen(cg);
        this.print(')');
    }

    public void printIfTrue(boolean cond, String text) {
        if (cond) {
            this.print(text);
        }
    }

    public void printImports() {
        for (String importClass : this.importClasses) {
            this.print("import ");
            this.print(importClass);
            this.println(";");
        }
    }

    public void printJavaCast(TypeDescription type) {
        if (type == TypeFactory.getAny()) {
            return;
        }
        this.print('(');
        this.printJavaType(type);
        this.print(") ");
    }

    public void printJavaCast(String javaType) {
        if (javaType.equals("java.lang.Object")) {
            return;
        }
        this.print('(');
        this.printJavaType(javaType);
        this.print(") ");
    }

    public void printJavaType(TypeDescription type) {
        assert (type != null) : "Type is null";
        this.printJavaType(type.javaType());
    }

    public void printJavaType(@NonNls String javaType) {
        int dot;
        if (this.importClasses.contains(javaType) && (dot = javaType.lastIndexOf(46)) != -1) {
            javaType = javaType.substring(dot + 1);
        }
        this.print(javaType.replace('$', '.'));
    }

    public void printJavaType(Class clazz) {
        this.printJavaType(clazz.getName());
    }

    public void printLabel(String label) {
        if (label != null && !label.equals("")) {
            this.printLabelName(label);
            this.print(": ");
        }
    }

    public void printLabelName(String label) {
        this.print("_" + label);
    }

    public void printNewArray(String javaType) {
        this.print("new ");
        this.printJavaType(javaType);
        this.print("[]");
    }

    public void printUnqualifiedJavaType(TypeDescription type) {
        String javaType = type.getJavaType().replace('$', '.');
        if (javaType == null || javaType.equals("")) {
            throw new IllegalArgumentException(((Object)type).toString() + " does not have a java type");
        }
        int index = javaType.lastIndexOf(".");
        if (index != -1) {
            javaType = javaType.substring(index + 1, javaType.length());
        }
        this.print(javaType);
    }

    public void removeImportForClass(String name) {
        name = ".".concat(name);
        Iterator<String> it = this.importClasses.iterator();
        while (it.hasNext()) {
            String cl = it.next();
            if (!cl.endsWith(name)) continue;
            it.remove();
        }
    }

    public void openParen() {
        this.print("(");
        ++this.openParen;
    }

    public void closeParen() {
        while (this.openParen > 0) {
            this.print(")");
            --this.openParen;
        }
    }

    void printCastedValue(String text, Node par, JavaGenerator cg) throws CodeGenerationException {
        this.print("( (");
        this.printJavaType(text);
        this.print(") ");
        par.gen(cg);
        this.print(" )");
    }

    void printCastedValue(TypeDescription type, Node par, JavaGenerator cg) throws CodeGenerationException {
        this.print("( (");
        this.printJavaType(type);
        this.print(") ");
        if (!type.isPrimitive()) {
            this.printJavaType("oracle.bpm.util.Conversion");
            this.print(".cast(");
        }
        par.gen(cg);
        if (!type.isPrimitive()) {
            this.print(", ");
            this.printJavaType(type);
            this.print(".class)");
        }
        this.print(" )");
    }

    void printConstructor(String clname, Node arg, JavaGenerator cg) throws CodeGenerationException {
        this.print("new ");
        this.printJavaType(clname);
        this.print('(');
        arg.gen(cg);
        this.print(")");
    }

    void printFunctionCall(@NonNls String func, Node arg, JavaGenerator cg) throws CodeGenerationException {
        this.print(func);
        this.print('(');
        arg.gen(cg);
        this.print(')');
    }

    void printFunctionCall(@NonNls String func, Node arg1, Node arg2, JavaGenerator cg) throws CodeGenerationException {
        this.print(func);
        this.print('(');
        arg1.gen(cg);
        this.print(", ");
        arg2.gen(cg);
        this.print(')');
    }

    void printMethodCall(String meth, Node target, JavaGenerator cg) throws CodeGenerationException {
        target.gen(cg);
        this.print('.');
        this.print(meth);
        this.print("()");
    }
}

