/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.ConversionGenerator;
import oracle.bpm.compiler.JavaGenerator;
import oracle.bpm.compiler.JavaPrintWriter;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NullConst;
import oracle.bpm.lang.Binary;
import oracle.bpm.lang.Char;
import oracle.bpm.lang.EnumTypeDescription;
import oracle.bpm.lang.JavaEnumTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.runtime.Display;
import oracle.bpm.type.TypeFactory;

public class JavaConversionGenerator
implements ConversionGenerator {
    private JavaGenerator cg;
    private JavaPrintWriter pw;

    public JavaConversionGenerator(JavaGenerator javaGenerator) {
        this.cg = javaGenerator;
        this.pw = this.cg.getPrintWriter();
    }

    public static void printConversionCall(TypeDescription targetType, JavaPrintWriter pw) {
        pw.print("Conversion." + Conversion.conversionMethod(targetType));
    }

    public static void generateCast(String expr, TypeDescription sourceType, TypeDescription targetType, JavaPrintWriter pw) {
        if (sourceType.isPrimitive() == targetType.isPrimitive()) {
            pw.printJavaCast(targetType);
            pw.print(expr);
        } else {
            if (targetType.isAny()) {
                targetType = sourceType = sourceType.primitiveEquivalent(targetType.isPrimitive());
            }
            JavaConversionGenerator.printConversionCall(targetType, pw);
            pw.print("(");
            pw.print(expr);
            pw.print(")");
        }
    }

    @Override
    public void generate(Conversion.Decimal conversion) throws CodeGenerationException {
        TypeDescription nt = conversion.newType;
        JavaConversionGenerator.printConversionCall(nt, this.pw);
        this.pw.print("(");
        conversion.getFirst().gen(this.cg);
        this.pw.print(", " + nt.getScale());
        this.pw.print(", " + nt.getLength());
        this.pw.print(")");
    }

    @Override
    public void generate(Conversion.Blob export) throws CodeGenerationException {
        Node operand = export.getFirst();
        this.pw.print("oracle.bpm.sql.BlobImpl.valueOf(");
        operand.gen(this.cg);
        this.pw.print(")");
    }

    @Override
    public void generate(Conversion.ToEnum conversion) throws CodeGenerationException {
        this.toEnum(conversion);
    }

    @Override
    public void generate(Conversion.IntReal node) throws CodeGenerationException {
        this.convertTo(node, node.newType);
    }

    @Override
    public void generate(Conversion.TimeInterval node) throws CodeGenerationException {
        this.convertTo(node, node.newType);
    }

    @Override
    public void generate(Conversion.Bool bool) throws CodeGenerationException {
        this.convertTo(bool, bool.newType);
    }

    @Override
    public void generate(Conversion.Binary node) throws CodeGenerationException {
        this.pw.printJavaType(Binary.class);
        this.pw.print(".serialize");
        this.pw.print('(');
        node.getFirst().gen(this.cg);
        this.pw.print(')');
    }

    @Override
    public void generate(Conversion conversion) throws CodeGenerationException {
        Node operand = conversion.getFirst();
        TypeDescription ot = conversion.oldType;
        TypeDescription nt = conversion.newType;
        assert (operand != null);
        assert (ot != null);
        assert (nt != null);
        if (nt.isEnum()) {
            this.toEnum(conversion);
            return;
        }
        if (ot.isEnum()) {
            EnumTypeDescription enumType = (EnumTypeDescription)ot;
            if (enumType.isNativeEnum()) {
                this.pw.print("(");
                operand.gen(this.cg);
                this.pw.printJavaType(").");
                if (nt.isInt()) {
                    this.pw.printJavaType("ordinal");
                } else {
                    this.pw.printJavaType("toString()");
                }
                return;
            }
            TypeDescription typeDescription = ot = ot.isPrimitive() ? TypeFactory.getPrimitiveInt(32) : TypeFactory.getInt();
        }
        if (nt.isEnum()) {
            TypeDescription typeDescription = nt = nt.isPrimitive() ? TypeFactory.getPrimitiveInt(32) : TypeFactory.getInt();
        }
        if (nt.isNumber() && ot.isNumber() && nt.getKind() != 3 && ot.getKind() != 3) {
            if (ot.isPrimitive() && nt.isPrimitive()) {
                this.pw.printCastedValue(nt.getJavaType(), operand, this.cg);
                return;
            }
            if (ot.isPrimitive()) {
                this.pw.print("new ");
                this.pw.printJavaType(nt);
                this.pw.print("(");
                this.pw.printJavaCast(nt.primitiveEquivalent(true));
                operand.gen(this.cg);
                this.pw.print(")");
                return;
            }
        }
        switch (nt.getKind()) {
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 16: {
                this.convertTo(conversion, nt);
                return;
            }
            case 3: {
                JavaConversionGenerator.printConversionCall(nt, this.pw);
                this.pw.print("(");
                operand.gen(this.cg);
                this.pw.print(", " + nt.getScale());
                this.pw.print(", " + nt.getLength());
                this.pw.print(")");
                return;
            }
            case 5: {
                this.stringify(operand, nt.getLength(), ot.isPrimitive());
                return;
            }
            case 8: {
                this.pw.printFunctionCall("Conversion.toBinary", operand, this.cg);
                return;
            }
        }
        if (ot.getKind() == 8) {
            this.deserialize(conversion);
            return;
        }
        if (ot.isAny()) {
            if (nt.isPredefined()) {
                this.convertTo(conversion, nt);
            } else {
                this.pw.printCastedValue(nt, operand, this.cg);
            }
            return;
        }
        if (!ot.isPrimitive() && nt.isAny()) {
            operand.gen(this.cg);
            return;
        }
        if (ot.isString() && nt.getKind() != 11) {
            this.convertTo(conversion, nt);
            return;
        }
        if ((ot.getKind() == 12 || ot.getKind() == 13) && nt.getKind() != 11) {
            this.convertToArray(conversion);
            return;
        }
        if (nt.isPrimitive() && ot.getKind() == 11) {
            if (nt.getKind() != 12) {
                throw new IllegalStateException("Illegal conversion: " + conversion);
            }
            this.pw.printCastedValue(nt, operand, this.cg);
            return;
        }
        if (nt.getKind() == 11) {
            this.pw.printCastedValue(nt, operand, this.cg);
            return;
        }
        if (!nt.isPrimitive() && ot.getKind() == 11) {
            if (nt.isArray()) {
                this.convertTo(conversion, nt);
            } else {
                this.pw.printCastedValue(nt, operand, this.cg);
            }
            return;
        }
        throw new IllegalStateException("Illegal conversion: " + conversion);
    }

    @Override
    public void generate(Conversion.Char node) throws CodeGenerationException {
        boolean primitive = node.newType.isPrimitive();
        this.pw.printJavaType(Char.class);
        this.pw.print(primitive ? ".charValue(" : ".valueOf(");
        node.getOp1().gen(this.cg);
        this.pw.print(")");
    }

    @Override
    public void generate(Conversion.Deserialize node) throws CodeGenerationException {
        this.deserialize(node);
    }

    @Override
    public void generate(Conversion.ToArray node) throws CodeGenerationException {
        this.convertToArray(node);
    }

    @Override
    public void generate(Conversion.DynamicView dynamicView) throws CodeGenerationException {
        this.pw.printFunctionCall(Display.class.getName() + ".getContentToShow", dynamicView.getOp1(), this.cg);
    }

    @Override
    public void generate(Conversion.Dynamic dynamic) throws CodeGenerationException {
        Node operand = dynamic.getOp1();
        TypeDescription newType = dynamic.getTypeDescription();
        if (newType.getKind() != 15) {
            operand.gen(this.cg);
            switch (newType.getKind()) {
                case 5: {
                    this.pw.print(".toString()");
                    break;
                }
                case 1: {
                    this.pw.print(".booleanValue()");
                    break;
                }
                case 2: {
                    this.pw.print(".longValue()");
                    break;
                }
                case 3: {
                    this.pw.print(".decimalValue()");
                    break;
                }
                case 4: {
                    this.pw.print(".doubleValue()");
                    break;
                }
                case 7: {
                    this.pw.print(".intervalValue()");
                    break;
                }
                case 6: {
                    this.pw.print(".timeValue()");
                    break;
                }
                default: {
                    this.pw.print(".convertTo(");
                    this.pw.printJavaType(newType);
                    this.pw.print(".class)");
                }
            }
            return;
        }
        this.pw.printFunctionCall("DynamicObject.valueOf", operand, this.cg);
    }

    @Override
    public void generate(Conversion.Box box) throws CodeGenerationException {
        this.box(box, box.getTypeDescription());
    }

    @Override
    public void generate(Conversion.Stringify node) throws CodeGenerationException {
        this.stringify(node.getFirst(), node.newType.getLength(), node.oldType.isPrimitive());
    }

    @Override
    public void generate(Conversion.Wide wide) throws CodeGenerationException {
        Node operand = wide.getOp1();
        TypeDescription newType = wide.getTypeDescription();
        int kind = newType.getKind();
        if (kind != 2 && kind != 4 || newType.isPrimitive()) {
            operand.gen(this.cg);
        } else {
            this.convertTo(wide, newType);
        }
    }

    @Override
    public void generate(Conversion.UnBox unBox) throws CodeGenerationException {
        TypeDescription newType = unBox.getTypeDescription();
        Node operand = unBox.getOp1();
        this.pw.printJavaCast(newType);
        if (newType.isInt() || newType.isEnum()) {
            this.pw.printFunctionCall("Int.longValue", operand, this.cg);
        } else if (newType.isReal()) {
            this.pw.printFunctionCall("Real.doubleValue", operand, this.cg);
        } else if (newType.isBool()) {
            this.pw.printFunctionCall("Bool.booleanValue", operand, this.cg);
        } else if (newType.isString()) {
            this.pw.printFunctionCall("Conversion.toString", operand, this.cg);
        } else if (newType.isArray()) {
            operand.gen(this.cg);
            this.pw.print(".toArray()");
        } else {
            throw new IllegalStateException("Type cannot be unboxed: " + unBox.oldType + "-> " + newType);
        }
    }

    @Override
    public void generate(Conversion.ToGMT toGMT) throws CodeGenerationException {
        this.pw.print("Time.toGMT(");
        toGMT.getOp1().gen(this.cg);
        this.pw.print(")");
    }

    @Override
    public void generate(Conversion.Null aNull) {
        TypeDescription newType = aNull.getTypeDescription();
        if (newType.isPrimitive() && newType.isNumber()) {
            this.pw.printJavaCast(aNull.getTypeDescription());
            this.pw.print("0");
        } else if (newType.isEnum()) {
            if (!newType.isPrimitive()) {
                this.pw.printJavaCast(aNull.getTypeDescription());
                this.pw.print("null");
            } else {
                JavaEnumTypeDescription enumType = (JavaEnumTypeDescription)newType;
                this.pw.print(String.valueOf(aNull.findInvalidValue(enumType)));
            }
        } else if (newType == TypeFactory.getPrimitiveBool()) {
            this.pw.print(Boolean.FALSE.toString());
        } else if (newType.isString() && newType.isPrimitive()) {
            this.pw.print("'\\0'");
        } else {
            this.pw.printJavaCast(aNull.getTypeDescription());
            this.pw.print("null");
        }
    }

    @Override
    public void generate(Conversion.Narrow node) throws CodeGenerationException {
        Node operand = node.getOp1();
        TypeDescription nt = node.getTypeDescription();
        TypeDescription ot = operand.getTypeDescription();
        if (ot.isPrimitive() && nt.isPrimitive()) {
            this.pw.print("(");
            this.pw.printJavaCast(node.newType);
            node.getOp1().gen(this.cg);
            this.pw.print(")");
        } else {
            this.generate((Conversion)node);
        }
    }

    @Override
    public void generate(Conversion.Import anImport) throws CodeGenerationException {
        Node operand = anImport.getFirst();
        TypeDescription newType = anImport.getTypeDescription();
        if (newType.getKind() == 12) {
            this.pw.print('(');
            this.pw.printJavaCast(operand.getTypeDescription());
            this.pw.printFunctionCall("ArrayUtils.convertElements", operand, anImport.getTargetElementClass(), this.cg);
            this.pw.print(')');
        } else {
            this.convertTo(anImport, newType);
        }
    }

    @Override
    public void generate(Conversion.FromGMT fromGMT) throws CodeGenerationException {
        this.pw.print("Time.fromGMT(");
        fromGMT.getOp1().gen(this.cg);
        this.pw.print(")");
    }

    @Override
    public void generate(Conversion.Export export) throws CodeGenerationException {
        Node operand = export.getFirst();
        String targetJavaType = export.getTargetJavaType();
        if (export.isArray()) {
            this.pw.print('(');
            this.pw.printJavaCast(targetJavaType);
            this.pw.print("ArrayUtils.convertElements(");
            if (operand instanceof NullConst) {
                this.pw.print("(Object) ");
            }
            operand.gen(this.cg);
            this.pw.print(", ");
            export.getTargetElementClass().gen(this.cg);
            this.pw.print("))");
        } else if (operand.getTypeDescription().isPrimitive() && operand.getKind() != 5 || !export.existsConversionTo(targetJavaType)) {
            this.pw.printCastedValue(targetJavaType, operand, this.cg);
        } else {
            String method = "Conversion.to" + targetJavaType.replace('.', '_');
            if (operand instanceof NullConst) {
                this.pw.print(method);
                this.pw.print("((Object) null)");
            } else {
                this.pw.printFunctionCall(method, operand, this.cg);
            }
        }
    }

    @Override
    public void generate(Conversion.Cast cast) throws CodeGenerationException {
        Node operand = cast.getOp1();
        TypeDescription nt = cast.newType;
        this.pw.printCastedValue(nt, operand, this.cg);
    }

    void convertTo(Conversion conversion, TypeDescription type) throws CodeGenerationException {
        Node op = conversion.getFirst();
        if (!conversion.existsConversionTo(type.getJavaType())) {
            this.pw.printCastedValue(type, op, this.cg);
        } else {
            String method = "Conversion." + Conversion.conversionMethod(type);
            if (type.isArray() && !type.isPrimitive() && type.getKind() != 13) {
                this.pw.print(method);
                this.pw.print('(');
                op.gen(this.cg);
                this.pw.print(',');
                this.pw.print(type.getElementType().getJavaType() + ".class");
                this.pw.print(')');
            } else if (op instanceof NullConst) {
                this.pw.print(method + "((Object) null)");
            } else {
                this.pw.printFunctionCall(method, op, this.cg);
            }
        }
    }

    private void box(Conversion box, TypeDescription newType) throws CodeGenerationException {
        Node operand = box.getOp1();
        if (newType.isString()) {
            this.pw.printFunctionCall("String.valueOf", operand, this.cg);
        } else {
            this.pw.print("new ");
            this.pw.printJavaType(newType);
            this.pw.print("(");
            this.pw.printJavaCast(newType.primitiveEquivalent(true));
            operand.gen(this.cg);
            this.pw.print(")");
        }
    }

    private void convertToArray(Conversion conversion) throws CodeGenerationException {
        TypeDescription ot = conversion.oldType;
        TypeDescription nt = conversion.newType;
        Node operand = conversion.getFirst();
        if (nt.isMap()) {
            if (nt.isOrdered()) {
                this.pw.printFunctionCall("ArrayUtils.toTreeMap", operand, this.cg);
            } else {
                this.pw.printFunctionCall("ArrayUtils.toLinkedHashMap", operand, this.cg);
            }
        } else {
            operand.setMustClone(false);
            if (nt.isPrimitive()) {
                this.pw.print('(');
                this.pw.printJavaCast(nt);
                this.pw.printFunctionCall("ArrayUtils.toArray", operand, conversion.getTargetElementClass(), this.cg);
                this.pw.print(')');
            } else {
                this.pw.print("(");
                this.pw.printJavaCast(conversion.newType.getJavaType());
                this.pw.print("Conversion.toList(");
                operand.gen(this.cg);
                this.pw.print(", ");
                this.pw.printJavaType(conversion.newType.getJavaType());
                this.pw.print(".class");
                if (conversion.getTargetElementClass() != null) {
                    this.pw.print(", ");
                    conversion.getTargetElementClass().gen(this.cg);
                }
                if (ot.getElementType() != null && (nt.getElementType().getScale() != ot.getElementType().getScale() || ot.getElementType().getLength() != nt.getElementType().getLength())) {
                    this.pw.print(", " + nt.getElementType().getScale() + ", " + nt.getElementType().getLength());
                }
                this.pw.print(")");
                this.pw.print(")");
            }
        }
    }

    private void deserialize(Conversion conversion) throws CodeGenerationException {
        TypeDescription nt = conversion.newType;
        if (nt.getKind() != 11) {
            this.convertTo(conversion, nt);
        } else {
            this.pw.print("( ");
            this.pw.printJavaCast(nt);
            this.pw.printJavaType(Binary.class);
            this.pw.print(".deserialize(");
            conversion.getFirst().gen(this.cg);
            this.pw.print(") )");
        }
    }

    private void stringify(Node node, int length, boolean primitive) throws CodeGenerationException {
        if (length >= 0) {
            this.pw.print("Str.valueOf(");
            if (primitive) {
                this.stringify(node, -1, true);
            } else {
                node.gen(this.cg);
            }
            this.pw.print(", " + length + ")");
        } else if (primitive) {
            this.pw.print("Str.valueOf(");
            node.gen(this.cg);
            this.pw.print(")");
        } else {
            this.pw.print("Str.valueOf(");
            node.gen(this.cg);
            this.pw.print(")");
        }
    }

    private void toEnum(Conversion conversion) throws CodeGenerationException {
        Node operand = conversion.getFirst();
        TypeDescription ot = conversion.oldType;
        TypeDescription nt = conversion.newType;
        EnumTypeDescription enumType = (EnumTypeDescription)nt;
        if (enumType.isNativeEnum()) {
            if (ot.isString()) {
                this.pw.printJavaType(enumType);
                this.pw.print(".valueOf(");
                operand.gen(this.cg);
                this.pw.print(")");
            } else {
                this.pw.printJavaType(enumType);
                this.pw.print(".values()[Conversion.toint(");
                operand.gen(this.cg);
                this.pw.print(")]");
            }
        } else {
            if (!enumType.isPrimitive()) {
                this.pw.print("new Integer(");
            }
            this.pw.print("Conversion.toenum(");
            operand.gen(this.cg);
            this.pw.print(", ");
            if (operand.getKind() != 5) {
                this.pw.printQuoted(enumType.getName());
                this.pw.print(", ");
            }
            if (enumType.isSequential() && ot.isInt()) {
                this.pw.print(enumType.getMemberCount() - 1);
            } else {
                conversion.getEnumArray().gen(this.cg);
            }
            this.pw.print(")");
            if (!enumType.isPrimitive()) {
                this.pw.print(")");
            }
        }
    }
}

