/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.bcgen.ClassCode;
import fuego.bcgen.FieldD;
import fuego.bcgen.JVMCodeBuilder;
import fuego.bcgen.LocalVariable;
import fuego.bcgen.MethodD;
import fuego.bcgen.Mod;
import fuego.bcgen.ModSet;
import fuego.bcgen.OpCode;
import fuego.bcgen.TD;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import oracle.bpm.compiler.Arg;
import oracle.bpm.compiler.Args;
import oracle.bpm.compiler.Arithmetic;
import oracle.bpm.compiler.ArrayConst;
import oracle.bpm.compiler.ArrayReference;
import oracle.bpm.compiler.Assignment;
import oracle.bpm.compiler.BaseCodeGenerator;
import oracle.bpm.compiler.BitwiseNot;
import oracle.bpm.compiler.BitwiseOp;
import oracle.bpm.compiler.Block;
import oracle.bpm.compiler.ClassGenerator;
import oracle.bpm.compiler.ClientStubGenerator;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.CodeKit;
import oracle.bpm.compiler.Comp;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.Declaration;
import oracle.bpm.compiler.Deref;
import oracle.bpm.compiler.DoBlock;
import oracle.bpm.compiler.Dup;
import oracle.bpm.compiler.DynamicAdaptorGenerator;
import oracle.bpm.compiler.Equality;
import oracle.bpm.compiler.Exit;
import oracle.bpm.compiler.ExprIf;
import oracle.bpm.compiler.FieldDeclaration;
import oracle.bpm.compiler.FlowContext;
import oracle.bpm.compiler.For;
import oracle.bpm.compiler.ForEach;
import oracle.bpm.compiler.Function;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.If;
import oracle.bpm.compiler.In;
import oracle.bpm.compiler.InternalException;
import oracle.bpm.compiler.Invoke;
import oracle.bpm.compiler.Is;
import oracle.bpm.compiler.JVMBCConstGenerator;
import oracle.bpm.compiler.JVMConversionGenerator;
import oracle.bpm.compiler.JavaFor;
import oracle.bpm.compiler.LabeledStatement;
import oracle.bpm.compiler.LocalVar;
import oracle.bpm.compiler.Logic;
import oracle.bpm.compiler.LoopStatement;
import oracle.bpm.compiler.MDKit;
import oracle.bpm.compiler.MappedArrayReference;
import oracle.bpm.compiler.MemberAccess;
import oracle.bpm.compiler.MemberReference;
import oracle.bpm.compiler.Method;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.Not;
import oracle.bpm.compiler.NullStatement;
import oracle.bpm.compiler.ObjectClass;
import oracle.bpm.compiler.ObjectConstructor;
import oracle.bpm.compiler.On;
import oracle.bpm.compiler.OnExit;
import oracle.bpm.compiler.Pop;
import oracle.bpm.compiler.Range;
import oracle.bpm.compiler.Return;
import oracle.bpm.compiler.SQLStatement;
import oracle.bpm.compiler.SetElement;
import oracle.bpm.compiler.StringCat;
import oracle.bpm.compiler.Switch;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.TDKit;
import oracle.bpm.compiler.Term;
import oracle.bpm.compiler.Throw;
import oracle.bpm.compiler.TypeSpec;
import oracle.bpm.compiler.UnaryArithmetic;
import oracle.bpm.compiler.While;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.Decimal;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.Argument;
import oracle.bpm.type.SourceCode;
import oracle.bpm.type.TypeFactory;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.jetbrains.annotations.NotNull;

public class JVMByteCodeGenerator
extends BaseCodeGenerator {
    private JVMCodeBuilder cb;
    private final ClassCode classCode;
    private List<Integer> dupStack;
    private File targetDir;

    public JVMByteCodeGenerator(ClassCode classCode, boolean testMode, File targetDir) {
        super(testMode);
        this.classCode = classCode;
        this.targetDir = targetDir;
        this.constGenerator = new JVMBCConstGenerator(this);
        this.conversionGenerator = new JVMConversionGenerator(this);
        this.dupStack = new ArrayList<Integer>();
    }

    public static void clearCache() {
        TD.clearRepository();
    }

    @Override
    public void emitLineNumber(int line) {
        if (this.cb != null) {
            this.cb.setLineNumber(line);
        }
    }

    public File getTargetDir() {
        return this.targetDir;
    }

    public void setTargetDir(File targetDir) {
        this.targetDir = targetDir;
    }

    @Override
    public void generate(Identifier identifier) {
        throw new IllegalStateException("Not code for: " + identifier.getClassName() + ". \nContext: \n" + identifier.dumpContext());
    }

    @Override
    public final void generate(Node node) {
        for (Node current = node.getFirst(); current != null; current = current.getNext()) {
            try {
                current.gen(this);
                continue;
            }
            catch (Exception unexpected) {
                node.reportError(new InternalException(current, (Throwable)unexpected));
            }
        }
    }

    @Override
    public void generate(LocalVar localVar) {
        this.load(localVar.getTarget());
    }

    @Override
    public void generate(DoBlock doBlock) throws CodeGenerationException {
        boolean hasOnExit;
        Block declarations = doBlock.getDeclarations();
        Block statements = doBlock.getStatements();
        Block exceptions = doBlock.getExceptions();
        OnExit onExit = doBlock.getOnExit();
        LocalVariable clientAvailable = this.generateBlockHeader(doBlock);
        if (doBlock.wrapTypedExceptions()) {
            this.cb.beginTry();
        }
        if (declarations.hasChildren()) {
            declarations.gen(this);
        }
        this.cb.beginLabeledBlock(doBlock.name);
        boolean hasExceptions = exceptions != null && exceptions.hasChildren();
        boolean bl = hasOnExit = onExit != null;
        if (hasExceptions || hasOnExit) {
            this.cb.beginTry(hasOnExit);
        }
        if (statements.hasChildren()) {
            statements.gen(this);
        }
        if (hasExceptions) {
            LocalVariable throwable = this.cb.addCatch(TD.THROWABLE, "throwable");
            On onClause = (On)exceptions.getFirst();
            this.cb.beginIf();
            this.generateOnClause(onClause, throwable);
            while ((onClause = (On)onClause.getNext()) != null) {
                this.cb.addElse();
                this.generateOnClause(onClause, throwable);
            }
            this.cb.addElse();
            this.cb.loadLocal(throwable);
            this.cb.throwObject();
            this.cb.endIf();
        }
        if (hasOnExit) {
            this.cb.addFinally();
            onExit.getFirst().gen(this);
        }
        if (hasExceptions || hasOnExit) {
            this.cb.endTry();
        }
        this.cb.endLabeledBlock();
        if (doBlock.wrapTypedExceptions()) {
            LocalVariable e = this.cb.addCatch(TD.THROWABLE, "e");
            this.cb.loadLocal(e);
            this.cb.construct(TD.RUNTIME_EXCEPTION, (Type)TD.THROWABLE);
            this.cb.throwObject();
            this.cb.endTry();
        }
        this.generateBlockFooter(clientAvailable);
    }

    @Override
    public void generate(Invoke.ConstructorCall constructorCall) throws CodeGenerationException {
        Invoke invoke = constructorCall.getInvoke();
        Args inputArgs = invoke.getInputArgs();
        TypeDescription objType = invoke.getObjType();
        if (invoke.hasInstanceCreator()) {
            Node op = invoke.getCreatorOperator();
            TypeDescription at = op.getTypeDescription();
            op.gen(this);
            this.cb.invoke(MethodD.create((Type)TD.OBJECT, TD.getObjectType(at), "createNewElement", new Type[0]));
            this.cb.convert(TD.valueOf(at.getElementType()));
        } else if (invoke.isDynamic()) {
            for (String parameter : constructorCall.dynamicConstructorParameters()) {
                this.cb.loadConstant(parameter);
            }
            this.loadInputArguments(invoke);
            this.cb.invoke(invoke.isRemote() ? MDKit.INSTANTIATE_REMOTE : MDKit.INSTANTIATE_DYNAMIC);
        } else {
            ObjectType type = this.createObject(objType);
            ArrayList<Type> args = new ArrayList<Type>();
            if (objType.isInnerType()) {
                this.cb.loadThis();
                args.add(TD.valueOf(objType.getParent()));
            }
            for (Node n = inputArgs.getFirst(); n != null; n = n.getNext()) {
                Arg arg = (Arg)n;
                if (!arg.isArgument()) continue;
                args.add(TD.valueOf(arg.getTypeDescription()));
                arg.gen(this);
            }
            this.cb.invokeConstructor(type, args.toArray(new Type[args.size()]));
        }
    }

    @Override
    public void generate(Invoke.MethodCall methodCall) throws CodeGenerationException {
        Invoke invoke = methodCall.getInvoke();
        Node objectNode = invoke.getObject();
        MethodTypeDescription memberType = invoke.getMemberType();
        String methodText = JVMByteCodeGenerator.getMemberText(memberType);
        boolean callToParent = this.loadObjectReference(invoke);
        if (invoke.hasRelay()) {
            this.addConstantTrace(invoke, "begin relay:", methodText);
            if (methodCall.getCurrentMember().isStatic()) {
                this.cb.loadNull();
            } else {
                this.cb.loadThis();
            }
            this.cb.loadConstant(MemberAccess.getSignature(invoke.objType, memberType));
            this.loadInputArguments(invoke);
            this.cb.loadConstant(invoke.getTargetCIL().getText());
            this.loadBindings(invoke.getTargetInvoke());
            this.cb.invoke(MDKit.RELAY_TO);
            this.cb.throwObject();
        } else {
            MethodD method;
            this.addConstantTrace(invoke, "begin call:", methodText);
            if (invoke.isDynamic()) {
                this.cb.loadConstant(MemberAccess.getSignature(invoke.objType, memberType));
                this.cb.loadConstant(methodCall.getSynchronous());
                this.loadInputArguments(invoke);
                LocalVar returnArray = invoke.returnArray;
                if (returnArray == null) {
                    this.cb.loadNull();
                } else {
                    this.cb.loadLocal(returnArray.getLocalVariable());
                }
                method = MDKit.INVOKE_DYNAMIC;
            } else {
                if (invoke.isDelegated()) {
                    objectNode.gen(this);
                }
                invoke.generateInputArguments(this);
                method = invoke.getMethodD(callToParent);
            }
            this.cb.invoke(method);
            this.addConstantTrace(invoke, "end call:", methodText);
            if (methodCall.isExpression()) {
                Type to = TD.valueOf(memberType.getResultArgument().getJavaType());
                if (TD.isAssignableFrom(method.getReturnType(), to)) {
                    this.cb.convert(to);
                }
            } else if (!method.isVoid()) {
                this.cb.pop();
            }
        }
    }

    @Override
    public void generate(StringCat node) throws CodeGenerationException {
        node.getOp1().gen(this);
        node.getOp2().gen(this);
        this.cb.invoke(MDKit.MD_CONCAT);
    }

    @Override
    public void generate(CodeKit.CloneCall cloneCall) throws CodeGenerationException {
        cloneCall.getOp1().gen(this);
        this.cb.invoke(MDKit.MD_DEEP_COPY);
    }

    @Override
    public void generate(FieldDeclaration field) throws CodeGenerationException {
        ModSet modifiers = field.getFieldModifiers();
        TypeDescription type = field.getTypeDescription();
        String name = field.getName();
        Node init = field.getInitialValue();
        Object value = null;
        if (type.isPrimitive() && init != null && init instanceof Const) {
            value = ((Const)init).getPrimitiveValue();
        }
        Type fieldType = TD.valueOf(type.javaType());
        if (type.isEnum() && !type.isNativeEnum()) {
            fieldType = Type.LONG;
        }
        FieldD fieldD = this.classCode.addField(modifiers, fieldType, name, value);
        if (init != null && value == null) {
            this.setCodeBuilder(this.classCode.getInitializer());
            if (init instanceof Const) {
                ((Const)init).generate(this.constGenerator);
            } else {
                init.gen(this);
            }
            this.cb.storeField(fieldD);
        }
        this.generateArrayMetadata(type, name, field.getFieldModifiers());
    }

    @Override
    public void generate(Arithmetic arithmetic) throws CodeGenerationException {
        Node op1 = arithmetic.getOp1();
        Node op2 = arithmetic.getOp2();
        op1.gen(this);
        op2.gen(this);
        if (arithmetic.isDecimal()) {
            this.cb.invoke(ArithmeticMath.METHODS[arithmetic.getOperator()]);
        } else {
            this.cb.math(arithmetic.getOperatorText());
        }
    }

    @Override
    public void generate(Deref deref) throws CodeGenerationException {
        Node op1 = deref.getOp1();
        Symbol symbol = op1.getSymbol();
        op1.gen(this);
        if (symbol != null && symbol.isHolder()) {
            this.loadHolder(deref.getTypeDescription(), symbol.getHolderType());
        }
    }

    @Override
    public final void generate(Method method) throws CodeGenerationException {
        assert (method.compiled) : "method is not compiled";
        MethodTypeDescription member = method.getMethodType();
        this.setCodeBuilder(this.createMethod(method, ""));
        if (this.isTraceEnabled(method) && method.isTooLong()) {
            this.generateTrace(method, "Tracing is disabled because the current member is too long");
        }
        if (member.hasModifiers(65536L) && method.getCurrentClass().mustGenerateStubs() && !member.isConstructor()) {
            ClientStubGenerator.generateClientStub(this, method);
        }
        this.generate((DoBlock)method);
        if (member.isConstructor() || member.getResultType().isVoid()) {
            this.cb.retrn();
        }
        this.cb.endCode();
        if (member.hasModifiers(0x20000000000L)) {
            this.generateArrayMetadata(member.getResultType(), member.getName(), method.getAccessModifiers());
        }
        DynamicAdaptorGenerator.generate(this, method);
    }

    @Override
    public void generate(ObjectClass objectClass) throws CodeGenerationException {
        if (objectClass.isCodeGenerationInProgress()) {
            ClassGenerator.generate(objectClass, this);
        } else {
            try {
                objectClass.generate(this.getTargetDir());
            }
            catch (InternalException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public void generate(Return returnNode) throws CodeGenerationException {
        Node expr = returnNode.getFirst();
        if (expr != null) {
            expr.gen(this);
        }
        this.cb.retrn();
    }

    @Override
    public void generate(Declaration declaration) throws CodeGenerationException {
        if (declaration.isUsed()) {
            Symbol symbol = declaration.getSymbol();
            if (symbol.isExternalArgument()) {
                this.initialize(declaration);
            } else if (symbol.isHolder()) {
                ObjectType holderType = TD.getObjectType(symbol.getArgument().getHolderJavaType());
                if (this.initialize(declaration)) {
                    this.cb.construct(holderType, TD.valueOf(symbol.getArgument().getType()));
                } else {
                    this.cb.construct(holderType);
                }
                LocalVariable var = this.cb.createLocalVariable(symbol.getName(), (Type)holderType);
                this.cb.storeLocal(var);
                symbol.setLocalVariable(var);
            } else {
                Type varType = TD.valueOf(declaration.getTypeDescription());
                LocalVariable var = this.cb.createLocalVariable(symbol.getName(), varType);
                if (this.initialize(declaration)) {
                    this.cb.storeLocal(var);
                }
                symbol.setLocalVariable(var);
            }
        }
    }

    @Override
    public void generate(Logic node) throws CodeGenerationException {
        this.cb.beginLogical(node.getOperatorSymbol());
        node.getOp1().gen(this);
        this.cb.logicalOperand();
        node.getOp2().gen(this);
        this.cb.endLogical();
    }

    @Override
    public void generate(Not n) throws CodeGenerationException {
        n.getFirst().gen(this);
        this.cb.not();
    }

    @Override
    public void generate(If node) throws CodeGenerationException {
        this.cb.beginIf();
        node.getOp1().gen(this);
        this.cb.addThen();
        node.getOp2().gen(this);
        Node elseBlock = node.getOp3();
        if (elseBlock != NullStatement.node) {
            this.cb.addElse();
            node.getOp3().gen(this);
        }
        this.cb.endIf();
    }

    @Override
    public void generate(Throw node) throws CodeGenerationException {
        node.getFirst().gen(this);
        if (node.isUserDefined()) {
            this.cb.construct(TDKit.RUNTIME_CIL_EXCECUTION_EXCEPTION, (Type)TD.OBJECT);
        }
        this.cb.throwObject();
    }

    @Override
    public void generate(Comp node) throws CodeGenerationException {
        Node op1 = node.getOp1();
        TypeDescription td = op1.getTypeDescription();
        op1.gen(this);
        node.getOp2().gen(this);
        if (td.isPrimitive()) {
            this.cb.compare(OpCode.forOperator(node.getOperator()));
        } else if (node.isLike()) {
            this.cb.invoke(MDKit.MD_LIKE);
            if (node.isNotLike()) {
                this.cb.not();
            }
        } else {
            this.cb.invoke(MDKit.MD_ANY_COMPARE);
            this.cb.compareZero(OpCode.forOperator(node.getOperator()));
        }
    }

    @Override
    public void generate(Equality node) throws CodeGenerationException {
        Node op1 = node.getOp1();
        TypeDescription td = op1.getTypeDescription();
        op1.gen(this);
        node.getOp2().gen(this);
        if (td.isPrimitive() && !td.isString()) {
            this.cb.compare(OpCode.forOperator(node.getOperator()));
        } else {
            this.cb.invoke(MDKit.MD_ANY_EQUALS);
            if (!node.isEquals()) {
                this.cb.not();
            }
        }
    }

    @Override
    public void generate(Is node) throws CodeGenerationException {
        TypeDescription targetType = node.getTargetType();
        node.getOp1().gen(this);
        if (targetType == TypeFactory.getNull()) {
            this.cb.compareNull(node.isNegative());
        } else {
            if (targetType.isInvokeable()) {
                this.cb.loadConstant(targetType.asObject().getComponentType());
                this.cb.loadConstant(targetType.getSignature());
                this.cb.invoke(MDKit.INVOKE_ISINSTANCEOF);
            } else {
                this.cb.instanceOf(TD.getObjectType(targetType.primitiveEquivalent(false)));
            }
            if (node.isNegative()) {
                this.cb.not();
            }
        }
    }

    @Override
    public void generate(In node) throws CodeGenerationException {
        Node op1 = node.getOp1();
        Node op2 = node.getOp2();
        if (node.isRange()) {
            Range range = (Range)op2;
            op1.gen(this);
            range.getOp1().gen(this);
            range.getOp2().gen(this);
            this.cb.invoke(MDKit.MD_BETWEEN);
        } else {
            op2.gen(this);
            op1.gen(this);
            this.cb.invoke(MDKit.contains(op2.getKind()));
        }
    }

    @Override
    public void generate(CodeKit.BitSetReference node) {
        this.cb.loadThis();
        this.cb.loadField(this.getBitSetField(node));
    }

    @Override
    public void generate(BitwiseNot node) throws CodeGenerationException {
        node.getOp1().generate(this);
        this.cb.bitNot();
    }

    @Override
    public void generate(BitwiseOp node) throws CodeGenerationException {
        node.getOp1().gen(this);
        node.getOp2().gen(this);
        this.cb.math(node.getOperatorName());
    }

    @Override
    public void generate(CodeKit.ClearBitSet node) {
        this.cb.loadThis();
        this.cb.loadConstant(0L);
        this.cb.storeField(this.getBitSetField(node));
    }

    @Override
    public void generate(Exit node) throws CodeGenerationException {
        Node label;
        Node pred = node.getFirst();
        if (pred != null) {
            this.cb.beginIf();
            pred.gen(this);
            this.cb.addThen();
        }
        if ((label = node.getLabel()) == null) {
            if (node.isInLoop()) {
                this.cb.exitWhile();
            } else {
                this.cb.retrn();
            }
        } else {
            this.cb.exitWhile(label.getText());
        }
        if (pred != null) {
            this.cb.endIf();
        }
    }

    @Override
    public void generate(ExprIf node) throws CodeGenerationException {
        this.cb.beginIf();
        node.getPredicate().gen(this);
        this.cb.addThen();
        node.getTrueExpr().gen(this);
        this.cb.addElse();
        node.getFalseExpr().gen(this);
        this.cb.endExprIf();
    }

    @Override
    public void generate(For node) throws CodeGenerationException {
        Node fromRange = node.getFromRange();
        boolean range = fromRange != null;
        Symbol id = node.getIdentifier();
        LocalVariable index = this.createIndexVariable(false, id);
        if (!range) {
            this.forIn(node, false);
        } else {
            LocalVariable length;
            Node toRange = node.getToRange();
            fromRange.gen(this);
            this.cb.storeLocal(index);
            if (toRange instanceof Const) {
                length = null;
            } else {
                length = this.cb.createLocalVariable(id.getName() + "_to", index.getType());
                toRange.gen(this);
                this.cb.storeLocal(length);
            }
            this.cb.beginWhile();
            this.cb.loadLocal(index);
            if (length == null) {
                toRange.gen(this);
            } else {
                this.cb.loadLocal(length);
            }
            this.cb.addWhileBody(OpCode.IFLE);
            this.loopBody(node);
            this.cb.inc(index, 1);
            this.debugVar(index, node, id.getName(), id.getType().getJavaType());
            this.cb.endWhile();
        }
    }

    @Override
    public void generate(ForEach node) throws CodeGenerationException {
        boolean selectStatement = node.getSelectStatement() != null;
        this.createIndexVariable(selectStatement, node.getIdentifier());
        if (selectStatement) {
            this.sqlForEach(node);
        } else {
            this.forIn(node, true);
        }
    }

    @Override
    public void generate(Function node) throws CodeGenerationException {
        Node arg = node.getOp1();
        arg.setMustClone(false);
        arg.gen(this);
        this.cb.invoke(MDKit.MD_ANY_CLONE);
        if (node.isExpression()) {
            this.cb.convert(TD.valueOf(arg.getTypeDescription()));
        } else {
            this.cb.pop();
        }
    }

    @Override
    public void generate(JavaFor node) throws CodeGenerationException {
        node.getInit().gen(this);
        this.cb.beginWhile();
        node.getCond().gen(this);
        this.cb.addWhileBody();
        node.getBody().gen(this);
        node.getReinit().gen(this);
        this.cb.endWhile();
    }

    @Override
    public void generate(LabeledStatement node) throws CodeGenerationException {
        Node statement = node.getStatement();
        this.cb.beginLabeledBlock(node.getText());
        statement.gen(this);
        this.cb.endLabeledBlock();
    }

    @Override
    public void generate(MappedArrayReference node) throws CodeGenerationException {
        node.getOp1().gen(this);
        this.cb.loadConstant(node.getGetter());
        this.cb.loadConstant(node.getSetter());
        node.getElementClass().gen(this);
        this.cb.invoke(MDKit.MEMBERARRAY_CREATE);
    }

    @Override
    public void generate(MemberReference node) throws CodeGenerationException {
        MethodTypeDescription member = node.getMemberType();
        String getter = MemberAccess.getSignature(node.objType, member);
        TypeDescription objType = node.getObjType();
        Type resultType = node.getResultTD();
        boolean bySignature = MemberAccess.isDelegatedBySignature(getter, objType);
        if (getter == null) {
            throw new IllegalStateException("Missing signature for:" + member.getParent() + '.' + member.getText());
        }
        boolean isStatic = member.isStatic();
        boolean leftValue = node.isLeftValue();
        if (leftValue && !objType.isInvokeable() && !member.isSynthesized() && !bySignature && member.isAttribute()) {
            if (isStatic) {
                node.getObjectClass().gen(this);
                this.cb.loadNull();
            } else {
                this.cb.loadNull();
                this.loadObjectReference(node);
            }
            this.cb.loadConstant(getter);
            String setter = MemberAccess.getWriteSignature(objType, member);
            if (setter == null) {
                this.cb.loadNull();
            } else {
                this.cb.loadConstant(setter);
            }
            this.cb.invoke(MDKit.MEMBER_GET);
            this.cb.convert(resultType);
            return;
        }
        boolean callToParent = this.loadObjectReference(node);
        getter = MemberAccess.getSignature(objType, member);
        if (objType.getKind() == 15) {
            this.cb.loadConstant(node.getOp2().getText());
            this.cb.invoke(MDKit.DYNAMIC_GET_FIELD);
        } else if (objType.isInvokeable()) {
            if (getter != null) {
                this.cb.loadConstant(getter);
            } else {
                this.cb.loadNull();
            }
            if (member.isAttribute()) {
                if (leftValue) {
                    String setter = MemberAccess.getWriteSignature(objType, member);
                    if (setter != null) {
                        this.cb.loadConstant(setter);
                    } else {
                        this.cb.loadNull();
                    }
                }
                this.cb.invoke(leftValue ? MDKit.GET_ATTRIBUTE2 : MDKit.GET_ATTRIBUTE);
            } else {
                this.cb.loadConstant(true);
                this.cb.loadNull();
                this.cb.loadNull();
                this.cb.invoke(MDKit.INVOKE_DYNAMIC);
            }
        } else if (getter.charAt(0) == 'A') {
            ObjectType targetType = TD.getObjectType(member.getParent());
            this.cb.loadField(FieldD.createFromSignature(isStatic, targetType, getter));
        } else if (getter.charAt(0) == 'M') {
            if (node.isPrimitiveAccess()) {
                ObjectType targetType = TD.getObjectType(member.getParent());
                Type fieldType = node.getFieldTD();
                String fieldName = FieldDeclaration.name(node.getMemberName());
                TypeDescription type = node.getTypeDescription();
                if (!type.isEnum() || type.isNativeEnum()) {
                    this.cb.loadField(FieldD.create(isStatic, targetType, fieldName, fieldType));
                } else {
                    this.cb.loadField(FieldD.create(isStatic, targetType, fieldName, TD.LONG));
                    this.cb.convert((Type)Type.INT);
                }
            } else {
                TypeDescription targetType = callToParent || node.isDelegationInClient() ? member.getParent() : objType;
                this.cb.invoke(MethodD.createFromSignature(isStatic, TD.getObjectType(targetType), getter));
            }
        } else if (bySignature) {
            if (node.delegationInClient && !node.memberType.isStatic()) {
                node.getOp1().gen(this);
            }
            this.cb.invoke(MethodD.createFromSignature(getter));
            this.cb.convert(resultType);
        } else assert (false);
        if (objType.isInvokeable() && !node.isSqlComponent()) {
            this.cb.convert(resultType);
        }
    }

    @Override
    public void generate(SQLStatement node) throws CodeGenerationException {
        this.cb.loadConstant(node.getRealConfigName());
        String schema = node.getSchema();
        if (schema != null) {
            this.cb.loadConstant(schema);
        } else {
            this.cb.loadNull();
        }
        String code = node.getCode();
        this.addConstantTrace(node, "executing query:", code);
        this.cb.loadConstant(code);
        this.generateParameters(node.getParameters());
        ArrayConst types = node.getTypes();
        if (types == null) {
            this.cb.loadNull();
        } else {
            types.gen(this);
        }
        this.cb.invoke(MDKit.executeSQL(node.isUpdate()));
    }

    @Override
    public void generate(CodeKit.SetBitSet node) {
        this.cb.loadThis();
        this.cb.dup();
        FieldD field = this.getBitSetField(node);
        this.cb.loadField(field);
        this.cb.loadConstant(node.getBitIndex());
        this.cb.math("|");
        this.cb.storeField(field);
    }

    @Override
    public void generate(SetElement node) throws CodeGenerationException {
        Node array = node.getOp1();
        assert (array != null) : "Array shouldn't be null";
        array.gen(this);
        node.generateIndex(this);
        node.generateValue(this);
        if (array.getTypeDescription().isMap()) {
            this.cb.invoke(MDKit.MAP_SET);
            this.cb.pop();
        } else if (array.getTypeDescription().isPrimitive()) {
            node.getElementClass().gen(this);
            if (node.isExtendArray()) {
                this.cb.invoke(MDKit.ARRAYP_ADD);
            } else {
                this.cb.loadConstant(node.isExpression());
                this.cb.invoke(MDKit.ARRAYP_SET);
            }
            if (node.isExpression()) {
                this.cb.convert(TD.valueOf(node.getArrayClass().getTypeToCast()));
            } else {
                this.cb.pop();
            }
        } else if (node.isExtendArray()) {
            this.cb.invoke(MDKit.COLLECTION_ADD);
            this.cb.pop();
        } else {
            this.cb.invoke(MDKit.ARRAY_SET);
        }
    }

    @Override
    public void generate(Term node) throws CodeGenerationException {
        node.getOp1().gen(this);
        node.getOp2().gen(this);
        this.cb.invoke(MDKit.getMethod(node));
    }

    @Override
    public void generate(TypeSpec node) {
        throw new IllegalStateException("Not code for: " + node.getClassName());
    }

    @Override
    public void generate(UnaryArithmetic node) throws CodeGenerationException {
        node.getFirst().gen(this);
        if (node.isMinus()) {
            TypeDescription typeDescription = node.getTypeDescription();
            if (typeDescription.isPrimitive()) {
                this.cb.negate();
            } else {
                Type t = TD.valueOf(typeDescription);
                this.cb.invoke(MethodD.createStatic(t, TDKit.utility(typeDescription), "negate", t));
            }
        }
    }

    @Override
    public void generate(CodeKit.ValueOfCall node) throws CodeGenerationException {
        node.getOp1().gen(this);
        node.getResultClass().generate(this);
        this.cb.invoke(MDKit.FODELEGATE_VALUEOF);
        this.cb.convert(TD.valueOf(node.getResultType()));
    }

    @Override
    public void generate(While node) throws CodeGenerationException {
        this.cb.beginWhile(node.getName());
        node.getOp1().gen(this);
        this.cb.addWhileBody();
        node.getOp2().gen(this);
        this.cb.endWhile();
    }

    @Override
    public void generate(ArrayReference node) throws CodeGenerationException {
        Type elementTD;
        boolean integerIndex;
        Node array = node.getOp1();
        Node index = node.getOp2();
        TypeDescription arrayType = array.getTypeDescription();
        TypeDescription indexType = index.getTypeDescription();
        boolean bl = integerIndex = indexType.isInt() && indexType.isPrimitive();
        if (node.isAutoInit()) {
            node.getObject().gen(this);
            index.gen(this);
            if (integerIndex) {
                this.cb.convert(TD.INT);
            }
            this.cb.loadConstant(oracle.bpm.lang.JavaClass.getFieldNameFromSignature(node.getMember()));
            this.cb.invoke(MDKit.ARRAYP_LGET);
            elementTD = array.getElementTD();
        } else {
            array.gen(this);
            index.gen(this);
            if (integerIndex) {
                this.cb.convert(TD.INT);
            }
            if (arrayType.isInvokeable()) {
                this.cb.invoke(MDKit.dynamicGet(integerIndex));
                elementTD = TD.valueOf(arrayType.getElementType());
            } else if (arrayType.isPrimitive()) {
                this.cb.arrayLoad();
                elementTD = null;
            } else {
                boolean isLeftValue = node.isLeftValue();
                if (isLeftValue) {
                    node.getElementType().gen(this);
                }
                this.cb.invoke(MDKit.collectionGet(arrayType.isMap(), isLeftValue));
                elementTD = TD.valueOf(arrayType.getElementType().primitiveEquivalent(false));
            }
        }
        if (elementTD != null) {
            this.cb.convert(elementTD);
        }
    }

    @Override
    public void generate(Switch node) throws CodeGenerationException {
        node.getOp1().gen(this);
        this.cb.beginIf();
        for (Node current = node.getOp2(); current != null; current = current.getNext()) {
            Node block;
            if (current instanceof Switch.Default) {
                block = current.getOp1();
                block.generate(this);
            } else {
                this.generatePredicate(current.getOp1().getFirst());
                this.cb.addThen();
                block = current.getOp2();
            }
            if (block.getOp1() == null) {
                this.cb.nop();
            } else {
                block.generate(this);
            }
            if (current.getNext() == null) continue;
            this.cb.addElse();
        }
        this.cb.endIf();
    }

    @Override
    public void generate(Dup node) throws CodeGenerationException {
        node.getFirst().gen(this);
        this.emitDup(-1);
    }

    @Override
    public void generate(Pop node) throws CodeGenerationException {
        node.getFirst().gen(this);
    }

    @Override
    public void generateStatementSeparator(Node n) {
        assert (this.cb.getStack().isEmpty()) : "Stack must be empty.";
    }

    @Override
    public void generate(Assignment assignment) throws CodeGenerationException {
        LocalVar lv = assignment.getLocalVar();
        Node value = assignment.getOp2();
        Symbol symbol = lv.getSymbol();
        if (symbol.isHolder()) {
            this.load(symbol);
            this.genValueAndDup(value, assignment.isExpression(), 1);
            this.debugAssignment(lv, value);
            this.storeHolder(symbol.getType(), symbol.getHolderType());
        } else {
            this.genValueAndDup(value, assignment.isExpression(), 0);
            this.debugAssignment(lv, value);
            Argument argument = symbol.getArgument();
            if (argument != null && !argument.isReturnValue()) {
                this.cb.storeArgument(argument.getNumber());
            } else {
                this.cb.storeLocal(symbol.getLocalVariable());
            }
        }
    }

    @Override
    protected void generateDynamicReturnArray(LocalVar returnArray, Args outputArgs, Invoke invoke) {
        ArrayList<String> list = new ArrayList<String>();
        if (outputArgs != null && invoke.isDynamic()) {
            for (Node node = outputArgs.getFirst(); node != null; node = node.getNext()) {
                String signature = ((Arg)node).getSignature();
                if (signature == null) continue;
                list.add(signature);
            }
        }
        LocalVariable var = returnArray.getSymbol().getLocalVariable();
        this.cb.createArray(TD.OBJECT_ARRAY, list.size());
        for (int i = 0; i < list.size(); ++i) {
            this.cb.dup();
            this.cb.loadConstant(i);
            this.cb.loadConstant((String)list.get(i));
            this.cb.arrayStore();
        }
        this.cb.storeLocal(var);
    }

    @Override
    protected void generateSetter(Node object, TypeDescription type, MethodTypeDescription member, Node value, String field, boolean isPrimitiveAccess, boolean expression) throws CodeGenerationException {
        Type valueType = value.getTD();
        boolean isStatic = member.isStatic();
        boolean callToParent = this.loadObjectReference(object, type, member, false);
        ObjectType target = callToParent ? TD.getObjectType(type.getParent()) : (member.isStatic() ? TD.getObjectType(member.getParent()) : TD.getObjectType(type));
        if (type.getKind() == 15) {
            this.cb.loadConstant(field);
            this.genValueAndDup(value, expression, 2);
            this.cb.invoke(MDKit.setField(valueType));
            this.cb.pop();
        } else if (type.isInvokeable()) {
            this.cb.loadConstant(Str.escape(MemberAccess.getWriteSignature(type, member)));
            this.genValueAndDup(value, expression, 2);
            this.cb.invoke(MDKit.INVOKEABLE_SET_ATTR);
            this.cb.pop();
        } else {
            this.genValueAndDup(value, expression, 1);
            if (isPrimitiveAccess) {
                String fieldName = FieldDeclaration.name(member.getName());
                TypeDescription resultType = member.getResultType();
                if (!resultType.isEnum() || resultType.isNativeEnum()) {
                    this.cb.storeField(FieldD.create(isStatic, target, fieldName, valueType));
                } else {
                    this.cb.convert((Type)Type.LONG);
                    this.cb.storeField(FieldD.create(isStatic, target, fieldName, (Type)Type.LONG));
                }
            } else {
                String memberSignature = MemberAccess.getWriteSignature(type, member);
                boolean dynamicMember = member.getResultType().isInvokeable();
                if (oracle.bpm.lang.JavaClass.isAttribute(memberSignature)) {
                    FieldD fieldD = FieldD.createSetterFromSignature(isStatic, target, memberSignature, dynamicMember);
                    this.cb.storeField(fieldD);
                } else if (oracle.bpm.lang.JavaClass.isMethod(memberSignature)) {
                    MethodD methodD = MethodD.createSetterFromSignature(isStatic, target, memberSignature, dynamicMember);
                    this.cb.invoke(methodD);
                } else {
                    throw new IllegalStateException("Invalid Signature: " + memberSignature);
                }
            }
        }
    }

    ObjectType createObject(TypeDescription objType) {
        ObjectType type = TD.getObjectType(objType);
        assert (JVMByteCodeGenerator.checkNotAbstract(type)) : "Cannot instantiate abstract class " + type;
        this.cb.newObject((Type)type);
        this.cb.dup();
        return type;
    }

    ClassCode getClassCode() {
        return this.classCode;
    }

    JVMCodeBuilder getCodeBuilder() {
        return this.cb;
    }

    void setCodeBuilder(JVMCodeBuilder cb) {
        this.cb = cb;
    }

    void storeHolder(TypeDescription type, String holderJavaType) throws CodeGenerationException {
        if (Any.isLazyHolder(holderJavaType)) {
            this.cb.invoke(MDKit.LAZY_HOLDER_PUT);
        } else {
            ObjectType holderType = TD.getObjectType(holderJavaType);
            if ((type.isInt() || type.isReal()) && !type.isPrimitive()) {
                this.cb.invoke(MethodD.create((Type)Type.VOID, holderType, "put", new Type[]{TD.NUMBER}));
            } else {
                FieldD hType = TDKit.valueField((Type)holderType);
                if (type.isInt() && type.isPrimitive() || type.isEnum()) {
                    this.cb.convert(hType.getType());
                }
                this.cb.storeField(hType);
            }
        }
    }

    void loadHolder(TypeDescription type, String holderJavaType) {
        if (Any.isLazyHolder(holderJavaType)) {
            this.cb.invoke(MDKit.LAZY_HOLDER_GET);
        } else {
            this.cb.loadField(TDKit.valueField((Type)TD.getObjectType(holderJavaType)));
        }
        if (type.isPrimitive() || !type.isInt() && !type.isReal()) {
            this.cb.convert(TD.valueOf(type));
        }
    }

    private static boolean checkNotAbstract(ObjectType type) {
        JavaClass javaClass = TD.getValidJavaClass(type.getClassName());
        return javaClass == null || !javaClass.isAbstract();
    }

    private static String getMemberText(MethodTypeDescription mtd) {
        return (mtd.getParentRef() != null ? mtd.getParentRef().getText() + "." : "") + mtd.getText();
    }

    private void addConstantTrace(@NotNull Node location, String ... messages) throws CodeGenerationException {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/compiler/JVMByteCodeGenerator.addConstantTrace must not be null");
        }
        if (messages == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/compiler/JVMByteCodeGenerator.addConstantTrace must not be null");
        }
        if (this.isTraceEnabled(location) && !location.getCurrentMember().isTooLong()) {
            this.generateTrace(location, messages);
        }
    }

    private boolean isTraceEnabled(Node location) {
        return location.getCompilerDirective(256);
    }

    private void generateTrace(Node location, String ... messages) {
        FieldD traceField = FieldD.createStatic(this.getClassCode().getType(), "$TRACE", (Type)TD.TRACE);
        this.cb.beginIf();
        this.cb.loadField(traceField);
        this.cb.invoke(MDKit.TRACE_ENABLED);
        this.cb.addThen();
        this.cb.loadField(traceField);
        this.cb.newObject((Type)TD.STRING_BUILDER);
        this.cb.dup();
        this.cb.loadConstant(location.getCurrentMember().getText());
        this.cb.invokeConstructor(TD.STRING_BUILDER, (Type)TD.STRING);
        this.cb.loadConstant(" [" + location.getLine() + ":" + location.getColumn() + "]");
        this.cb.invoke(MDKit.STRINGBUILDER_APPEND);
        for (String message : messages) {
            this.cb.loadConstant(" ");
            this.cb.invoke(MDKit.STRINGBUILDER_APPEND);
            this.cb.loadConstant(message);
            this.cb.invoke(MDKit.STRINGBUILDER_APPEND);
        }
        this.cb.invoke(MDKit.STRINGBUILDER_TO_STRING);
        this.cb.invoke(MDKit.TRACE_LOG);
        this.cb.endIf();
    }

    private void genValueAndDup(Node value, boolean expression, int xn) throws CodeGenerationException {
        if (expression) {
            int pos = this.scheduleDup(xn);
            value.gen(this);
            this.emitDup(pos);
        } else {
            value.gen(this);
        }
    }

    private void emitDup(int pos) {
        int index = this.dupStack.size() - 1;
        if (pos == -1 || pos == index) {
            this.cb.dup(this.dupStack.remove(index));
        }
    }

    private int scheduleDup(int i) {
        this.dupStack.add(i);
        return this.dupStack.size() - 1;
    }

    private LocalVariable createIndexVariable(boolean selectStatement, Symbol id) {
        TypeDescription description = id.getType();
        ObjectType type = selectStatement ? TD.QUERY_OBJECT : TD.valueOf(description);
        LocalVariable index = this.cb.createLocalVariable(id.getName(), (Type)type);
        id.setLocalVariable(index);
        return index;
    }

    private JVMCodeBuilder createMethod(Method method, String suffix) {
        Object exceptions;
        boolean isInnerConstructor;
        MethodTypeDescription mtd = method.getMethodType();
        LinkedList<Type> argumentsList = new LinkedList<Type>();
        LinkedList<String> argumentNamesList = new LinkedList<String>();
        TypeDescription parentType = mtd.getParent();
        boolean bl = isInnerConstructor = method.isConstructor() && parentType.isInnerType();
        if (isInnerConstructor) {
            argumentsList.add(TD.valueOf(parentType.getParent()));
            argumentNamesList.add("parent");
        }
        for (int i = 0; i < mtd.getArgumentCount(); ++i) {
            Argument arg = mtd.getArgument(i);
            argumentsList.add(TD.valueOf(method.argumentType(arg)));
            argumentNamesList.add(arg.getName());
        }
        Type[] arguments = argumentsList.toArray(new Type[argumentsList.size()]);
        String[] argumentNames = argumentNamesList.toArray(new String[argumentNamesList.size()]);
        if (mtd.isConstructor()) {
            JVMCodeBuilder cb = this.classCode.addConstructor(method.getAccessModifiers(), arguments, argumentNames);
            cb.loadThis();
            cb.invokeSuperConstructor(Type.NO_ARGS);
            return cb;
        }
        TypeDescription type = mtd.getResultType();
        Type returnType = TD.valueOf(type.isInvokeable() ? Invokeable.class.getName() : mtd.getResultArgument().getJavaType());
        String methodName = method.getFullName() + suffix;
        if (!method.isOverride() || mtd.getParent().isInvokeable()) {
            exceptions = new Type[]{TD.THROWABLE};
        } else {
            int count = mtd.getExceptionCount();
            if (count > 0) {
                exceptions = new Type[count];
                for (int i = 0; i < count; ++i) {
                    exceptions[i] = TD.valueOf(mtd.getException(i));
                }
            } else {
                exceptions = method.overridesFuegoObject() ? new Type[]{TD.THROWABLE} : null;
            }
        }
        JVMCodeBuilder result = this.classCode.addMethod(method.getAccessModifiers(), returnType, methodName, arguments, argumentNames, (Type[])exceptions);
        SourceCode sourceCode = method.getSourceCode();
        if (sourceCode != null) {
            result.addSourceCode(sourceCode.asString());
        }
        return result;
    }

    private void debugAssignment(Node variable, Node value) {
        if (this.testMode) {
            Type type = this.cb.stackTop();
            this.cb.loadConstant(variable.getLine());
            this.cb.loadConstant(variable.toString());
            if (!type.equals(Type.NULL)) {
                TypeDescription td = value.getTypeDescription();
                this.cb.invoke(MDKit.debug(td.getJavaType()));
                this.cb.convert(type);
            } else {
                this.cb.invoke(MDKit.debug(null));
            }
        }
    }

    private void forIn(LoopStatement node, boolean values) throws CodeGenerationException {
        Node array = node.getArray();
        array.setMustClone(false);
        if (node.isArray() && !node.isIteratorUsed()) {
            this.forInArray(node, array, values);
        } else {
            this.forInIterable(node, array, values);
        }
    }

    private void forInArray(LoopStatement node, Node array, boolean values) throws CodeGenerationException {
        Symbol id = node.getIdentifier();
        LocalVariable element = id.getLocalVariable();
        LocalVariable index = values ? this.cb.createLocalVariable("index", TD.INT) : element;
        this.cb.loadConstant(0);
        this.cb.storeLocal(index);
        LocalVariable arrayVar = null;
        if (array instanceof ArrayConst) {
            this.cb.beginWhile();
            this.cb.loadLocal(index);
            this.cb.loadConstant(((ArrayConst)array).length());
        } else {
            array.gen(this);
            if (values) {
                arrayVar = this.cb.createLocalVariable("array", array.getTD());
                this.cb.dup();
                this.cb.storeLocal(arrayVar);
            }
            this.cb.invoke(MDKit.COLLECTION_SIZE);
            LocalVariable length = this.cb.createLocalVariable("length", TD.INT);
            this.cb.storeLocal(length);
            this.cb.beginWhile();
            this.cb.loadLocal(index);
            this.cb.loadLocal(length);
        }
        this.cb.addWhileBody(OpCode.IFLT);
        if (values) {
            if (arrayVar == null) {
                array.gen(this);
            } else {
                this.cb.loadLocal(arrayVar);
            }
            this.cb.loadLocal(index);
            if (array.getTypeDescription().isPrimitive()) {
                this.cb.arrayLoad();
            } else {
                this.cb.invoke(MDKit.ARRAY_GET);
                this.cb.convert(element.getType());
            }
            this.cb.storeLocal(element);
        }
        this.loopBody(node);
        this.cb.inc(index, 1);
        if (node instanceof For) {
            this.debugVar(index, node, id.getName(), "int");
        }
        this.cb.endWhile();
    }

    private void debugVar(LocalVariable index, LoopStatement node, String name, String type) {
        if (this.testMode) {
            this.cb.loadLocal(index);
            this.cb.loadConstant(node.getLine());
            this.cb.loadConstant(name);
            this.cb.invoke(MDKit.debug(type));
            this.cb.pop();
        }
    }

    private void forInIterable(LoopStatement node, Node array, boolean values) throws CodeGenerationException {
        array.gen(this);
        if (!node.hasFilteredIterable()) {
            this.cb.invoke(values ? MDKit.COLLECTION_ITERATOR : MDKit.KEYSET_ITERATOR);
        } else {
            this.cb.loadConstant(node.getFilter());
            this.generateParameters(node.getParameters());
            this.cb.invoke(MDKit.FILTERED_ITERATOR);
        }
        Symbol id = node.getIdentifier();
        LocalVariable iterator = this.cb.createLocalVariable(id.getName() + "Iterator", (Type)TD.ITERATOR);
        if (id.getTarget() != null) {
            id.getTarget().setLocalVariable(iterator);
        }
        this.cb.storeLocal(iterator);
        this.cb.beginWhile();
        this.cb.loadLocal(iterator);
        this.cb.invoke(MDKit.HASNEXT);
        this.cb.addWhileBody();
        this.cb.loadLocal(iterator);
        this.cb.invoke(MDKit.NEXT);
        LocalVariable element = id.getLocalVariable();
        this.cb.convert(element.getType());
        this.cb.storeLocal(element);
        this.loopBody(node);
        this.cb.endWhile();
    }

    private void generateArrayMetadata(TypeDescription type, String name, ModSet modifiers) {
        if (!modifiers.has(Mod.STATIC) && !type.isPrimitive()) {
            TypeDescription elementType;
            if (type.isMap()) {
                this.classCode.addField(Mod.PRIVATE.STATIC(), TD.valueOf(type.getIndexType()), name + "_INDEX_");
            }
            if ((elementType = type.getElementType()) != null) {
                this.classCode.addField(Mod.PRIVATE.STATIC(), TD.valueOf(type.getElementType()), name + "_ELEMENT_");
            }
        }
    }

    private void generateBlockFooter(LocalVariable clientAvailable) {
        if (clientAvailable != null) {
            this.cb.addFinally();
            this.cb.loadLocal(clientAvailable);
            this.cb.invoke(MDKit.ENABLE_CLIENT);
            this.cb.pop();
            this.cb.endTry();
        }
    }

    private LocalVariable generateBlockHeader(Node node) {
        LocalVariable result = null;
        if (node instanceof Method) {
            TypeDescription thisType;
            Method method = (Method)node;
            if (method instanceof ObjectConstructor && (thisType = method.getMethodType().getParent()).isInnerType()) {
                this.cb.loadThis();
                this.cb.loadArgument(0);
                this.cb.storeField(FieldD.parent(thisType));
            }
            boolean clientAvailable = Modifier.isClientAvailable(method.getModifiers());
            boolean disableClient = Modifier.isDisableClient(method.getModifiers());
            if (clientAvailable || disableClient) {
                assert (!clientAvailable || !disableClient) : "Inconsistent modifiers for client availability";
                this.cb.loadConstant(clientAvailable);
                this.cb.invoke(MDKit.ENABLE_CLIENT);
                result = this.cb.createLocalVariable("$clientAvailable", TD.BOOLEAN);
                this.cb.storeLocal(result);
                this.cb.beginTry(true);
            }
        }
        return result;
    }

    private void generateOnClause(On onClause, LocalVariable throwable) throws CodeGenerationException {
        this.cb.loadLocal(throwable);
        this.cb.loadConstant(onClause.getExceptionComponentType());
        this.cb.loadConstant(onClause.getExceptionTypeSignature());
        this.cb.invoke(MDKit.MD_CILUTILS_INSTANCEOF);
        this.cb.addThen();
        this.cb.loadLocal(throwable);
        this.generate(onClause.getExceptionClass());
        this.cb.invoke(MDKit.MD_CILUTILS_EXCEPTION);
        Type exceptionType = TD.valueOf(onClause.getExceptionType());
        Symbol exception = onClause.getException();
        LocalVariable e = this.cb.createLocalVariable(exception.getName(), exceptionType);
        exception.setLocalVariable(e);
        this.cb.convert(exceptionType);
        this.cb.storeLocal(e);
        exception.setLocalVariable(e);
        onClause.getOp3().gen(this);
    }

    private void generateParameters(List parameters) throws CodeGenerationException {
        int size;
        int n = size = parameters != null ? parameters.size() : 0;
        if (size == 0) {
            this.cb.loadNull();
        } else {
            this.cb.createArray(TD.OBJECT_ARRAY, size);
            for (int i = 0; i < size; ++i) {
                Node current = (Node)parameters.get(i);
                this.cb.dup();
                this.cb.loadConstant(i);
                current.gen(this);
                TypeDescription currentType = current.getTypeDescription();
                if (currentType.isPrimitive()) {
                    ((JVMConversionGenerator)this.conversionGenerator).generateBox(currentType, currentType.primitiveEquivalent(true));
                }
                this.cb.arrayStore();
            }
        }
    }

    private void generatePredicate(Node node) throws CodeGenerationException {
        Node next = node.getNext();
        if (next == null) {
            node.gen(this);
        } else {
            this.cb.beginLogical("||");
            node.gen(this);
            this.cb.logicalOperand();
            this.generatePredicate(next);
            this.cb.endLogical();
        }
    }

    private FieldD getBitSetField(CodeKit.BitSetOper n) {
        return FieldD.create(this.cb.getType(), n.getFieldName(), TD.LONG);
    }

    private boolean initialize(Declaration declaration) throws CodeGenerationException {
        boolean doInitialize;
        FlowContext.Variable var = declaration.getVariable();
        boolean bl = doInitialize = var != null && var.needsInitialization();
        if (doInitialize) {
            declaration.getInit().gen(this);
        }
        return doInitialize;
    }

    private void load(Symbol target) {
        if (target.isThis()) {
            this.cb.loadThis();
        } else if (target.isSuper()) {
            this.cb.loadSuper(TD.valueOf(target.getType()));
        } else if (target.isInnerClassParentReference()) {
            this.cb.loadThis();
            this.cb.loadField(FieldD.create(this.cb.getType(), "this_0", TD.valueOf(target.getType())));
        } else if (target.isArgument() && !target.getArgument().isReturnValue() && target.getLocalVariable() == null) {
            this.cb.loadArgument(target.getArgument().getNumber());
        } else {
            LocalVariable var = target.getLocalVariable();
            if (var == null) {
                if (target.getReplacement() != null) {
                    var = target.getReplacement().getLocalVariable();
                }
                if (var == null) {
                    throw new IllegalStateException("Not local variable for symbol: " + target);
                }
            }
            this.cb.loadLocal(var);
        }
    }

    private void loadBindings(Invoke invoke) throws CodeGenerationException {
        if (!invoke.hasInputArgs()) {
            this.cb.loadNull();
        } else {
            Args inputArgs = invoke.getInputArgs();
            this.cb.createArray(TD.OBJECT_ARRAY, 2 * inputArgs.getArgCount());
            String[] argSignatures = inputArgs.getBindings();
            Node n = inputArgs.getFirst();
            for (int i = 0; i < argSignatures.length; ++i) {
                String signature = argSignatures[i];
                this.cb.dup();
                this.cb.loadConstant(i);
                if (signature != null) {
                    this.cb.loadConstant(signature);
                } else {
                    Arg arg = (Arg)n;
                    arg.getValue().gen(this);
                    this.cb.invoke(MDKit.MD_CREATE_ANY_HOLDER);
                }
                this.cb.arrayStore();
                if (i % 2 != 0) continue;
                n = n.getNext();
            }
        }
    }

    private void loadInputArguments(Invoke invoke) throws CodeGenerationException {
        if (!invoke.hasInputArgs()) {
            this.cb.loadNull();
        } else {
            Args inputArgs = invoke.getInputArgs();
            this.cb.createArray(TD.OBJECT_ARRAY, 2 * inputArgs.getArgCount());
            int index = 0;
            for (Node n = inputArgs.getFirst(); n != null; n = n.getNext()) {
                Arg arg = (Arg)n;
                this.cb.dup();
                this.cb.loadConstant(index++);
                this.cb.loadConstant(arg.getWriteSignature(invoke.getObjType()));
                this.cb.arrayStore();
                this.cb.dup();
                this.cb.loadConstant(index++);
                arg.gen(this);
                this.cb.arrayStore();
            }
        }
    }

    private boolean loadObjectReference(MemberAccess memberAccess) throws CodeGenerationException {
        Node object = memberAccess.getObject();
        TypeDescription objType = memberAccess.getObjType();
        MethodTypeDescription member = memberAccess.getMemberType();
        boolean delegationInClient = memberAccess.isDelegationInClient();
        return this.loadObjectReference(object, objType, member, delegationInClient);
    }

    private boolean loadObjectReference(Node object, TypeDescription objType, MethodTypeDescription member, boolean delegationInClient) throws CodeGenerationException {
        boolean callToParent = MemberAccess.isCallToParent(objType, member, object);
        if (callToParent) {
            this.cb.loadThis();
            this.cb.loadField(FieldD.parent(objType));
        } else if (delegationInClient) {
            boolean delegateBySignature = MemberAccess.isDelegatedBySignature(member.getSignature(), objType);
            if (!delegateBySignature && !member.isStatic()) {
                Type memberType = TD.valueOf(member.getParent());
                assert (memberType instanceof ObjectType);
                ObjectType ot = (ObjectType)memberType;
                this.cb.newObject((Type)ot);
                this.cb.dup();
                object.gen(this);
                this.cb.invokeConstructor(ot, TD.valueOf(objType));
            }
        } else if (!member.isStatic() || objType.isInvokeable() || member.isConstructor()) {
            object.gen(this);
        }
        return callToParent;
    }

    private void loopBody(LoopStatement node) throws CodeGenerationException {
        Node where = node.getWhere();
        if (where == null || node.hasFilteredIterable()) {
            node.getBody().gen(this);
        } else {
            this.cb.beginIf();
            where.gen(this);
            this.cb.addThen();
            node.getBody().gen(this);
            this.cb.endIf();
        }
    }

    private void sqlForEach(ForEach node) throws CodeGenerationException {
        LocalVariable iterator = node.getIdentifier().getLocalVariable();
        node.getSelectStatement().gen(this);
        this.cb.storeLocal(iterator);
        this.cb.beginTry(true);
        this.cb.beginWhile();
        this.cb.loadLocal(iterator);
        this.cb.invoke(MDKit.SQL_QUERY_OBJECT_HASNEXT);
        this.cb.addWhileBody();
        node.getBody().gen(this);
        this.cb.endWhile();
        this.cb.addFinally();
        this.cb.loadLocal(iterator);
        this.cb.convert((Type)TDKit.SQL_OBJECT);
        this.cb.invoke(MDKit.SQL_CLOSE);
        this.cb.endTry();
    }

    private static final class ArithmeticMath {
        private static final MethodD[] METHODS;

        private ArithmeticMath() {
        }

        static {
            ObjectType decimalTD = TD.getObjectType(Decimal.class);
            Type[] argTypes = new Type[]{TD.BIG_DECIMAL, TD.BIG_DECIMAL};
            String[] opmethod = Arithmetic.OPMETHOD;
            MethodD[] methods = new MethodD[opmethod.length];
            METHODS = methods;
            for (int i = 0; i < methods.length; ++i) {
                try {
                    methods[i] = MethodD.createStatic((Type)TD.BIG_DECIMAL, decimalTD, opmethod[i], argTypes);
                    continue;
                }
                catch (CodeGenerationException e) {
                    throw new Error(e);
                }
            }
        }
    }
}

