/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.compiler.BoolConst;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.CompilerException;
import oracle.bpm.compiler.Equality;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.IllegalTypeException;
import oracle.bpm.compiler.MemberReference;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.Not;
import oracle.bpm.compiler.NullConst;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.Ternary;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.TypeSpec;
import oracle.bpm.compiler.msg.CompilerMsg;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.RuntimeCILExecutionException;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;

public class Is
extends Ternary {
    private boolean negative;
    private TypeDescription targetType = null;
    static final long serialVersionUID = -8877288984020257197L;
    static final long serialCheck = -2853344040348001091L;

    public Is(Token t) {
        super(t);
    }

    @Override
    public String getText() {
        return "is" + (this.negative ? " not" : "") + (this.targetType == null ? "" : " " + this.targetType);
    }

    @Override
    public Node negate() {
        this.negative = !this.negative;
        return this;
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this, this.getOp1(), this.targetType, this.negative);
    }

    static Is create(Node var, Node type) {
        Is is = new Is(null);
        is.copyParentFrom(var);
        is.setFirst(var);
        var.setNext(type);
        type.setNext(null);
        is.initialize(var);
        return is;
    }

    static Node notNull(Node var) {
        return Is.create(var, new NullConst(var)).negate();
    }

    static Is nullValue(Node var) {
        return Is.create(var, new NullConst(var));
    }

    static boolean run(TypeDescription type, Object op) {
        boolean result;
        if (type == TypeFactory.getNull()) {
            result = op == null;
        } else if (op == null) {
            result = false;
        } else {
            if (op instanceof RuntimeCILExecutionException) {
                op = ((RuntimeCILExecutionException)op).getObject();
            }
            if (op instanceof Invokeable) {
                Class<?> typeJavaClass;
                String signature;
                Invokeable inv = (Invokeable)op;
                String compType = type.asObject().getComponentType();
                result = inv.isInstanceOf(compType, signature = type.getSignature());
                if (!result && (typeJavaClass = type.getJavaClass()) != null) {
                    result = typeJavaClass.isAssignableFrom(inv.getTarget().getClass());
                }
            } else {
                Class<?> opClass = op.getClass();
                Class<?> isTypeClass = type.primitiveEquivalent(false).getJavaClass();
                result = isTypeClass.isAssignableFrom(opClass);
            }
        }
        return result;
    }

    boolean isNegative() {
        return this.negative;
    }

    TypeDescription getTargetType() {
        return this.targetType;
    }

    @Override
    Node checkType() throws TypeException {
        boolean mustOptimize;
        if (this.targetType != null) {
            return this;
        }
        Node result = this;
        Node op = this.getOp1();
        Node op2 = this.getOp2();
        Node op3 = this.getOp3();
        op = op.checkType();
        if (op3 != null) {
            boolean condition = op2 instanceof Not;
            assert (condition);
            this.negative = true;
            op2 = op3;
        }
        this.setTypeDescription(TypeFactory.getPrimitiveBool());
        TypeDescription opType = op.getTypeDescription();
        this.targetType = op2.getTypeDescription();
        boolean isNull = this.targetType == TypeFactory.getNull();
        boolean bl = mustOptimize = !this.isGeneratingSource() && opType.isPrimitive();
        if (isNull) {
            this.setParametric(false);
            if (mustOptimize && !opType.isArray()) {
                this.reportWarning(new CompilerException(this, CompilerMsg.NULL_PRIMITIVE(op.getFirst().getText())));
                result = new BoolConst(false);
            }
        } else {
            try {
                op2 = op2.checkType();
                this.targetType = op2.getTypeDescription();
            }
            catch (TypeException e) {
                try {
                    if (opType.isEnum()) {
                        MemberReference ref = new MemberReference(opType.getText(), op2.getFirst().getText());
                        result = this.negative ? Equality.notEquals(op, ref) : Equality.equals(op, ref);
                        result.setParent(this);
                        return result.checkType();
                    }
                    result = new MemberReference(op, op2);
                    result.initialize(this);
                    result.setParent(this);
                    result = result.checkType();
                    if (result.getKind() == 1) {
                        return result;
                    }
                }
                catch (TypeException ignore) {
                    // empty catch block
                }
                throw e;
            }
            if (TypeSpec.isModule(this.targetType)) {
                throw new IllegalTypeException((Node)this, this.targetType.getText());
            }
            if (opType.isAny()) {
                if (this.targetType.isPrimitive()) {
                    this.targetType = this.targetType.primitiveEquivalent(false);
                }
            } else if (mustOptimize) {
                if (opType.getKind() != this.targetType.getKind()) {
                    result = new BoolConst(false);
                } else if (opType.isPredefined()) {
                    result = new BoolConst(true);
                } else if (opType.isStrictSubtype(this.targetType)) {
                    result = new BoolConst(true);
                } else if (!this.targetType.isStrictSubtype(opType)) {
                    result = new BoolConst(false);
                }
            }
        }
        if (!isNull) {
            this.setOperands(op, op2);
        } else {
            this.setOperand(op);
        }
        if (result != this) {
            result.initialize(this);
        }
        if (mustOptimize && result.isConstant() && this.negative) {
            result = result.negate();
        }
        return result;
    }

    @Override
    void generate(CodeGenerator codeGenerator) throws CodeGenerationException {
        codeGenerator.generate(this);
    }

    @Override
    void generateSQLCode(StringBuffer sql) {
        if (this.checkParameter(sql)) {
            return;
        }
        if (this.targetType == TypeFactory.getNull()) {
            this.getOp1().generateSQLCode(sql);
            sql.append(this.negative ? " is not null" : " is null");
        } else {
            sql.append(" ? ");
        }
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        Object op = this.getOp1().value(rm);
        boolean result = Is.run(this.targetType, op);
        return this.negative ? !result : result;
    }
}

