/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import oracle.bpm.compiler.CompilerException;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.Declaration;
import oracle.bpm.compiler.LocalVar;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.msg.CompilerMsg;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.util.FixOption;

public class InvalidAssignmentException
extends TypeException {
    static final long serialVersionUID = -4547053449804354666L;
    static final long serialCheck = 3403155547682253610L;

    public InvalidAssignmentException(Node n) {
        super(n, CompilerMsg.INVAUTODECL);
    }

    public InvalidAssignmentException(Node n, String lvalue) {
        super(n, CompilerMsg.INVALID_LVALUE(lvalue));
    }

    public InvalidAssignmentException(Node node, Node source) {
        super(node);
        String stype = source.getKind() != -1 ? InvalidAssignmentException.text(source.getTypeDescription(), node) : source.getText();
        this.setKey(CompilerMsg.INVFUNASSIG(stype));
    }

    public InvalidAssignmentException(Node node, TypeDescription source, TypeDescription target) {
        super(node, source == null ? CompilerMsg.INVAUTODECL : CompilerMsg.INVASSIG(InvalidAssignmentException.text(source, node), InvalidAssignmentException.text(target, node)));
    }

    public InvalidAssignmentException(Node n, Node source, Node target) {
        super(n);
        if (source == null) {
            this.setKey(CompilerMsg.INVAUTODECL);
        } else {
            String stype = source.getKind() != -1 ? InvalidAssignmentException.text(source.getTypeDescription(), this.node) : source.getText();
            String ttype = target.getKind() != -1 ? InvalidAssignmentException.text(target.getTypeDescription(), this.node) : target.getText();
            this.setKey(CompilerMsg.INVASSIG(stype, ttype));
            if (target.getKind() != -1) {
                TypeDescription targetType = target.getTypeDescription();
                if (source.getKind() != -1 && target instanceof LocalVar) {
                    String id = target.getText();
                    Declaration decl = n.getCurrentDoBlock().findDeclaration(id);
                    if (decl != null) {
                        this.addFixOption(new ChangeType(decl, source.getTypeDescription()));
                    }
                }
                this.addFixOption(new CastExpr(source, targetType));
            }
        }
    }

    class ChangeType
    extends FixOption {
        private Declaration decl;
        private TypeDescription newType;

        public ChangeType(Declaration decl, TypeDescription newType) {
            super("Change type of '" + decl.getName() + "' to '" + CompilerException.text(newType, InvalidAssignmentException.this.node) + "'");
            this.decl = decl;
            this.newType = newType;
        }

        @Override
        public void fix() throws CompilerException {
            this.decl.changeType(this.newType);
            InvalidAssignmentException.this.getNode().getCurrentMember().rewrite();
        }
    }

    class CastExpr
    extends FixOption {
        private Node expr;
        private TypeDescription targetType;

        CastExpr(Node expr, TypeDescription targetType) {
            super("Cast expresion to '" + CompilerException.text(targetType, InvalidAssignmentException.this.node) + "'");
            this.expr = expr;
            this.targetType = targetType;
        }

        @Override
        public void fix() throws CompilerException {
            Node castedExpr = Conversion.Cast.create(Node.deepCopy(this.expr), this.targetType).checkType(this.targetType);
            this.expr.replace(castedExpr);
            InvalidAssignmentException.this.getNode().getCurrentMember().rewrite();
        }
    }
}

