/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.ConstFormatException;
import oracle.bpm.compiler.ConstGenerator;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.IntervalFormatException;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.filter.Operation;

public final class IntervalConst
extends Const {
    Interval value;
    static final long serialVersionUID = -6837583499273112585L;
    static final long serialCheck = -504149826421222490L;

    public IntervalConst(Token t) {
        this(t, t.getText());
    }

    IntervalConst(String txt) {
        this(null, txt);
    }

    IntervalConst(Interval value, Node original) {
        this(null, value);
        this.initialize(original);
    }

    private IntervalConst(Token t, String txt) {
        super(t, TypeFactory.getInterval());
        if (txt == null || txt.equals("")) {
            this.value = Interval.ZERO;
        } else {
            try {
                this.value = Interval.valueOf(txt);
            }
            catch (IntervalFormatException e) {
                this.exception = new ConstFormatException((Node)this, e);
                this.value = Interval.ZERO;
            }
        }
    }

    private IntervalConst(Token t, Interval value) {
        super(t, TypeFactory.getInterval());
        this.value = value;
    }

    public static IntervalConst create(Interval value) {
        return new IntervalConst(null, value);
    }

    @Override
    public String getText() {
        return this.value.toString();
    }

    @Override
    public Node negate() {
        this.value = this.value.negate();
        return this;
    }

    @Override
    public String getSyntheticName() {
        return IntervalConst.createSyntheticNameFromType(this.getTypeDescription(), String.valueOf(this.value));
    }

    @Override
    public void generate(ConstGenerator cg) throws CodeGenerationException {
        cg.generate(this);
    }

    @Override
    public String toString() {
        return super.toString() + "'" + this.getText() + "'";
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    public Interval getValue() {
        return this.value;
    }

    @Override
    Operation getOperationTree() {
        if (this.isParameter()) {
            return new Operation(0, "?", null);
        }
        return new Operation(24, null, null, this.getText());
    }

    @Override
    int compare(Node b) {
        return this.value.compareTo(((IntervalConst)b).value);
    }

    IntervalConst compute(int op, IntervalConst b) {
        this.value = op == 1 ? this.value.add(b.value) : this.value.sub(b.value);
        return this;
    }

    boolean equals(Node b) {
        return b instanceof IntervalConst && this.value.equals(((IntervalConst)b).value);
    }

    @Override
    Object run(RunningMonitor rm) {
        return this.value;
    }
}

