/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.ConstGenerator;
import oracle.bpm.compiler.ConversionException;
import oracle.bpm.compiler.DivideByZeroException;
import oracle.bpm.compiler.EnumConst;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.InvalidNumberException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.EnumTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.filter.Operation;

public class IntConst
extends Const {
    long value;
    static final long serialVersionUID = -7938306778956718875L;
    static final long serialCheck = 6077576678819314185L;

    public IntConst(Token t) {
        this(t, t.getText(), TypeFactory.getNone());
    }

    IntConst(long value) {
        this(null, value, TypeFactory.getNone());
    }

    IntConst(String txt) {
        this(txt, TypeFactory.getNone());
    }

    IntConst(long value, TypeDescription expectedType) {
        this(null, value, expectedType);
    }

    IntConst(long value, Node orig) {
        this(value);
        this.initialize(orig);
    }

    IntConst(String txt, TypeDescription type) {
        this(null, txt, type);
    }

    private IntConst(Token t, long value, TypeDescription expectedType) {
        super(t, expectedType);
        this.value = value;
        this.setTypeDescription(this.typeFor(this.value));
        this.setPrimitive(this.getTypeDescription().isPrimitive());
        this.checkRange(expectedType, value);
    }

    private IntConst(Token t, String txt, TypeDescription expectedType) {
        this(t, 0L, expectedType);
        try {
            int base;
            if (txt.equals("")) {
                base = 10;
                txt = "0";
            } else if (txt.charAt(0) != '0' || txt.charAt(0) == '0' && txt.length() == 1) {
                base = 10;
            } else if (txt.charAt(1) == 'x' || txt.charAt(1) == 'X') {
                base = 16;
                txt = txt.substring(2);
            } else {
                base = 10;
            }
            this.value = txt.startsWith("-") ? Long.parseLong(txt, base) : -Long.parseLong("-" + txt, base);
            this.setTypeDescription(this.typeFor(this.value));
            this.setPrimitive(this.getTypeDescription().isPrimitive());
            this.checkRange(expectedType, this.value);
        }
        catch (StringIndexOutOfBoundsException e) {
            this.value = 0L;
            this.exception = new InvalidNumberException((Node)this, txt);
        }
        catch (NumberFormatException e) {
            this.value = 0L;
            this.exception = new InvalidNumberException((Node)this, txt);
        }
    }

    public static Number createValue(long value, TypeDescription type) {
        Number result = null;
        int len = type.getLength();
        result = len <= 8 ? (Number)((byte)value) : (Number)(len <= 16 ? (Number)((short)value) : (Number)(len <= 32 ? (Number)((int)value) : (Number)value));
        return result;
    }

    @Override
    public Object getPrimitiveValue() {
        return this.isPrimitive() ? (Number)IntConst.createValue(this.value, this.getTypeDescription()) : (Number)null;
    }

    @Override
    public String getSyntheticName() {
        return IntConst.createSyntheticNameFromType(this.getTypeDescription(), String.valueOf(this.value));
    }

    @Override
    public String getText() {
        return Long.toString(this.value);
    }

    @Override
    public final Node negate() {
        this.value = -this.value;
        return this;
    }

    @Override
    public void generate(ConstGenerator cg) {
        cg.generate(this);
    }

    @Override
    public String toString() {
        TypeDescription typeDescription = this.getTypeDescription();
        return typeDescription.getText() + "-" + super.toString() + (typeDescription.isPrimitive() ? this.getText() : "{" + this.getText() + "}");
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    final boolean equals(Node b) {
        return b instanceof IntConst ? this.value == ((IntConst)b).value : false;
    }

    @Override
    boolean isCollectable() {
        return !this.getTypeDescription().isPrimitive();
    }

    @Override
    Operation getOperationTree() {
        if (this.isParameter()) {
            return new Operation(0, "?", null);
        }
        return new Operation(20, null, null, this.getText());
    }

    long getValue() {
        return this.value;
    }

    @Override
    int compare(Node b) {
        long lb = ((IntConst)b).value;
        return this.value < lb ? -1 : (this.value > lb ? 1 : 0);
    }

    @Override
    final Const compute(int op, Node bNode) {
        long b = ((IntConst)bNode).value;
        switch (op) {
            case 0: {
                this.value += b;
                break;
            }
            case 1: {
                this.value -= b;
                break;
            }
            case 2: {
                this.value *= b;
                break;
            }
            case 3: {
                if (b == 0L) {
                    this.reportError(new DivideByZeroException(bNode));
                    this.value = 0L;
                    break;
                }
                this.value /= b;
                break;
            }
            case 4: {
                this.value %= b;
            }
        }
        return this;
    }

    @Override
    Const convertTo(TypeDescription type) throws TypeException {
        switch (type.getKind()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return IntConst.valueOf(this.getText(), type, this);
            }
            case 17: {
                EnumTypeDescription enumType = (EnumTypeDescription)type;
                int length = enumType.getMemberCount();
                if (enumType.isSequential() && this.value >= 0L && this.value < (long)length) {
                    return new EnumConst(enumType, enumType.getMemberType((int)this.value).asAttribute(), this);
                }
                for (int i = 0; i < length; ++i) {
                    if ((long)enumType.getValue(i) != this.value) continue;
                    return new EnumConst(enumType, enumType.getMemberType(i).asAttribute(), this);
                }
                throw new ConversionException((Node)this, type, this.value);
            }
            case 10: 
            case 11: {
                return this.isPrimitive() ? IntConst.valueOf(this.getText(), this.getTypeDescription().primitiveEquivalent(false), this) : this;
            }
        }
        throw new ConversionException((Node)this, this.getTypeDescription(), type);
    }

    @Override
    void generateSQLCode(StringBuffer sql) {
        sql.append(this.isParameter() ? " ? " : this.getText());
    }

    int lengthForValue(long value) {
        int length = value <= 127L && value >= -128L ? 8 : (value <= 32767L && value >= -32768L ? 16 : (value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE ? 32 : 64));
        return length;
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        return IntConst.createValue(this.value, this.getTypeDescription());
    }

    TypeDescription typeFor(long value) {
        return value <= Integer.MAX_VALUE ? TypeFactory.getPrimitiveInt(32) : TypeFactory.getPrimitiveInt(64);
    }

    private void checkRange(TypeDescription expectedType, long value) {
        if (expectedType.getKind() != -1) {
            int expectedLength = expectedType.getLength();
            if (expectedLength != -1 && this.lengthForValue(value) > expectedLength) {
                long modulus = value % (Long.parseLong(expectedType.getMaxValue()) + 1L);
                this.value = value > 0L ? Long.parseLong(expectedType.getMinValue()) + modulus : Long.parseLong(expectedType.getMaxValue()) + (modulus + 1L);
            }
            this.setTypeDescription(expectedType);
        }
    }
}

