/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import java.util.List;
import java.util.Set;
import oracle.bpm.compiler.CollectionPool;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.DuplicatedColumnException;
import oracle.bpm.compiler.InvalidAssignmentException;
import oracle.bpm.compiler.MixedTablesException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NodeIterator;
import oracle.bpm.compiler.SQLStatement;
import oracle.bpm.compiler.Select;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.Tables;
import oracle.bpm.compiler.TooFewValuesException;
import oracle.bpm.compiler.TooManyValuesException;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.sql.ColumnReference;
import oracle.bpm.type.TypeFactory;

public class Insert
extends SQLStatement {
    private Columns columns;
    private Tables table;
    private Node values;
    static final long serialVersionUID = -7136677306508986924L;
    static final long serialCheck = 1320494735088800800L;

    public Insert(Token t) {
        super(t);
    }

    Insert() {
    }

    @Override
    public String getText() {
        return "insert";
    }

    @Override
    public void generate(SourceGenerator cw) {
        cw.generate(this);
    }

    Node getTable() {
        return this.getOp1();
    }

    @Override
    Node checkType() throws TypeException {
        assert (this.getScope().isSQLScope());
        if (this.getKind() != -1) {
            return this;
        }
        this.table = this.checkTable(this.removeFirst());
        if (this.getFirst() instanceof Columns) {
            this.columns = (Columns)this.getFirst();
            this.values = this.columns.getNext();
        } else {
            this.values = this.getFirst();
        }
        ColumnReference[] columnTypes = this.table.getColumnTypes();
        if (this.columns != null) {
            this.columns.checkType();
            columnTypes = this.columns.getColumnTypes();
        }
        if (this.values instanceof Values) {
            ((Values)this.values).checkType(columnTypes);
        } else if (this.values instanceof Select) {
            Select select = (Select)this.values;
            this.values = select.checkType(columnTypes);
            String tableAbstractConfigName = this.getAbstractConfigName();
            String selectAbstractConfigName = select.getAbstractConfigName();
            if (selectAbstractConfigName != null && !selectAbstractConfigName.equals(tableAbstractConfigName)) {
                throw new MixedTablesException(this.values);
            }
        }
        this.collectParameters(this.values);
        if (this.columns != null) {
            this.setOperands(this.table, this.columns, this.values);
        } else {
            this.setOperands(this.table, this.values);
        }
        this.setTypeDescription(TypeFactory.getVoid());
        return this;
    }

    @Override
    void generateSQLCode(StringBuffer sql) {
        sql.append("INSERT INTO ");
        this.table.generateSQLCode(sql);
        if (this.columns != null) {
            this.columns.generateSQLCode(sql);
        }
        sql.append(" ");
        this.values.generateSQLCode(sql);
    }

    public static final class Values
    extends Node {
        static final long serialVersionUID = -6016598832727367570L;
        static final long serialCheck = -5286968698216399286L;

        public Values(Token t) {
            super(t);
            this.setParametric(false);
        }

        Values() {
            this((Token)null);
        }

        @Override
        public void generate(SourceGenerator cw) {
            cw.generate(this);
        }

        Node checkType(ColumnReference[] columns) throws TypeException {
            assert (this.getScope().isSQLScope());
            this.getSQLScope().setSQLScopeEnabled(false);
            super.checkType();
            int count = 0;
            NodeIterator values = this.getChildren();
            while (values.hasNext()) {
                Node value = values.next();
                TypeDescription valueType = value.getTypeDescription();
                if (count >= columns.length) {
                    throw new TooManyValuesException(this);
                }
                TypeDescription colType = columns[count].getType();
                if (!colType.isAssignableFrom(valueType)) {
                    throw new InvalidAssignmentException(value, valueType, colType);
                }
                values.replace(Conversion.promote(value, columns[count]));
                ++count;
            }
            if (count < columns.length) {
                throw new TooFewValuesException(this);
            }
            this.getSQLScope().setSQLScopeEnabled(true);
            this.setTypeDescription(TypeFactory.getVoid());
            return this;
        }

        @Override
        void generateSQLCode(StringBuffer sql) {
            sql.append("VALUES (");
            this.generateCommaDelimitedSQL(this.getFirst(), sql);
            sql.append(")");
        }
    }

    public static final class Columns
    extends Node {
        private ColumnReference[] types;
        static final long serialVersionUID = 4507247509028530101L;
        static final long serialCheck = 3619508033068373719L;

        public Columns(Token t) {
            super(t);
        }

        Columns() {
        }

        @Override
        public void generate(SourceGenerator cw) {
            cw.generate(this);
        }

        ColumnReference[] getColumnTypes() {
            return this.types;
        }

        @Override
        Node checkType() throws TypeException {
            this.getSQLScope().setOnlyLocal(true);
            SQLStatement.checkColumns(this);
            Set columnset = CollectionPool.getHashSet();
            List coltypes = CollectionPool.getArrayList();
            NodeIterator columns = this.getChildren();
            while (columns.hasNext()) {
                Node col = columns.next();
                ColumnReference ref = col.getColumnReference();
                if (columnset.contains(ref)) {
                    throw new DuplicatedColumnException(col);
                }
                assert (ref != null) : col.getClassName();
                coltypes.add(ref);
                columnset.add(ref);
            }
            this.types = new ColumnReference[coltypes.size()];
            for (int i = 0; i < this.types.length; ++i) {
                this.types[i] = (ColumnReference)coltypes.get(i);
            }
            this.getSQLScope().setOnlyLocal(false);
            CollectionPool.releaseArrayList(coltypes);
            CollectionPool.releaseHashSet(columnset);
            return this;
        }

        @Override
        void generateSQLCode(StringBuffer sql) {
            sql.append("(");
            this.generateCommaDelimitedSQL(this.getFirst(), sql);
            sql.append(")");
        }
    }
}

