/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.compiler.ArrayConst;
import oracle.bpm.compiler.ArrayReferenceException;
import oracle.bpm.compiler.BoolConst;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.Diadic;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.IncompatibleTypesException;
import oracle.bpm.compiler.InvalidInOperandException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.Not;
import oracle.bpm.compiler.Range;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.StringConst;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.UndefinedVariableException;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.filter.Operation;
import oracle.bpm.util.ArrayUtils;
import oracle.bpm.util.CILUtils;

public class In
extends Diadic {
    private boolean negative = false;
    private boolean range = false;
    static final long serialVersionUID = 73873321569449787L;
    static final long serialCheck = 6079062610360451191L;

    public In(Token t) {
        super(t);
    }

    public In(Node element, Node array) {
        this.setOperands(element, array);
    }

    @Override
    public String getText() {
        return "in";
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this, this.getOp1(), this.getOp2());
    }

    boolean isRange() {
        return this.range;
    }

    @Override
    Operation getOperationTree() {
        return new Operation(71, "in", new Operation[]{this.getOp1().getOperationTree(), this.getOp2().getOperationTree()});
    }

    @Override
    Node checkType() throws TypeException {
        TypeDescription elementType;
        TypeDescription arrayType;
        if (this.getKind() != -1) {
            return this;
        }
        Node result = this;
        this.setTypeDescription(TypeFactory.getPrimitiveBool());
        Node element = this.getOp1();
        Node array = this.getOp2();
        if (this.getScope().isSQLScope()) {
            ArrayConst arrayConst = new ArrayConst();
            if (array instanceof Not) {
                this.negative = true;
                array = array.getNext();
            } else {
                this.negative = false;
            }
            arrayConst.setFirst(array);
            arrayConst.initialize(this);
            arrayConst.setParent(this);
            array = arrayConst;
        }
        try {
            element = element.checkType();
            array = array.checkType(element.getTypeDescription());
        }
        catch (UndefinedVariableException e) {
            try {
                array = array.checkType();
                if (array != null) {
                    arrayType = array.getTypeDescription();
                    elementType = arrayType.getElementType();
                    element = element.checkType(arrayType.isMap() ? arrayType.getIndexType() : elementType);
                }
            }
            catch (UndefinedVariableException e2) {
                this.reportError(e);
                throw e2;
            }
        }
        if (array == null) {
            throw new UndefinedVariableException(this.getOp2());
        }
        if (this.getScope().isSQLScope() && !array.isConstant()) {
            throw new InvalidInOperandException(array);
        }
        this.setOperands(element, array);
        elementType = element.getTypeDescription();
        arrayType = array.getTypeDescription();
        if (elementType.isString() && arrayType.isString()) {
            arrayType = TypeFactory.getArray(arrayType);
        }
        this.range = array instanceof Range;
        if (!arrayType.isIterable() && !this.range) {
            throw new ArrayReferenceException(array, arrayType);
        }
        TypeDescription typeDescription = arrayType = this.range ? array.getTypeDescription() : arrayType.getElementType();
        if (!elementType.equality(arrayType)) {
            throw new IncompatibleTypesException(this, element, array);
        }
        TypeDescription promoted = null;
        if (elementType.isNumber() && arrayType.isNumber() || arrayType.isEnum()) {
            promoted = arrayType.primitiveEquivalent(false);
        }
        if (promoted != null) {
            element = Conversion.promote(element, promoted);
            if (array instanceof Range) {
                ((Range)array).promote(promoted);
            }
        }
        array.setMustClone(false);
        this.setOperands(element, array);
        if (this.range && !element.isParametric()) {
            array.setParametric(false);
        }
        if (!this.isGeneratingSource() && element.isConstant() && array instanceof ArrayConst && array.isConstant()) {
            ArrayConst arr = (ArrayConst)array;
            result = new BoolConst(arr.contains((Const)element));
            result.initialize(element);
        } else if (!this.isGeneratingSource() && element instanceof StringConst && array instanceof StringConst) {
            StringConst c1 = (StringConst)element;
            StringConst c2 = (StringConst)array;
            result = new BoolConst(c1.indexOf(c2) != -1);
            result.initialize(element);
        }
        return result;
    }

    @Override
    void generate(CodeGenerator codeGenerator) throws CodeGenerationException {
        codeGenerator.generate(this);
    }

    @Override
    void generateSQLCode(StringBuffer sql) {
        if (this.checkParameter(sql)) {
            return;
        }
        if (this.negative) {
            sql.append(" NOT ");
        }
        this.getOp1().generateSQLCode(sql);
        sql.append(this.range ? " BETWEEN " : " IN ");
        this.getOp2().generateSQLCode(sql);
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        Object element = this.getOp1().value(rm);
        if (this.range) {
            Object from = this.getOp2().getFirst().value(rm);
            Object to = this.getOp2().getFirst().getNext().value(rm);
            return CILUtils.between((Comparable)element, (Comparable)from, (Comparable)to);
        }
        if (this.getOp2().getKind() == 5) {
            Object text = this.getOp2().value(rm);
            int index = Str.indexOf(text != null ? text.toString() : null, element != null ? element.toString() : null);
            return index != -1;
        }
        Object array = this.getOp2().value(rm);
        return ArrayUtils.contains(array, element);
    }
}

