/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.compiler.Block;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.CodeStyle;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.Exit;
import oracle.bpm.compiler.FlowContext;
import oracle.bpm.compiler.FlowException;
import oracle.bpm.compiler.Logic;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NonBooleanException;
import oracle.bpm.compiler.Not;
import oracle.bpm.compiler.NullStatement;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.Scope;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.Ternary;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.type.TypeFactory;

public class If
extends Ternary {
    static final long serialVersionUID = -4039392617066971685L;
    static final long serialCheck = 1201890755656020944L;

    public If(Token t) {
        super(t);
    }

    If() {
    }

    @Override
    public String getText() {
        return "if";
    }

    public Node getElse() {
        return this.getOp3();
    }

    public Node getPredicate() {
        return this.getOp1();
    }

    public Node getThen() {
        return this.getOp2();
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    public boolean hasElse() {
        return this.getElse() != null && this.getElse() != NullStatement.node;
    }

    @Override
    protected String getStatementSeparator() {
        return "\n";
    }

    @Override
    protected boolean splitToPrint() {
        return true;
    }

    static If condition(Node cond, Node thenBlock) {
        return If.condition(cond, thenBlock, null);
    }

    static If condition(Node cond, Node thenBlock, Node elseBlock) {
        If node = new If();
        node.copyParentFrom(cond);
        thenBlock = Block.ensureIsBlock(thenBlock);
        elseBlock = elseBlock == null ? null : Block.ensureIsBlock(elseBlock);
        node.setOperands(cond, thenBlock, elseBlock);
        return node;
    }

    @Override
    void setScope(Scope scp) {
        this.scope = scp;
        Node pred = this.getPredicate();
        pred.setScope(scp);
        Node thenBlock = this.getThen();
        thenBlock.setScope(scp == null ? scp : scp.makeSubScope());
        if (this.hasElse()) {
            Node elseBlock = this.getElse();
            elseBlock.setScope(scp == null ? scp : scp.makeSubScope());
        }
    }

    Node andCondition(Node condition) {
        Node pred = this.getOp1();
        Node then = this.getOp2();
        pred = Logic.and(pred, condition);
        pred.setNext(then);
        this.setFirst(pred);
        return pred;
    }

    @Override
    FlowContext checkFlow(FlowContext context) throws FlowException {
        this.getOp1().checkFlow(context);
        Node thenBlock = this.getOp2();
        Node elseBlock = this.getOp3();
        elseBlock = elseBlock == null ? NullStatement.node : elseBlock;
        FlowContext elsecontext = context.split();
        thenBlock.checkFlow(context);
        elseBlock.checkFlow(elsecontext);
        boolean thenBreaksFlow = context.breaksFlow();
        boolean elseBreaksFlow = elsecontext.breaksFlow();
        context.join(elsecontext);
        context.breaksFlow(thenBreaksFlow && elseBreaksFlow);
        return context;
    }

    @Override
    Node checkType() throws TypeException {
        Node pred = this.getOp1();
        Node thenBlock = this.getOp2();
        Node elseBlock = this.getOp3();
        pred = pred.checkType(TypeFactory.getBool());
        thenBlock = thenBlock.checkType();
        Node node = elseBlock = elseBlock == null ? NullStatement.node : elseBlock.checkType();
        if (pred.getKind() != 1) {
            this.reportError(new NonBooleanException(pred));
        }
        pred = Conversion.UnBox.create(pred).checkType();
        if (thenBlock != NullStatement.node) {
            this.setOperands(pred, thenBlock, elseBlock);
        } else {
            if (elseBlock == NullStatement.node) {
                this.dettach();
                return NullStatement.node;
            }
            Node node2 = Not.not(pred).checkType();
            node2.setScope(this.getScope());
            this.setOperands(node2, elseBlock, thenBlock);
        }
        this.setTypeDescription(TypeFactory.getVoid());
        return this;
    }

    @Override
    void generate(CodeGenerator codeGenerator) throws CodeGenerationException {
        codeGenerator.generate(this);
    }

    @Override
    Node refactor(CodeStyle ss) {
        super.refactor(ss);
        Node pred = this.getPredicate();
        Node thenBlock = this.getThen();
        Node elseBlock = this.getElse();
        if (!this.hasElse()) {
            If ifnode;
            int thenChildren = thenBlock.childCount();
            Node first = thenBlock.getFirst();
            if (ss.getExitInsideIf() == 2 && thenChildren == 1 && first instanceof Exit) {
                Exit exit = (Exit)first;
                pred.setNext(null);
                exit.andCondition(pred);
                return this.replace(exit);
            }
            if (ss.isGroupNestedIfs() && thenChildren == 1 && first instanceof If && !(ifnode = (If)first).hasElse()) {
                Node ifpred = ifnode.getPredicate();
                Node ifthen = ifnode.getThen();
                pred = this.andCondition(ifpred);
                pred.setNext(ifthen);
                ifthen.setNext(elseBlock);
                return this;
            }
        } else {
            int elseChildren = elseBlock.childCount();
            Node first = elseBlock.getFirst();
            if (ss.getIfInsideElse() == 2 && elseBlock instanceof Block && elseChildren == 1 && first instanceof If) {
                this.setOperands(pred, thenBlock, first);
            }
        }
        return this;
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        assert (this.getKind() != -1) : "'If' not compiled";
        Boolean condition = (Boolean)this.getOp1().notNullValue(rm);
        Node thenBlock = this.getOp2();
        Node elseBlock = this.getOp3();
        if (condition.booleanValue()) {
            return thenBlock.run(rm);
        }
        if (elseBlock != NullStatement.node) {
            return elseBlock.run(rm);
        }
        return null;
    }
}

