/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.compiler.AmbiguousComponentNameException;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.EnumConst;
import oracle.bpm.compiler.LocalVar;
import oracle.bpm.compiler.MemberReference;
import oracle.bpm.compiler.Method;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NotStaticMemberException;
import oracle.bpm.compiler.ObjectClass;
import oracle.bpm.compiler.Scope;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.ThisNotAccessibleException;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.TypeSpec;
import oracle.bpm.compiler.UnsupportedException;
import oracle.bpm.compiler.msg.CompilerMsg;
import oracle.bpm.lang.EnumTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeFactory;
import org.jetbrains.annotations.NonNls;

public class Identifier
extends Node {
    private String id;
    static final long serialVersionUID = -4595688331246131383L;
    static final long serialCheck = -6906310223823943234L;

    public Identifier(Token t) {
        this(t, t.getText());
    }

    public Identifier(Token t, String txt) {
        super(t);
        this.id = txt;
    }

    Identifier(@NonNls String txt) {
        this(null, txt);
    }

    Identifier(String txt, Scope scp) {
        this(txt);
        this.setScope(scp);
    }

    Identifier(String txt, Node declarator) {
        this(txt);
        this.initialize(declarator);
    }

    @Override
    public Node getTargetValue() {
        return this;
    }

    @Override
    public String getText() {
        return this.id;
    }

    @Override
    public String getTypeText() {
        return this.getText();
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    static Node autodeclare(String name, TypeDescription type, Node source, boolean silent) throws TypeException {
        Identifier id = new Identifier(name);
        id.initialize(source);
        id.setParent(source);
        Node result = id.getAutoDeclared(type, silent);
        if (result instanceof LocalVar) {
            LocalVar local = (LocalVar)result;
            local.setSourceId(source);
        }
        return result;
    }

    static Node autodeclare(String prefix, Argument arg, Node orig) throws TypeException {
        Identifier var = new Identifier(prefix + arg.getName(), orig);
        Node result = var.checkType();
        if (result == null) {
            Symbol symbol = new Symbol(prefix, arg);
            orig.getCurrentMember().addDeclaration(symbol);
            result = new LocalVar(symbol, var);
            result.initialize(orig);
            result = result.checkType();
        }
        return result;
    }

    @Override
    Node getAutoDeclared(TypeDescription varType, boolean silentAdd) throws TypeException {
        return this.getAutoDeclared(varType, silentAdd, false);
    }

    Node getAutoDeclared(TypeDescription varType, boolean silentAdd, boolean keepOrigType) throws TypeException {
        assert (varType != null);
        assert (this.getParent() != null) : "I dont have a parent: " + this;
        Node result = this.checkType();
        if (result == null) {
            if (!keepOrigType) {
                varType = this.autodeclared(varType);
            }
            result = this.getCurrentMember().autodeclareLocal(this, this.getText(), varType, silentAdd);
        }
        result.moveHiddenTokensFrom(this);
        return result;
    }

    @Override
    boolean isComplexExpression() {
        return false;
    }

    @Override
    Node checkType() throws TypeException {
        return this.checkType(-1);
    }

    @Override
    Node checkType(int requiredKind) throws TypeException {
        Node result;
        TypeDescription memberType;
        MethodTypeDescription enumMember;
        EnumTypeDescription enumType;
        if (this.getKind() != -1) {
            return this;
        }
        Node parent = this.getParent();
        Node init = this;
        Symbol symbol = this.getSymbolTable().get(this.id);
        if (symbol == null && (enumType = this.getScope().getCurrentEnum()) != null && (enumMember = enumType.findMember(this.id)) != null && (memberType = enumMember.getResultType()).isEnum() && memberType.asEnum() == enumType) {
            MemberReference result2 = new MemberReference(enumType.getText(), this.id);
            result2.setParent(this);
            result2.initialize(this);
            result2.moveHiddenTokensFrom(this);
            EnumConst enumConst = (EnumConst)((Node)result2).checkType(requiredKind);
            enumConst.setOnlyId(true);
            return enumConst;
        }
        if (symbol == null) {
            try {
                TypeDescription type = this.findType(this.id, false);
                if (type != null && (symbol = this.getSymbolTable().get(type.getText())) != null) {
                    init = new TypeSpec(type.get(), init);
                }
            }
            catch (AmbiguousComponentNameException e) {
                // empty catch block
            }
        }
        Symbol target = null;
        MethodTypeDescription member = null;
        if (symbol == null) {
            for (ObjectClass cl = this.getCurrentClass(); cl != null; cl = cl.getParentClass()) {
                MethodTypeDescription foundMember = this.findMember(cl.getTypeDescription(), this.id, 18, null, false, false);
                if (foundMember == null || !foundMember.getResultType().match(requiredKind)) continue;
                member = foundMember;
                break;
            }
            if (member != null) {
                target = this.getThis();
            }
        }
        if (symbol != null && symbol.isMember()) {
            member = symbol.getMember();
            target = symbol.getTarget();
        }
        if (symbol == null && member == null) {
            return null;
        }
        if (member != null) {
            LocalVar targetRef = new LocalVar(target, null);
            targetRef.initialize(this);
            targetRef.setParent(parent);
            targetRef.setSynthetic(true);
            boolean mstatic = member.isStatic();
            if (target == this.getThis() && this.getCurrentMember().isStatic() && !mstatic) {
                throw new NotStaticMemberException(targetRef, this, target.getType());
            }
            MemberReference result3 = new MemberReference(targetRef, this, member);
            result3.setLeftValue(this.isLeftValue());
            result3.initialize(this);
            result3.moveHiddenTokensFrom(this);
            return ((Node)result3).checkType(requiredKind);
        }
        if (symbol.isConstant()) {
            result = Const.valueOf(symbol.getValue().toString(), symbol.getType(), this);
        } else {
            Method currentMethod = this.getCurrentMember();
            assert (currentMethod != null) : "currentMethod cannot be null";
            if (currentMethod.isStatic() && symbol == this.getThis()) {
                throw new ThisNotAccessibleException(this);
            }
            if (currentMethod.isStatic() && symbol.isInstanceVariable()) {
                throw new NotStaticMemberException(this, this, symbol.getType());
            }
            result = new LocalVar(symbol, init);
        }
        result.initialize(this);
        result.moveHiddenTokensFrom(this);
        return result;
    }

    @Override
    void generate(CodeGenerator cg) throws CodeGenerationException {
        cg.generate(this);
    }

    @Override
    void generateSQLCode(StringBuffer sql) {
        sql.append(this.id);
    }

    private TypeDescription autodeclared(TypeDescription type) {
        if (type == null) {
            return null;
        }
        switch (type.getKind()) {
            case 12: {
                return TypeFactory.getArray(this.autodeclared(type.getElementType()));
            }
            case 13: {
                TypeDescription elementType = this.autodeclared(type.getElementType());
                TypeDescription indexType = this.autodeclared(type.getIndexType());
                return type.isOrdered() ? TypeFactory.getSortedMap(elementType, indexType) : TypeFactory.getMap(elementType, indexType);
            }
            case 5: {
                return TypeFactory.getString();
            }
            case 3: {
                return TypeFactory.getDecimal();
            }
            case 9: {
                return TypeFactory.getAny();
            }
        }
        return type;
    }

    public static final class TokenText
    extends Identifier {
        static final long serialVersionUID = 284200176756893108L;
        static final long serialCheck = -8897592366061359093L;

        public TokenText(String id) {
            super(null, id);
        }

        @Override
        public void generate(SourceGenerator cg) {
            cg.generate(this);
        }
    }

    public static final class This
    extends Identifier {
        static final long serialVersionUID = 932813542433644750L;
        static final long serialCheck = 3989181699550792831L;

        public This(Token t) {
            super(t, "this");
        }

        @Override
        public void generate(SourceGenerator cg) {
            cg.generate(this);
        }
    }

    public static final class Super
    extends Identifier {
        static final long serialVersionUID = 5188019267899140766L;
        static final long serialCheck = 1801071285562124357L;

        public Super(Token t) {
            super(t, "super");
        }

        @Override
        public void generate(SourceGenerator cg) {
            cg.generate(this);
        }

        @Override
        Node checkType(int requiredKind) throws TypeException {
            if (this.getKind() == -1) {
                this.reportWarning(new TypeException(this, CompilerMsg.SUPER_NOT_SUPPORTED));
            }
            return super.checkType(requiredKind);
        }

        @Override
        Node checkType() throws TypeException {
            this.reportError(new UnsupportedException(this));
            return super.checkType();
        }
    }

    public static final class Ordered
    extends Identifier {
        static final long serialVersionUID = -7944355455058633770L;
        static final long serialCheck = -2529069998526973313L;

        public Ordered(Token t) {
            super(t, "ordered");
        }
    }

    public static final class Distinct
    extends Identifier {
        static final long serialVersionUID = -5664287887188854348L;
        static final long serialCheck = -5107207708842182437L;

        public Distinct(Token t) {
            super(t, "distinct");
        }
    }
}

