/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.collections.AST;
import oracle.bpm.cil.CilException;
import oracle.bpm.compiler.Args;
import oracle.bpm.compiler.Block;
import oracle.bpm.compiler.CompilerException;
import oracle.bpm.compiler.Deref;
import oracle.bpm.compiler.FieldDeclaration;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.compiler.Invoke;
import oracle.bpm.compiler.MemberAccess;
import oracle.bpm.compiler.Method;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.ObjectClass;
import oracle.bpm.compiler.Return;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.type.Argument;

class ForwardedMethod
extends Method {
    static final long serialVersionUID = 2352405691681717042L;
    static final long serialCheck = 6042564185583290435L;

    ForwardedMethod(ObjectClass current, FieldDeclaration target, MethodTypeDescription method) {
        super(method);
        this.setOverride(!method.getParent().isBpmObject());
        this.setMethodType(method);
        Block statments = new Block();
        statments.addChild((AST)ForwardedMethod.createCall(current, method, target));
        this.setBody(method.getName(), statments);
    }

    @Override
    public void reportWarning(CilException error) {
    }

    @Override
    protected void checkBusinessRule() {
    }

    static Node createCall(ObjectClass cl, MethodTypeDescription method, FieldDeclaration target) {
        return ForwardedMethod.createCall(cl, method, target.createReference(), true);
    }

    static Node createCall(ObjectClass cl, MethodTypeDescription method, Node target, boolean addReturn) {
        Args args = Args.empty(cl.getScope(), 1L);
        Args outArgs = Args.empty(cl.getScope(), 2L);
        args.setNext(outArgs);
        int argc = method.getArgumentCount();
        for (int i = 0; i < argc; ++i) {
            Argument arg = method.getArgument(i);
            if (arg.isIn()) {
                args.addInArgument(arg.getName(), Deref.variable(arg.getName(), cl));
            }
            if (!arg.isOut()) continue;
            outArgs.addOutArgument(Deref.variable(arg.getName(), cl), arg.getName());
        }
        Node call = new Invoke(target, null, method, args, false, null);
        if (!method.getResultType().isVoid() && addReturn) {
            call = new Return(call);
        }
        return call;
    }

    @Override
    String getFullName() {
        return JavaClass.getMethodNameFromSignature(MemberAccess.getSignature(this.getCurrentClass().getTypeDescription(), this.getMethodType()));
    }

    @Override
    void parse(FuegoCompiler compiler) throws CompilerException {
    }
}

