/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.compiler.ArrayConst;
import oracle.bpm.compiler.ArrayReferenceException;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.Declaration;
import oracle.bpm.compiler.DoBlock;
import oracle.bpm.compiler.DuplicatedDeclarationException;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.ExitException;
import oracle.bpm.compiler.FlowContext;
import oracle.bpm.compiler.FlowException;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.IntConst;
import oracle.bpm.compiler.InvalidIndexTypeException;
import oracle.bpm.compiler.LoopStatement;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NullStatement;
import oracle.bpm.compiler.Range;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.SymbolTable;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.UndefinedVariableException;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.util.ArrayUtils;
import oracle.bpm.util.CILUtils;

public class For
extends LoopStatement {
    private Symbol id = null;
    private Node rangeFrom = null;
    private Node rangeTo = null;

    public For(Token t) {
        super(t);
    }

    For() {
    }

    For(Node index, Node set, Node body) {
        index.setNext(set);
        set.setNext(body);
        this.setFirst(index);
        this.initialize(index);
    }

    @Override
    public Node getArray() {
        return this.getOp2();
    }

    public Node getFromRange() {
        return this.rangeFrom;
    }

    @Override
    public Symbol getIdentifier() {
        return this.id;
    }

    @Override
    public String getText() {
        return this.getName() + ":for" + (this.id == null ? "" : "(" + this.id + ")");
    }

    public Node getToRange() {
        return this.rangeTo;
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this, this.getIndex(), this.getArray(), this.getBody());
    }

    @Override
    protected boolean splitToPrint() {
        return true;
    }

    @Override
    FlowContext checkFlow(FlowContext context) throws FlowException {
        this.getArray().checkFlow(context);
        if (this.rangeFrom != null) {
            this.rangeFrom.checkFlow(context);
            this.rangeTo.checkFlow(context);
        }
        FlowContext split = context.split();
        Set<String> exit = split.backupExit();
        this.getIndex().checkFlow(split);
        this.getBody().checkFlow(split);
        split.catchExit(this.getName());
        split.restoreExit(exit);
        context.join(split);
        context.breaksFlow(false);
        return context;
    }

    @Override
    Node checkType() throws TypeException {
        ArrayConst arrayConst;
        TypeDescription indexType;
        if (this.id != null) {
            return this;
        }
        Node index = this.getIndex();
        Node array = this.getArray();
        Node body = this.getBody();
        if ((array = array.checkType()) == null) {
            throw new UndefinedVariableException(this.getArray());
        }
        TypeDescription rangeType = array.getTypeDescription();
        if (array instanceof Range) {
            if (rangeType.getKind() != 2 && !rangeType.isEnum()) {
                throw new InvalidIndexTypeException(array, TypeFactory.getPrimitiveInt(32));
            }
            indexType = rangeType.isEnum() ? rangeType : TypeFactory.getPrimitiveInt(32);
            Range r = (Range)array;
            this.rangeFrom = r.getOp1();
            this.rangeTo = r.getOp2();
        } else {
            if (!rangeType.isArray()) {
                throw new ArrayReferenceException(array, rangeType);
            }
            indexType = rangeType.getIndexType();
            if (indexType == null) {
                indexType = TypeFactory.getPrimitiveInt(32);
            }
        }
        if (index instanceof Declaration) {
            index = index.getOp1();
        }
        String indexName = index.getText();
        SymbolTable symbols = this.getSymbolTable();
        this.id = new Symbol(indexName, indexType);
        this.id.setUniqueSignature("index");
        if (symbols.get(indexName) != null) {
            if (!this.getCurrentLanguage().isLastVersion()) {
                if (this.isGeneratingSource()) {
                    indexName = this.findFreeId(indexName);
                    this.id.setReplacement(new Symbol(indexName, indexType));
                    index = new Identifier(indexName);
                }
            } else {
                this.reportWarning(new DuplicatedDeclarationException(index));
            }
        }
        symbols.push(this.id);
        if (body instanceof DoBlock) {
            DoBlock doblock = (DoBlock)body;
            this.setName(doblock.getName());
        }
        if ((body = body.checkType()) == NullStatement.node) {
            return NullStatement.node;
        }
        ArrayConst arrayConst2 = arrayConst = array instanceof ArrayConst ? (ArrayConst)array : null;
        if (!this.isGeneratingSource() && arrayConst != null && !arrayConst.isMap()) {
            int length = arrayConst.length();
            if (length == 0) {
                return NullStatement.node;
            }
            this.rangeFrom = new IntConst(0L, this);
            this.rangeTo = new IntConst((long)(length - 1), this);
        }
        index.setTypeDescription(indexType);
        this.setOperands(index, array, body);
        this.setTypeDescription(TypeFactory.getVoid());
        return this.processBody(body);
    }

    @Override
    void generate(CodeGenerator cg) throws CodeGenerationException {
        cg.generate(this);
    }

    Node getIndex() {
        return this.getOp1();
    }

    @Override
    boolean isArray() {
        return this.getArray().getTypeDescription().isIndexedArray();
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        block12: {
            TypeDescription arrayType = this.getArray().getTypeDescription();
            Symbol idSymbol = this.getSymbolTable().get(this.id.getName());
            Node block = this.getBody();
            try {
                if (this.rangeFrom != null) {
                    if (arrayType.isNativeEnum()) {
                        Enum fromIndex = (Enum)this.rangeFrom.value(rm);
                        Enum toIndex = (Enum)this.rangeTo.value(rm);
                        Enum index = fromIndex;
                        while (index != null && For.lessOrEqual(index, toIndex)) {
                            idSymbol.setValue(index);
                            block.run(rm);
                            index = CILUtils.increment(index, 1);
                        }
                    } else {
                        Number fromIndex = (Number)this.rangeFrom.value(rm);
                        Number toIndex = (Number)this.rangeTo.value(rm);
                        int from = fromIndex.intValue();
                        int length = toIndex.intValue();
                        for (int index = from; index <= length; ++index) {
                            idSymbol.setValue(index);
                            block.run(rm);
                        }
                    }
                } else if (arrayType.getKind() == 12) {
                    Object array = this.getArray().value(rm);
                    int length = arrayType.isPrimitive() ? ArrayUtils.length(array) : ArrayUtils.length((List)array);
                    for (int index = 0; index < length; ++index) {
                        idSymbol.setValue(index);
                        block.run(rm);
                    }
                } else {
                    Object map = this.getArray().value(rm);
                    Iterator iterator = ArrayUtils.indexIterator((Map)map);
                    while (iterator.hasNext()) {
                        idSymbol.setValue(iterator.next());
                        block.run(rm);
                    }
                }
            }
            catch (ExitException exit) {
                if (exit.getLabel() == null || exit.getLabel().equals(this.getName())) break block12;
                throw exit;
            }
        }
        return null;
    }

    private static boolean lessOrEqual(Enum index, Enum toIndex) {
        return index.compareTo(toIndex) <= 0;
    }
}

