/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.bpm.cil.UsageListener;
import oracle.bpm.compiler.CollectionPool;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NotInitializedException;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.TypeDescription;

class FlowContext {
    private boolean breaks = true;
    private Set<TypeDescription> exceptions;
    private Set<String> exitSet;
    private boolean isCopy = false;
    private FlowContext[] joinArray;
    private UsageListener listener;
    private Map<Symbol, Variable> variables;
    static final FlowContext[] EMPTY_ARRAY = new FlowContext[0];
    private static final String UNNAMED_EXIT = "unnamed$exit";

    FlowContext(UsageListener listener) {
        this(false);
        this.listener = listener;
        this.exitSet = null;
        this.variables = CollectionPool.getHashMap();
        this.exceptions = CollectionPool.getHashSet();
    }

    private FlowContext(boolean isCopy) {
        this.isCopy = isCopy;
    }

    public void setListener(UsageListener listener) {
        this.listener = listener;
    }

    public UsageListener getListener() {
        return this.listener;
    }

    void addException(TypeDescription exception) {
        this.exceptions.add(exception);
    }

    void addExit() {
        if (this.exitSet == null) {
            this.exitSet = CollectionPool.getHashSet();
        }
        this.exitSet.add(UNNAMED_EXIT);
    }

    void addExit(String blockName) {
        if (this.exitSet == null) {
            this.exitSet = CollectionPool.getHashSet();
        }
        this.exitSet.add(blockName);
    }

    Set<String> backupExit() {
        Set<String> set = this.exitSet;
        this.exitSet = null;
        return set;
    }

    void breaksFlow(boolean breaks) {
        this.breaks = breaks;
    }

    boolean breaksFlow() {
        return this.breaks;
    }

    boolean catchException(TypeDescription exception) {
        boolean caught = false;
        Iterator<TypeDescription> it = this.exceptions.iterator();
        while (it.hasNext()) {
            TypeDescription excType = it.next();
            if (!excType.isStrictSubtype(exception)) continue;
            caught = true;
            it.remove();
        }
        return caught;
    }

    boolean catchExit(String blockName) {
        boolean caught = false;
        if (this.exitSet != null && this.exitSet.contains(UNNAMED_EXIT)) {
            caught = true;
            this.exitSet.remove(UNNAMED_EXIT);
        }
        if (blockName != null && !blockName.equals("") && this.exitSet != null && this.exitSet.contains(blockName)) {
            caught = true;
            this.exitSet.remove(blockName);
        }
        return caught;
    }

    Variable defineVariable(Symbol symbol, boolean defaultInit) {
        Variable var = new Variable(symbol.getName(), defaultInit);
        Variable old = this.variables.put(symbol, var);
        if (old != null) {
            throw new IllegalArgumentException("Symbol already defined: " + symbol);
        }
        return var;
    }

    void ensureVariableInit(Symbol symbol) {
        Variable var = this.variables.get(symbol);
        if (var != null) {
            var.ensureInit();
        }
    }

    boolean hasUnCaughtExit() {
        return this.exitSet != null && this.exitSet.size() != 0;
    }

    void initializeVariable(Symbol symbol, Node where) {
        Variable var = this.variables.get(symbol);
        if (var != null) {
            Node prev;
            var.initialize();
            if (where != null && (prev = symbol.setLastUse(where)) == null) {
                where.setFirstSymbolUse(true);
            }
        }
    }

    void join(FlowContext context) {
        this.join(context, true);
    }

    void join(FlowContext context, boolean joinVarInits) {
        assert (context.isCopy) : "Context is not a copy";
        assert (this.exitSet == context.exitSet) : "Context is not my copy";
        if (this.joinArray == null) {
            this.joinArray = new FlowContext[1];
        }
        this.joinArray[0] = context;
        this.join(this.joinArray, joinVarInits);
        this.joinArray[0] = null;
        context.reset();
    }

    void join(FlowContext[] contexts) {
        this.join(contexts, true);
    }

    void join(FlowContext[] contexts, boolean joinVarInits) {
        for (int i = 0; i < contexts.length; ++i) {
            for (Map.Entry<Symbol, Variable> entry : contexts[i].variables.entrySet()) {
                Variable localvar = this.variables.get(entry.getKey());
                if (localvar == null) continue;
                Variable var = entry.getValue();
                if (joinVarInits) {
                    localvar.initialized = localvar.initialized && var.initialized;
                } else {
                    localvar.initialized = localvar.initialized || var.initialized;
                }
                localvar.needsCode = localvar.needsCode || var.needsCode;
                localvar.needsInit = localvar.needsInit || var.needsInit;
            }
        }
    }

    void reset() {
        CollectionPool.releaseHashMap(this.variables);
        this.variables = null;
        this.exitSet = null;
        this.exceptions = null;
        this.breaks = true;
        this.isCopy = false;
    }

    void restoreExit(Set<String> exit) {
        if (this.exitSet != null && exit == null) {
            exit = CollectionPool.getHashSet();
        }
        if (exit != null && this.exitSet != null) {
            exit.addAll(this.exitSet);
        }
        if (this.exitSet != null && !this.isCopy) {
            CollectionPool.releaseHashSet(this.exitSet);
        }
        this.exitSet = exit;
    }

    FlowContext split() {
        FlowContext context = new FlowContext(true);
        if (this.exitSet == null) {
            this.exitSet = CollectionPool.getHashSet();
        }
        context.exitSet = this.exitSet;
        context.exceptions = this.exceptions;
        context.variables = CollectionPool.getHashMap();
        for (Map.Entry<Symbol, Variable> entry : this.variables.entrySet()) {
            context.variables.put(entry.getKey(), entry.getValue().copy());
        }
        context.listener = this.listener;
        return context;
    }

    void use(MethodTypeDescription member, Node where) {
        if (!(this.listener == null || member != null && Modifier.isSynthesized(member.getModifiers()))) {
            int offset = where.getOffset();
            int length = where.getLength();
            this.listener.usage(offset, length, 3);
        }
    }

    void use(Symbol symbol, Node where) throws NotInitializedException {
        Variable var;
        MethodTypeDescription member;
        boolean silent = symbol.isSilentAutoDeclared();
        if (!(this.listener == null || silent || where.isSynthetic() || (member = symbol.getMember()) != null && member.isSynthesized())) {
            int offset = where.getOffset();
            int length = where.getLength();
            this.listener.usage(offset, length, 1);
        }
        if ((var = this.variables.get(symbol)) != null) {
            Node prev;
            var.use(where);
            if (where != null && (prev = symbol.setLastUse(where)) == null) {
                where.setFirstSymbolUse(true);
            }
        }
    }

    static class Variable {
        private boolean defaultInit;
        private boolean initialized = false;
        private String name;
        private boolean needsCode = false;
        private boolean needsInit = false;

        Variable(String name, boolean defaultInit) {
            this.name = name;
            this.defaultInit = defaultInit;
        }

        public String toString() {
            return "Variable[" + this.name + (this.defaultInit ? ", defaultInit" : "") + (this.initialized ? ", initialized" : "") + (this.needsCode ? ", needsCode" : "") + (this.needsInit ? "needsInit" : "") + "]";
        }

        boolean isInitalized() {
            return this.initialized;
        }

        Variable copy() {
            Variable var = new Variable(this.name, this.defaultInit);
            var.initialized = this.initialized;
            var.needsCode = this.needsCode;
            var.needsInit = this.needsInit;
            return var;
        }

        void ensureInit() {
            this.needsCode = true;
            if (!this.initialized) {
                this.needsInit = true;
                this.initialized = true;
            }
        }

        void initialize() {
            this.needsCode = true;
            this.initialized = true;
        }

        boolean needsCode() {
            return this.needsCode;
        }

        boolean needsInitialization() {
            return this.needsInit;
        }

        void use(Node where) throws NotInitializedException {
            if (!this.initialized && !this.defaultInit) {
                throw new NotInitializedException(this.name, where);
            }
            this.needsCode = true;
            if (!this.initialized) {
                this.needsInit = true;
            }
        }
    }
}

