/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import java.util.List;
import java.util.Map;
import oracle.bpm.compiler.Args;
import oracle.bpm.compiler.Block;
import oracle.bpm.compiler.CollectionPool;
import oracle.bpm.compiler.Invoke;
import oracle.bpm.compiler.Method;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.ObjectClass;
import oracle.bpm.compiler.Return;
import oracle.bpm.compiler.Scope;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeFactory;

class ExtractedMethod
extends Method {
    private Map<Symbol, Argument> argsBySymbol;
    private Invoke call;
    private boolean returnArgAssigned = false;
    private List<Node> toBeCompiled;
    private static final long ALLOWED_MODIFIERS = 64L;
    static final long serialVersionUID = 5005993320440479842L;
    static final long serialCheck = 2795682069814074352L;

    private ExtractedMethod(Node tree, String name, TypeDescription resultType) {
        Method currentMember = tree.getCurrentMember();
        this.setMemberToReport(currentMember.getMemberToReport());
        MethodTypeDescription method = new MethodTypeDescription(name);
        long modifiers = currentMember.getModifiers() & 0x40L;
        method.setModifiers(modifiers | 0x100000000L | 0x2000L);
        method.setResultType(resultType);
        method.getResultArgument().setName("result");
        this.setMethodType(method);
        this.setParent(tree.getCurrentClass());
        Invoke call = this.createCall(tree);
        call.setScope(tree.getScope());
        call.setParent(tree.getParent());
        call.setExpression(tree.isExpression());
        this.call = call;
        if (tree.isExpression()) {
            this.setBody(this.getName(), new Return(tree));
        } else {
            this.setBody(this.getName(), tree);
        }
        this.toBeCompiled = CollectionPool.getArrayList();
    }

    public static Invoke create(Node node, String name) throws TypeException {
        TypeDescription resultType = node.isStatement() ? TypeFactory.getVoid() : node.getTypeDescription();
        return ExtractedMethod.create(node, name, resultType);
    }

    public static Invoke create(Node node, String name, TypeDescription resultType) throws TypeException {
        Scope scope = node.getScope();
        assert (scope != null);
        Node parent = node.getParent();
        Node next = node.getNext();
        node.setNext(null);
        ObjectClass currentClass = node.getCurrentClass();
        name = "__" + name;
        int number = 1;
        while (currentClass.findSyntheticMember(name + number) != null) {
            ++number;
        }
        ExtractedMethod method = new ExtractedMethod(node, name + number, resultType);
        method.setParent(currentClass);
        method.setScope(currentClass.getScope());
        method.checkType();
        currentClass.addSyntheticMember(method);
        Invoke result = method.getCall();
        result.setParent(parent);
        result.setScope(scope);
        result = (Invoke)result.checkType();
        result.setNext(next);
        return result;
    }

    public Node addArgument(Node expr) {
        boolean isNewArg;
        TypeDescription exprType = expr.getTypeDescription();
        Symbol symbol = expr.getSymbol();
        Argument arg = symbol != null ? this.argsBySymbol.get(symbol) : null;
        boolean bl = isNewArg = arg == null;
        if (arg == null) {
            MethodTypeDescription method = this.getMethodType();
            String argName = this.assignName(symbol);
            arg = new Argument(argName, exprType, 1L);
            method.addArgument(arg);
            if (symbol != null) {
                this.argsBySymbol.put(symbol, arg);
            }
        }
        Node argRef = this.createArgumentRef(arg.getName());
        argRef.setScope(this.getScope());
        expr.replace(argRef, false);
        this.addToBeCompiled(argRef);
        if (isNewArg) {
            Args inputArgs = this.getCall().getInputArgs();
            inputArgs.addInArgument(expr);
        }
        return argRef;
    }

    public void addOutputArgument(Node leftValue) {
        if (!this.returnArgAssigned) {
            Argument resultArg = this.getMethodType().getResultArgument();
            Node argRef = this.createArgumentRef(resultArg.getName());
            argRef.setScope(this.getScope());
            leftValue.replace(argRef, false);
            this.addToBeCompiled(argRef);
        }
        this.returnArgAssigned = true;
    }

    static void forceCompilation(Node extractedNode) throws TypeException {
        ExtractedMethod method = (ExtractedMethod)extractedNode.getCurrentMember();
        assert (method != null) : "This node was not extracted. Context:\n" + extractedNode.dumpContext();
        method.compileNode(extractedNode);
    }

    Invoke getCall() {
        return this.call;
    }

    @Override
    Node checkType() throws TypeException {
        if (this.toBeCompiled == null) {
            return this;
        }
        Block statements = this.getStatements();
        this.argsBySymbol = CollectionPool.getHashMap();
        statements.extractArguments(this);
        super.checkType();
        int argc = this.toBeCompiled.size();
        for (int i = 0; i < argc; ++i) {
            Node node = this.toBeCompiled.get(i);
            this.compileNode(node);
        }
        CollectionPool.releaseArrayList(this.toBeCompiled);
        CollectionPool.releaseHashMap(this.argsBySymbol);
        this.toBeCompiled = null;
        this.argsBySymbol = null;
        return this;
    }

    private void addToBeCompiled(Node node) {
        this.toBeCompiled.add(node);
    }

    private String assignName(Symbol symbol) {
        String argName;
        MethodTypeDescription method = this.getMethodType();
        if (symbol != null) {
            argName = "extracted_" + symbol.getName();
            argName = argName.replace('.', '_');
        } else {
            int number = 1;
            argName = "extracted_";
            while (method.findArgument(argName + number) != null) {
                ++number;
            }
            argName = argName + number;
        }
        return argName;
    }

    private void compileNode(Node node) throws TypeException {
        Node prev = node.getPrev();
        Node parent = prev == null ? node.getParent() : null;
        Node next = node.getNext();
        node = node.checkType();
        if (prev != null) {
            prev.setNext(node);
        } else {
            parent.setFirst(node);
        }
        node.setNext(next);
    }
}

