/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import fuego.parser.collections.AST;
import oracle.bpm.compiler.Deref;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.MemberAccess;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.QualifiedName;
import oracle.bpm.compiler.SillyOperationException;
import oracle.bpm.compiler.SqlColumnReference;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.UndefinedVariableException;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.sql.ColumnReference;

class Diadic
extends Node {
    static final long serialVersionUID = -6940004579741912081L;
    static final long serialCheck = 4346743059869928248L;

    Diadic() {
    }

    Diadic(Token t) {
        super(t);
    }

    Diadic(AST ast1, AST ast2) {
        this.setOperands((Node)ast1, (Node)ast2);
    }

    void checkSillyOperation(Node op1, Node op2) {
        boolean silly = false;
        String name = null;
        if (this.matchSymbols(op1, op2)) {
            silly = true;
            name = op1.getSymbol().getName();
        } else if (op1 instanceof MemberAccess && op2 instanceof MemberAccess) {
            MemberAccess ma1 = (MemberAccess)op1;
            MemberAccess ma2 = (MemberAccess)op2;
            Node object1 = ma1.getObject();
            Node object2 = ma2.getObject();
            MethodTypeDescription member1 = ma1.getMemberType();
            MethodTypeDescription member2 = ma2.getMemberType();
            if (this.matchSymbols(object1, object2) && member1 != null && member1.equals(member2)) {
                silly = true;
                name = member1.getQualifiedName();
            }
        } else {
            ColumnReference ref1 = op1.getColumnReference();
            if (ref1 != null && ref1.equals(op2.getColumnReference())) {
                name = ref1.getTable().getQualifiedName() + "." + ref1.getName();
                boolean fixed = false;
                try {
                    boolean fuego1 = this.getCurrentLanguage().isFuego1();
                    boolean isSql = op2 instanceof SqlColumnReference;
                    if (fuego1 && isSql) {
                        boolean isId;
                        Node child = op2.getFirst();
                        boolean bl = isId = child instanceof Identifier || child instanceof QualifiedName && child.childCount() == 1;
                        if (isId) {
                            Node id = child instanceof Identifier ? child : child.getFirst();
                            Node deref = new Deref(Diadic.deepCopy(id));
                            deref.setParent(this);
                            deref = deref.checkType();
                            if (deref.getTypeDescription().equality(op2.getTypeDescription())) {
                                SqlColumnReference column = (SqlColumnReference)op2;
                                column.getFirst().replace(deref);
                                column.setForceParamQualification(true);
                                fixed = true;
                            }
                        }
                    }
                }
                catch (TypeException e) {
                    // empty catch block
                }
                if (!fixed) {
                    silly = true;
                }
            }
        }
        if (silly) {
            this.reportWarning(new SillyOperationException(this, name, this.getText()));
        }
    }

    @Override
    Node checkType() throws TypeException {
        Node o1 = this.getOp1();
        Node o2 = this.getOp2();
        try {
            o1 = o1.checkType();
            o2 = o2.checkType(o1.getTypeDescription());
        }
        catch (UndefinedVariableException e) {
            try {
                o2 = o2.checkType();
                o1 = o1.checkType(o2.getTypeDescription());
            }
            catch (UndefinedVariableException e2) {
                this.reportError(e);
                throw e2;
            }
        }
        this.setOperands(o1, o2);
        return this;
    }

    private boolean matchSymbols(Node op1, Node op2) {
        Symbol op1Symbol = op1 != null ? op1.getSymbol() : null;
        Symbol op2Symbol = op2 != null ? op2.getSymbol() : null;
        return op1Symbol != null && op1Symbol.equals(op2Symbol);
    }
}

