/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.msg.CompilerMsg;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.resources.Msg;

public class ConversionException
extends TypeException {
    static final long serialVersionUID = 5325695669363612527L;
    static final long serialCheck = 346109421838151316L;

    public ConversionException(Node node, TypeDescription ot, TypeDescription nt) {
        super(node, ConversionException.createConversionMsg(node, ot, nt));
    }

    public ConversionException(Node node, TypeDescription nt, Object value) {
        super(node, CompilerMsg.INVALIDVALUE(String.valueOf(value), ConversionException.text(nt, node)));
    }

    private static Msg createConversionMsg(Node node, TypeDescription ot, TypeDescription nt) {
        String newType;
        String oldType = ConversionException.text(ot, node);
        if (oldType.equals(newType = ConversionException.text(nt, node))) {
            oldType = ConversionException.text(ot, node, 0);
            newType = ConversionException.text(nt, node, 0);
        }
        return CompilerMsg.CANTCONV(oldType, newType);
    }
}

