/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.compiler.BoolConst;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.ConstFormatException;
import oracle.bpm.compiler.ConstGenerator;
import oracle.bpm.compiler.ConstantPool;
import oracle.bpm.compiler.DecimalConst;
import oracle.bpm.compiler.DefaultConst;
import oracle.bpm.compiler.IntConst;
import oracle.bpm.compiler.IntervalConst;
import oracle.bpm.compiler.Method;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NullConst;
import oracle.bpm.compiler.RealConst;
import oracle.bpm.compiler.StringConst;
import oracle.bpm.compiler.TimeConst;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.TimeFormatException;
import oracle.bpm.lang.TypeDescription;

public abstract class Const
extends Node {
    protected ConstFormatException exception;
    private String constantFieldName = null;
    private boolean used;
    static final long serialVersionUID = -9064297989667004250L;
    static final long serialCheck = 2171916024771057685L;

    Const() {
    }

    Const(Token t, TypeDescription td) {
        super(t);
        if (td != null) {
            this.setTypeDescription(td);
        }
    }

    public abstract void generate(ConstGenerator var1) throws CodeGenerationException;

    public static final Const defaultValue(TypeDescription td, Node n) {
        try {
            Const result = Const.valueOf("", td, n);
            result.setSynthetic(true);
            return result;
        }
        catch (TimeFormatException t) {
            throw new IllegalStateException();
        }
    }

    public Object getPrimitiveValue() {
        return null;
    }

    public String getSyntheticName() {
        return null;
    }

    public void setUsed(boolean b) {
        this.used = b;
    }

    public boolean isUsed() {
        return this.used;
    }

    @Override
    public String toString() {
        return this.getConstantFieldName() == null ? "" : this.getConstantFieldName() + ":";
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    static Const valueOf(String txt, TypeDescription td, Node n) {
        Const result;
        if (txt == null) {
            throw new IllegalArgumentException("txt = null");
        }
        switch (td.getKind()) {
            case 5: {
                result = new StringConst(txt, td.getLength());
                break;
            }
            case 2: {
                result = new IntConst(txt, td);
                break;
            }
            case 4: {
                result = new RealConst(txt, td);
                break;
            }
            case 1: {
                result = new BoolConst(txt, td.isPrimitive());
                break;
            }
            case 6: {
                result = new TimeConst(txt);
                break;
            }
            case 7: {
                result = new IntervalConst(txt);
                break;
            }
            case 3: {
                result = new DecimalConst(txt, td.getLength(), td.getScale());
                break;
            }
            case 11: {
                result = td.hasDefaultInit() ? new DefaultConst(n, td) : new NullConst(n);
                break;
            }
            case 12: 
            case 13: 
            case 19: {
                result = new DefaultConst(n, td);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 16: {
                result = new NullConst(n);
                break;
            }
            case 17: {
                if (td.isPrimitive()) {
                    result = new IntConst(0L);
                    result.setTypeDescription(td);
                    break;
                }
                result = new NullConst(n);
                break;
            }
            default: {
                result = null;
                assert (false) : td.getText();
                break;
            }
        }
        assert (result.getKind() != -1) : result;
        result.initialize(n);
        if (result.getParent() == null) {
            result.copyParentFrom(n);
        }
        return result;
    }

    static String createSyntheticNameFromType(TypeDescription td, String value) {
        String type = td.getJavaType();
        type = type.substring(type.lastIndexOf(46) + 1).toUpperCase();
        return type + '$' + value.replaceAll("[^\\p{javaJavaIdentifierPart}]+", "_").toUpperCase();
    }

    boolean isCollectable() {
        return true;
    }

    @Override
    boolean isComplexExpression() {
        return false;
    }

    void setConstantFieldName(String constantFieldName) {
        this.constantFieldName = constantFieldName;
    }

    String getConstantFieldName() {
        return this.constantFieldName;
    }

    boolean isInitialized() {
        return true;
    }

    @Override
    void setPrimitive(boolean primitive) {
        super.setPrimitive(primitive);
        this.setTypeDescription(this.getTypeDescription().primitiveEquivalent(primitive));
    }

    @Override
    Node checkType() throws TypeException {
        if (this.exception != null) {
            Method currentMember = this.getCurrentMember();
            assert (currentMember != null) : "Current member not found. Context: " + this.dumpContext();
            this.exception.setMember(currentMember.getTypeDescription());
            this.reportError(this.exception);
        }
        return this;
    }

    @Override
    void collectConstants(ConstantPool cp) {
        super.collectConstants(cp);
        if (this.isCollectable()) {
            cp.add(this);
        }
    }

    Const compute(int op, Node b) {
        throw new IllegalStateException();
    }

    Const convertTo(TypeDescription targetType) throws TypeException {
        if (targetType.isAny() || targetType.getKind() == 11) {
            TypeDescription type = this.getTypeDescription();
            targetType = type.isArray() ? type : type.primitiveEquivalent(false);
        } else if (targetType.getKind() == 15) {
            return null;
        }
        return Const.valueOf(this.getText(), targetType, this);
    }

    @Override
    boolean isConstant() {
        return true;
    }

    @Override
    final void generate(CodeGenerator cg) throws CodeGenerationException {
        cg.generate(this);
    }
}

